/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.routing;

import com.ghostchu.peerbanhelper.databasent.routing.DataSourceContext;
import com.ghostchu.peerbanhelper.databasent.routing.DataSourceType;
import lombok.Generated;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SQLTypeDetectorInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SQLTypeDetectorInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        if (DataSourceContext.isBound()) {
            if (log.isTraceEnabled()) {
                log.trace("DataSource already bound to {}, skipping SQL type detection", (Object)DataSourceContext.getDataSourceType());
            }
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        DataSourceType dataSourceType = this.determinDataSourceType(sqlCommandType);
        if (log.isDebugEnabled()) {
            log.debug("Auto-detected SQL type {} for statement [{}], routing to {} datasource", new Object[]{sqlCommandType, mappedStatement.getId(), dataSourceType});
        }
        return ScopedValue.where(DataSourceContext.getScopedValue(), dataSourceType).call(() -> {
            try {
                return invocation.proceed();
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private DataSourceType determinDataSourceType(SqlCommandType sqlCommandType) {
        return switch (sqlCommandType) {
            default -> throw new MatchException(null, null);
            case SqlCommandType.SELECT -> DataSourceType.READ;
            case SqlCommandType.INSERT, SqlCommandType.UPDATE, SqlCommandType.DELETE -> DataSourceType.WRITE;
            case SqlCommandType.FLUSH, SqlCommandType.UNKNOWN -> {
                if (log.isDebugEnabled()) {
                    log.debug("Encountered {} SQL command, defaulting to WRITE datasource for safety", (Object)sqlCommandType);
                }
                yield DataSourceType.WRITE;
            }
        };
    }
}

