/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.routing;

import com.ghostchu.peerbanhelper.databasent.routing.DataSourceContext;
import com.ghostchu.peerbanhelper.databasent.routing.DataSourceType;
import java.lang.reflect.Method;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Aspect
@Component
@Order(value=0)
public class TransactionalDataSourceAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionalDataSourceAspect.class);

    @Pointcut(value="@annotation(org.springframework.transaction.annotation.Transactional)")
    public void transactionalPointcut() {
    }

    @Around(value="transactionalPointcut()")
    public Object aroundTransactional(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (transactional == null) {
            transactional = joinPoint.getTarget().getClass().getAnnotation(Transactional.class);
        }
        if (transactional == null) {
            return joinPoint.proceed();
        }
        DataSourceType requestedType = transactional.readOnly() ? DataSourceType.READ : DataSourceType.WRITE;
        DataSourceType effectiveType = DataSourceContext.getEffectiveType(requestedType);
        if (DataSourceContext.isBound() && DataSourceContext.getDataSourceType() == effectiveType) {
            if (log.isTraceEnabled()) {
                log.trace("Already in {} datasource context for transaction, proceeding directly", (Object)effectiveType);
            }
            return joinPoint.proceed();
        }
        if (log.isDebugEnabled()) {
            String methodName = method.getDeclaringClass().getSimpleName() + "." + method.getName();
            if (effectiveType != requestedType) {
                log.debug("Transaction [{}] requested {} (readOnly={}) but using {} due to nesting rules", new Object[]{methodName, requestedType, transactional.readOnly(), effectiveType});
            } else {
                log.debug("Transaction [{}] using {} datasource (readOnly={})", new Object[]{methodName, effectiveType, transactional.readOnly()});
            }
        }
        try {
            return ScopedValue.where(DataSourceContext.getScopedValue(), effectiveType).call(() -> {
                try {
                    return joinPoint.proceed();
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }
}

