/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ghostchu.peerbanhelper.databasent.mapper.java.PCBAddressMapper;
import com.ghostchu.peerbanhelper.databasent.routing.WriteTransactionTemplate;
import com.ghostchu.peerbanhelper.databasent.service.PCBAddressService;
import com.ghostchu.peerbanhelper.databasent.table.PCBAddressEntity;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PCBAddressServiceImpl
extends ServiceImpl<PCBAddressMapper, PCBAddressEntity>
implements PCBAddressService {
    @Autowired
    private WriteTransactionTemplate writeTransactionTemplate;

    @Override
    public List<PCBAddressEntity> fetchFromDatabase(@NotNull String torrentId, @NotNull String downloader) {
        return ((PCBAddressMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PCBAddressEntity::getTorrentId, (Object)torrentId)).eq(PCBAddressEntity::getDownloader, (Object)downloader));
    }

    @Override
    public PCBAddressEntity fetchFromDatabase(@NotNull String torrentId, @NotNull InetAddress ip, int port, @NotNull String downloader) {
        return (PCBAddressEntity)((PCBAddressMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PCBAddressEntity::getTorrentId, (Object)torrentId)).eq(PCBAddressEntity::getIp, (Object)ip)).eq(PCBAddressEntity::getPort, (Object)port)).eq(PCBAddressEntity::getDownloader, (Object)downloader));
    }

    @Override
    public int deleteEntry(@NotNull String torrentId, @NotNull InetAddress ip) {
        return ((PCBAddressMapper)this.baseMapper).delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PCBAddressEntity::getTorrentId, (Object)torrentId)).eq(PCBAddressEntity::getIp, (Object)ip));
    }

    @Override
    public int cleanupDatabase(OffsetDateTime timestamp) {
        Integer changes;
        int deleted = 0;
        while ((changes = (Integer)this.writeTransactionTemplate.execute(status -> ((PCBAddressMapper)this.baseMapper).delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().lt(PCBAddressEntity::getLastTimeSeen, (Object)timestamp)).last("LIMIT 150")))) != null && changes > 0) {
            deleted += changes.intValue();
        }
        return deleted;
    }
}

