/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ghostchu.peerbanhelper.databasent.dto.TrafficDataComputed;
import com.ghostchu.peerbanhelper.databasent.mapper.java.TrafficJournalMapper;
import com.ghostchu.peerbanhelper.databasent.service.TrafficJournalService;
import com.ghostchu.peerbanhelper.databasent.table.TrafficJournalEntity;
import com.ghostchu.peerbanhelper.downloader.DownloaderSpeedLimiter;
import com.ghostchu.peerbanhelper.util.TimeUtil;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
public class TrafficJournalServiceImpl
extends ServiceImpl<TrafficJournalMapper, TrafficJournalEntity>
implements TrafficJournalService {
    @Override
    public void updateData(@NotNull String downloader, long overallDownloaded, long overallUploaded, long overallDownloadedProtocol, long overallUploadedProtocol) {
        OffsetDateTime timestamp = TimeUtil.getStartOfHour(System.currentTimeMillis());
        TrafficJournalEntity entityInDb = (TrafficJournalEntity)((TrafficJournalMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrafficJournalEntity::getDownloader, (Object)downloader)).eq(TrafficJournalEntity::getTimestamp, (Object)timestamp));
        if (entityInDb == null) {
            entityInDb = new TrafficJournalEntity();
            entityInDb.setTimestamp(timestamp);
            entityInDb.setDownloader(downloader);
            entityInDb.setDataOverallDownloadedAtStart(overallDownloaded);
            entityInDb.setDataOverallUploadedAtStart(overallUploaded);
            entityInDb.setProtocolOverallDownloadedAtStart(overallDownloadedProtocol);
            entityInDb.setProtocolOverallUploadedAtStart(overallUploadedProtocol);
        }
        if (entityInDb.getDataOverallDownloaded() < overallDownloaded) {
            entityInDb.setDataOverallDownloaded(overallDownloaded);
        }
        if (entityInDb.getDataOverallUploaded() < overallUploaded) {
            entityInDb.setDataOverallUploaded(overallUploaded);
        }
        if (entityInDb.getProtocolOverallDownloaded() < overallDownloadedProtocol) {
            entityInDb.setProtocolOverallDownloaded(overallDownloadedProtocol);
        }
        if (entityInDb.getProtocolOverallUploaded() < overallUploadedProtocol) {
            entityInDb.setProtocolOverallUploaded(overallUploadedProtocol);
        }
        ((TrafficJournalMapper)this.baseMapper).insertOrUpdate(entityInDb);
    }

    @Override
    public TrafficDataComputed getTodayData(@Nullable String downloader) {
        OffsetDateTime startOfToday = TimeUtil.getStartOfToday(System.currentTimeMillis());
        OffsetDateTime endOfToday = TimeUtil.getEndOfToday(System.currentTimeMillis());
        List results = downloader == null || downloader.isBlank() ? this.getAllDownloadersOverallData(startOfToday, endOfToday).stream().toList() : this.getSpecificDownloaderOverallData(downloader, startOfToday, endOfToday).stream().toList();
        if (results.isEmpty()) {
            return new TrafficDataComputed(startOfToday, 0L, 0L);
        }
        return new TrafficDataComputed(startOfToday, results.stream().mapToLong(TrafficDataComputed::getDataOverallUploaded).sum(), results.stream().mapToLong(TrafficDataComputed::getDataOverallDownloaded).sum());
    }

    @Override
    public List<TrafficDataComputed> getDayOffsetData(String downloader, OffsetDateTime startAt, OffsetDateTime endAt) {
        List<TrafficDataComputed> results = downloader == null || downloader.isBlank() ? this.getAllDownloadersOverallData(startAt, endAt).stream().toList() : this.getSpecificDownloaderOverallData(downloader, startAt, endAt).stream().toList();
        return results;
    }

    @Override
    public List<TrafficDataComputed> getAllDownloadersOverallData(OffsetDateTime start, OffsetDateTime end) {
        return ((TrafficJournalMapper)this.baseMapper).selectAllDownloadersOverallData(start, end);
    }

    @Override
    public List<TrafficDataComputed> getSpecificDownloaderOverallData(String downloadName, OffsetDateTime start, OffsetDateTime end) {
        return ((TrafficJournalMapper)this.baseMapper).selectSpecificDownloaderOverallData(downloadName, start, end);
    }

    @Override
    @NotNull
    public SlidingWindowDynamicSpeedLimiter tweakSpeedLimiterBySlidingWindow(@Nullable String downloader, @NotNull DownloaderSpeedLimiter currentSetting, long thresholdBytes, long minSpeedBytesPerSecond, long maxSpeedBytesPerSecond) {
        long newSpeed;
        SlidingWindowDynamicSpeedLimiter slidingWindowDynamicSpeedLimiter = new SlidingWindowDynamicSpeedLimiter();
        slidingWindowDynamicSpeedLimiter.setThreshold(thresholdBytes);
        slidingWindowDynamicSpeedLimiter.setMaxSpeed(maxSpeedBytesPerSecond);
        slidingWindowDynamicSpeedLimiter.setMinSpeed(minSpeedBytesPerSecond);
        Duration windowSize = Duration.ofHours(24L);
        long windowSizeMillis = windowSize.toMillis();
        slidingWindowDynamicSpeedLimiter.setWindowSizeMillis(windowSizeMillis);
        OffsetDateTime endTimestamp = OffsetDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS);
        OffsetDateTime startTimestamp = endTimestamp.minus(windowSize);
        slidingWindowDynamicSpeedLimiter.setWindowStartTime(startTimestamp.toInstant().toEpochMilli());
        List<TrafficDataComputed> trafficData = downloader == null ? this.getAllDownloadersOverallData(startTimestamp, endTimestamp) : this.getSpecificDownloaderOverallData(downloader, startTimestamp, endTimestamp);
        long totalUploadedBytes = trafficData.stream().mapToLong(TrafficDataComputed::getDataOverallUploaded).sum();
        slidingWindowDynamicSpeedLimiter.setUploadedInWindow(totalUploadedBytes);
        long currentSpeedLimit = currentSetting.upload();
        slidingWindowDynamicSpeedLimiter.setOldSpeedLimit(currentSpeedLimit);
        if (totalUploadedBytes >= thresholdBytes) {
            if (currentSpeedLimit <= minSpeedBytesPerSecond) {
                newSpeed = minSpeedBytesPerSecond;
                slidingWindowDynamicSpeedLimiter.setReachedMinimumSpeed(true);
            } else {
                double b = thresholdBytes > 0L ? (double)totalUploadedBytes / (double)thresholdBytes : 1.0;
                newSpeed = Math.max(minSpeedBytesPerSecond, (long)((double)currentSpeedLimit / b));
                slidingWindowDynamicSpeedLimiter.setDecreaseFactor(b);
            }
        } else if (currentSpeedLimit >= maxSpeedBytesPerSecond && maxSpeedBytesPerSecond > 0L) {
            newSpeed = maxSpeedBytesPerSecond;
        } else {
            double a = (double)(thresholdBytes - totalUploadedBytes) / (double)windowSizeMillis * 1000.0;
            newSpeed = Math.min(maxSpeedBytesPerSecond, Math.addExact(currentSpeedLimit, (long)a));
            slidingWindowDynamicSpeedLimiter.setIncreaseFactor(a);
        }
        slidingWindowDynamicSpeedLimiter.setNewSpeedLimit(newSpeed);
        return slidingWindowDynamicSpeedLimiter;
    }

    public static class SlidingWindowDynamicSpeedLimiter {
        private Long windowSizeMillis;
        private Long windowStartTime;
        private Long uploadedInWindow;
        private Long oldSpeedLimit;
        private Long newSpeedLimit;
        private Long threshold;
        private Long minSpeed;
        private Long maxSpeed;
        private Double increaseFactor;
        private Double decreaseFactor;
        private Boolean reachedMaximumSpeed;
        private Boolean reachedMinimumSpeed;

        @Generated
        public Long getWindowSizeMillis() {
            return this.windowSizeMillis;
        }

        @Generated
        public Long getWindowStartTime() {
            return this.windowStartTime;
        }

        @Generated
        public Long getUploadedInWindow() {
            return this.uploadedInWindow;
        }

        @Generated
        public Long getOldSpeedLimit() {
            return this.oldSpeedLimit;
        }

        @Generated
        public Long getNewSpeedLimit() {
            return this.newSpeedLimit;
        }

        @Generated
        public Long getThreshold() {
            return this.threshold;
        }

        @Generated
        public Long getMinSpeed() {
            return this.minSpeed;
        }

        @Generated
        public Long getMaxSpeed() {
            return this.maxSpeed;
        }

        @Generated
        public Double getIncreaseFactor() {
            return this.increaseFactor;
        }

        @Generated
        public Double getDecreaseFactor() {
            return this.decreaseFactor;
        }

        @Generated
        public Boolean getReachedMaximumSpeed() {
            return this.reachedMaximumSpeed;
        }

        @Generated
        public Boolean getReachedMinimumSpeed() {
            return this.reachedMinimumSpeed;
        }

        @Generated
        public void setWindowSizeMillis(Long windowSizeMillis) {
            this.windowSizeMillis = windowSizeMillis;
        }

        @Generated
        public void setWindowStartTime(Long windowStartTime) {
            this.windowStartTime = windowStartTime;
        }

        @Generated
        public void setUploadedInWindow(Long uploadedInWindow) {
            this.uploadedInWindow = uploadedInWindow;
        }

        @Generated
        public void setOldSpeedLimit(Long oldSpeedLimit) {
            this.oldSpeedLimit = oldSpeedLimit;
        }

        @Generated
        public void setNewSpeedLimit(Long newSpeedLimit) {
            this.newSpeedLimit = newSpeedLimit;
        }

        @Generated
        public void setThreshold(Long threshold) {
            this.threshold = threshold;
        }

        @Generated
        public void setMinSpeed(Long minSpeed) {
            this.minSpeed = minSpeed;
        }

        @Generated
        public void setMaxSpeed(Long maxSpeed) {
            this.maxSpeed = maxSpeed;
        }

        @Generated
        public void setIncreaseFactor(Double increaseFactor) {
            this.increaseFactor = increaseFactor;
        }

        @Generated
        public void setDecreaseFactor(Double decreaseFactor) {
            this.decreaseFactor = decreaseFactor;
        }

        @Generated
        public void setReachedMaximumSpeed(Boolean reachedMaximumSpeed) {
            this.reachedMaximumSpeed = reachedMaximumSpeed;
        }

        @Generated
        public void setReachedMinimumSpeed(Boolean reachedMinimumSpeed) {
            this.reachedMinimumSpeed = reachedMinimumSpeed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlidingWindowDynamicSpeedLimiter)) {
                return false;
            }
            SlidingWindowDynamicSpeedLimiter other = (SlidingWindowDynamicSpeedLimiter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$windowSizeMillis = this.getWindowSizeMillis();
            Long other$windowSizeMillis = other.getWindowSizeMillis();
            if (this$windowSizeMillis == null ? other$windowSizeMillis != null : !((Object)this$windowSizeMillis).equals(other$windowSizeMillis)) {
                return false;
            }
            Long this$windowStartTime = this.getWindowStartTime();
            Long other$windowStartTime = other.getWindowStartTime();
            if (this$windowStartTime == null ? other$windowStartTime != null : !((Object)this$windowStartTime).equals(other$windowStartTime)) {
                return false;
            }
            Long this$uploadedInWindow = this.getUploadedInWindow();
            Long other$uploadedInWindow = other.getUploadedInWindow();
            if (this$uploadedInWindow == null ? other$uploadedInWindow != null : !((Object)this$uploadedInWindow).equals(other$uploadedInWindow)) {
                return false;
            }
            Long this$oldSpeedLimit = this.getOldSpeedLimit();
            Long other$oldSpeedLimit = other.getOldSpeedLimit();
            if (this$oldSpeedLimit == null ? other$oldSpeedLimit != null : !((Object)this$oldSpeedLimit).equals(other$oldSpeedLimit)) {
                return false;
            }
            Long this$newSpeedLimit = this.getNewSpeedLimit();
            Long other$newSpeedLimit = other.getNewSpeedLimit();
            if (this$newSpeedLimit == null ? other$newSpeedLimit != null : !((Object)this$newSpeedLimit).equals(other$newSpeedLimit)) {
                return false;
            }
            Long this$threshold = this.getThreshold();
            Long other$threshold = other.getThreshold();
            if (this$threshold == null ? other$threshold != null : !((Object)this$threshold).equals(other$threshold)) {
                return false;
            }
            Long this$minSpeed = this.getMinSpeed();
            Long other$minSpeed = other.getMinSpeed();
            if (this$minSpeed == null ? other$minSpeed != null : !((Object)this$minSpeed).equals(other$minSpeed)) {
                return false;
            }
            Long this$maxSpeed = this.getMaxSpeed();
            Long other$maxSpeed = other.getMaxSpeed();
            if (this$maxSpeed == null ? other$maxSpeed != null : !((Object)this$maxSpeed).equals(other$maxSpeed)) {
                return false;
            }
            Double this$increaseFactor = this.getIncreaseFactor();
            Double other$increaseFactor = other.getIncreaseFactor();
            if (this$increaseFactor == null ? other$increaseFactor != null : !((Object)this$increaseFactor).equals(other$increaseFactor)) {
                return false;
            }
            Double this$decreaseFactor = this.getDecreaseFactor();
            Double other$decreaseFactor = other.getDecreaseFactor();
            if (this$decreaseFactor == null ? other$decreaseFactor != null : !((Object)this$decreaseFactor).equals(other$decreaseFactor)) {
                return false;
            }
            Boolean this$reachedMaximumSpeed = this.getReachedMaximumSpeed();
            Boolean other$reachedMaximumSpeed = other.getReachedMaximumSpeed();
            if (this$reachedMaximumSpeed == null ? other$reachedMaximumSpeed != null : !((Object)this$reachedMaximumSpeed).equals(other$reachedMaximumSpeed)) {
                return false;
            }
            Boolean this$reachedMinimumSpeed = this.getReachedMinimumSpeed();
            Boolean other$reachedMinimumSpeed = other.getReachedMinimumSpeed();
            return !(this$reachedMinimumSpeed == null ? other$reachedMinimumSpeed != null : !((Object)this$reachedMinimumSpeed).equals(other$reachedMinimumSpeed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SlidingWindowDynamicSpeedLimiter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $windowSizeMillis = this.getWindowSizeMillis();
            result = result * 59 + ($windowSizeMillis == null ? 43 : ((Object)$windowSizeMillis).hashCode());
            Long $windowStartTime = this.getWindowStartTime();
            result = result * 59 + ($windowStartTime == null ? 43 : ((Object)$windowStartTime).hashCode());
            Long $uploadedInWindow = this.getUploadedInWindow();
            result = result * 59 + ($uploadedInWindow == null ? 43 : ((Object)$uploadedInWindow).hashCode());
            Long $oldSpeedLimit = this.getOldSpeedLimit();
            result = result * 59 + ($oldSpeedLimit == null ? 43 : ((Object)$oldSpeedLimit).hashCode());
            Long $newSpeedLimit = this.getNewSpeedLimit();
            result = result * 59 + ($newSpeedLimit == null ? 43 : ((Object)$newSpeedLimit).hashCode());
            Long $threshold = this.getThreshold();
            result = result * 59 + ($threshold == null ? 43 : ((Object)$threshold).hashCode());
            Long $minSpeed = this.getMinSpeed();
            result = result * 59 + ($minSpeed == null ? 43 : ((Object)$minSpeed).hashCode());
            Long $maxSpeed = this.getMaxSpeed();
            result = result * 59 + ($maxSpeed == null ? 43 : ((Object)$maxSpeed).hashCode());
            Double $increaseFactor = this.getIncreaseFactor();
            result = result * 59 + ($increaseFactor == null ? 43 : ((Object)$increaseFactor).hashCode());
            Double $decreaseFactor = this.getDecreaseFactor();
            result = result * 59 + ($decreaseFactor == null ? 43 : ((Object)$decreaseFactor).hashCode());
            Boolean $reachedMaximumSpeed = this.getReachedMaximumSpeed();
            result = result * 59 + ($reachedMaximumSpeed == null ? 43 : ((Object)$reachedMaximumSpeed).hashCode());
            Boolean $reachedMinimumSpeed = this.getReachedMinimumSpeed();
            result = result * 59 + ($reachedMinimumSpeed == null ? 43 : ((Object)$reachedMinimumSpeed).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TrafficJournalServiceImpl.SlidingWindowDynamicSpeedLimiter(windowSizeMillis=" + this.getWindowSizeMillis() + ", windowStartTime=" + this.getWindowStartTime() + ", uploadedInWindow=" + this.getUploadedInWindow() + ", oldSpeedLimit=" + this.getOldSpeedLimit() + ", newSpeedLimit=" + this.getNewSpeedLimit() + ", threshold=" + this.getThreshold() + ", minSpeed=" + this.getMinSpeed() + ", maxSpeed=" + this.getMaxSpeed() + ", increaseFactor=" + this.getIncreaseFactor() + ", decreaseFactor=" + this.getDecreaseFactor() + ", reachedMaximumSpeed=" + this.getReachedMaximumSpeed() + ", reachedMinimumSpeed=" + this.getReachedMinimumSpeed() + ")";
        }

        @Generated
        public SlidingWindowDynamicSpeedLimiter() {
        }

        @Generated
        public SlidingWindowDynamicSpeedLimiter(Long windowSizeMillis, Long windowStartTime, Long uploadedInWindow, Long oldSpeedLimit, Long newSpeedLimit, Long threshold, Long minSpeed, Long maxSpeed, Double increaseFactor, Double decreaseFactor, Boolean reachedMaximumSpeed, Boolean reachedMinimumSpeed) {
            this.windowSizeMillis = windowSizeMillis;
            this.windowStartTime = windowStartTime;
            this.uploadedInWindow = uploadedInWindow;
            this.oldSpeedLimit = oldSpeedLimit;
            this.newSpeedLimit = newSpeedLimit;
            this.threshold = threshold;
            this.minSpeed = minSpeed;
            this.maxSpeed = maxSpeed;
            this.increaseFactor = increaseFactor;
            this.decreaseFactor = decreaseFactor;
            this.reachedMaximumSpeed = reachedMaximumSpeed;
            this.reachedMinimumSpeed = reachedMinimumSpeed;
        }
    }
}

