/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader.impl.deluge;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.peer.PeerFlag;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.bittorrent.tracker.Tracker;
import com.ghostchu.peerbanhelper.downloader.AbstractDownloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderSpeedLimiter;
import com.ghostchu.peerbanhelper.downloader.DownloaderStatistics;
import com.ghostchu.peerbanhelper.downloader.impl.deluge.DelugePeer;
import com.ghostchu.peerbanhelper.downloader.impl.deluge.DelugeTorrent;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.StrUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProvider;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import inet.ipaddr.IPAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.DelugeServer;
import raccoonfink.deluge.requests.ConfigRequest;
import raccoonfink.deluge.responses.ConfigResponse;
import raccoonfink.deluge.responses.DelugeListMethodsResponse;
import raccoonfink.deluge.responses.PBHActiveTorrentsResponse;
import raccoonfink.deluge.responses.PBHStatisticsResponse;

public final class Deluge
extends AbstractDownloader {
    private static final Logger log = LoggerFactory.getLogger(Deluge.class);
    private static final List<String> MUST_HAVE_METHODS = ImmutableList.of((Object)"peerbanhelperadapter.replace_blocklist", (Object)"peerbanhelperadapter.unban_ips", (Object)"peerbanhelperadapter.get_active_torrents_info", (Object)"peerbanhelperadapter.ban_ips");
    private final DelugeServer client;
    private final Config config;

    public Deluge(String id, Config config, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        super(id, alertManager, natAddressProvider);
        this.config = config;
        this.client = new DelugeServer(config.getEndpoint() + config.getRpcUrl(), config.getPassword(), config.isVerifySsl(), httpUtil, null, null);
    }

    @Override
    @NotNull
    public String getName() {
        return this.config.getName();
    }

    public static Deluge loadFromConfig(String id, ConfigurationSection section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        Config config = Config.readFromYaml(section, id);
        return new Deluge(id, config, alertManager, httpUtil, natAddressProvider);
    }

    public static Deluge loadFromConfig(String id, JsonObject section, AlertManager alertManager, HTTPUtil httpUtil, NatAddressProvider natAddressProvider) {
        Config config = (Config)JsonUtil.getGson().fromJson(section.toString(), Config.class);
        return new Deluge(id, config, alertManager, httpUtil, natAddressProvider);
    }

    @Override
    @NotNull
    public JsonObject saveDownloaderJson() {
        return JsonUtil.getGson().toJsonTree((Object)this.config).getAsJsonObject();
    }

    @Override
    @NotNull
    public YamlConfiguration saveDownloader() {
        return this.config.saveToYaml();
    }

    @Override
    @NotNull
    public String getEndpoint() {
        return this.config.getEndpoint();
    }

    @Override
    @NotNull
    public String getType() {
        return "Deluge";
    }

    @Override
    public boolean isPaused() {
        return this.config.isPaused();
    }

    @Override
    public void setPaused(boolean paused) {
        super.setPaused(paused);
        this.config.setPaused(paused);
    }

    @Override
    public int getMaxConcurrentPeerRequestSlots() {
        return ExternalSwitch.parseInt("pbh.downloader.Deluge.maxConcurrentPeerRequestSlots", 32);
    }

    @Override
    public DownloaderLoginResult login0() {
        try {
            if (!this.client.login().isLoggedIn()) {
                return new DownloaderLoginResult(DownloaderLoginResult.Status.INCORRECT_CREDENTIAL, new TranslationComponent(Lang.DOWNLOADER_LOGIN_INCORRECT_CRED));
            }
            DelugeListMethodsResponse listMethodsResponse = this.client.listMethods();
            if (!new HashSet<String>(listMethodsResponse.getDelugeSupportedMethods()).containsAll(MUST_HAVE_METHODS)) {
                return new DownloaderLoginResult(DownloaderLoginResult.Status.MISSING_COMPONENTS, new TranslationComponent(Lang.DOWNLOADER_DELUGE_PLUGIN_NOT_INSTALLED));
            }
            return new DownloaderLoginResult(DownloaderLoginResult.Status.SUCCESS, new TranslationComponent(Lang.STATUS_TEXT_OK));
        }
        catch (DelugeException e) {
            return new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(Lang.DOWNLOADER_LOGIN_IO_EXCEPTION, e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Override
    @NotNull
    public List<Torrent> getTorrents() {
        ArrayList<Torrent> torrents = new ArrayList<Torrent>();
        try {
            for (PBHActiveTorrentsResponse.ActiveTorrentsResponseDTO activeTorrent : this.client.getActiveTorrents().getActiveTorrents()) {
                ArrayList<Peer> peers = new ArrayList<Peer>();
                for (PBHActiveTorrentsResponse.ActiveTorrentsResponseDTO.PeersDTO peer : activeTorrent.getPeers()) {
                    DelugePeer delugePeer;
                    String peerId = StrUtil.toStringHex(peer.getPeerId());
                    if (peerId.length() > 8) {
                        peerId = peerId.substring(0, 8);
                    }
                    if ((delugePeer = new DelugePeer(this.natTranslate(new PeerAddress(peer.getIp(), peer.getPort(), peer.getIp())), peerId, peer.getClientName(), peer.getTotalDownload(), peer.getPayloadDownSpeed(), peer.getTotalUpload(), peer.getPayloadUpSpeed(), peer.getProgress() / 100.0, this.parsePeerFlag(peer.getFlags(), peer.getSource()))).getPeerAddress().getIp() == null || delugePeer.getPeerAddress().getIp().isBlank()) continue;
                    peers.add(delugePeer);
                }
                DelugeTorrent torrent = new DelugeTorrent(activeTorrent.getId(), activeTorrent.getName(), activeTorrent.getInfoHash(), activeTorrent.getProgress() / 100.0, activeTorrent.getSize(), activeTorrent.getCompletedSize(), activeTorrent.getUploadPayloadRate(), activeTorrent.getDownloadPayloadRate(), peers, activeTorrent.getPriv() != null && activeTorrent.getPriv() != false);
                torrents.add(torrent);
            }
        }
        catch (DelugeException e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_DELUGE_API_ERROR, new Object[0]), (Throwable)e);
        }
        return torrents;
    }

    @Override
    @NotNull
    public List<Torrent> getAllTorrents() {
        return this.getTorrents();
    }

    @Override
    @NotNull
    public List<Peer> getPeers(@NotNull Torrent torrent) {
        if (!(torrent instanceof DelugeTorrent)) {
            throw new IllegalStateException("The torrent object not a instance of DelugeTorrent");
        }
        DelugeTorrent delugeTorrent = (DelugeTorrent)torrent;
        return delugeTorrent.getPeers();
    }

    @Override
    @NotNull
    public List<Tracker> getTrackers(@NotNull Torrent torrent) {
        return List.of();
    }

    @Override
    public void setTrackers(@NotNull Torrent torrent, @NotNull List<Tracker> trackers) {
    }

    @Override
    public void setBanList(@NotNull Collection<IPAddress> fullList, @Nullable Collection<BanMetadata> added, @Nullable Collection<BanMetadata> removed, boolean applyFullList) {
        if (removed != null && removed.isEmpty() && added != null && this.config.isIncrementBan() && !applyFullList) {
            this.setBanListIncrement(added);
        } else {
            this.setBanListFull(fullList);
        }
    }

    private void setBanListFull(Collection<IPAddress> fullList) {
        try {
            this.client.replaceBannedPeers(fullList.stream().map(ipaddr -> this.remapBanListAddress((IPAddress)ipaddr).toNormalizedString()).distinct().toList());
        }
        catch (DelugeException e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_DELUGE_API_ERROR, new Object[0]), (Throwable)e);
        }
    }

    private void setBanListIncrement(Collection<BanMetadata> added) {
        try {
            this.client.banPeers(added.stream().map(bm -> this.remapBanListAddress(bm.getPeer().getAddress().getAddress()).toNormalizedString()).distinct().toList());
        }
        catch (DelugeException e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_DELUGE_API_ERROR, new Object[0]), (Throwable)e);
        }
    }

    @Override
    @NotNull
    public DownloaderStatistics getStatistics() {
        try {
            PBHStatisticsResponse resp = this.client.queryStatistics();
            PBHStatisticsResponse.StatisticsResponseDTO dto = resp.getStatistics();
            return new DownloaderStatistics(dto.getTotalPayloadUpload(), dto.getTotalPayloadDownload());
        }
        catch (DelugeException e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_DELUGE_API_ERROR, new Object[0]), (Throwable)e);
            return new DownloaderStatistics(0L, 0L);
        }
    }

    @Override
    @Nullable
    public DownloaderSpeedLimiter getSpeedLimiter() {
        try {
            ConfigResponse resp = this.client.getConfig();
            ConfigResponse.ConfigRequestDTO dto = resp.getConfig();
            long downloadLimit = dto.getMaxDownloadSpeed() * 1024L;
            long uploadLimit = dto.getMaxUploadSpeed() * 1024L;
            return new DownloaderSpeedLimiter(uploadLimit, downloadLimit);
        }
        catch (DelugeException e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_DELUGE_API_ERROR, new Object[0]), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setSpeedLimiter(@NotNull DownloaderSpeedLimiter speedLimiter) {
        long uploadLimit = speedLimiter.isUploadUnlimited() ? 0L : speedLimiter.upload() / 1024L;
        long downloadLimit = speedLimiter.isDownloadUnlimited() ? 0L : speedLimiter.download() / 1024L;
        ConfigRequest config = new ConfigRequest();
        config.setMaxDownloadSpeed(downloadLimit);
        config.setMaxUploadSpeed(uploadLimit);
        try {
            this.client.setConfig(config);
        }
        catch (DelugeException e) {
            log.error(TextManager.tlUI(Lang.DOWNLOADER_DELUGE_API_ERROR, new Object[0]), (Throwable)e);
        }
    }

    @Override
    public int getBTProtocolPort() {
        return 0;
    }

    @Override
    public void setBTProtocolPort(int port) {
    }

    @Override
    public void close() {
    }

    private PeerFlag parsePeerFlag(int peerFlag, int sourceFlag) {
        boolean interesting = (peerFlag & 1) != 0;
        boolean choked = (peerFlag & 2) != 0;
        boolean remoteInterested = (peerFlag & 4) != 0;
        boolean remoteChoked = (peerFlag & 8) != 0;
        boolean supportsExtensions = (peerFlag & 0x10) != 0;
        boolean outgoingConnection = (peerFlag & 0x20) != 0;
        boolean localConnection = (peerFlag & 0x40) != 0;
        boolean handshake = (peerFlag & 0x80) != 0;
        boolean connecting = (peerFlag & 0x100) != 0;
        boolean onParole = (peerFlag & 0x200) != 0;
        boolean seed = (peerFlag & 0x400) != 0;
        boolean optimisticUnchoke = (peerFlag & 0x800) != 0;
        boolean snubbed = (peerFlag & 0x1000) != 0;
        boolean uploadOnly = (peerFlag & 0x2000) != 0;
        boolean endGameMode = (peerFlag & 0x4000) != 0;
        boolean holePunched = (peerFlag & 0x8000) != 0;
        boolean i2pSocket = (peerFlag & 0x10000) != 0;
        boolean utpSocket = (peerFlag & 0x20000) != 0;
        boolean sslSocket = (peerFlag & 0x40000) != 0;
        boolean rc4Encrypted = (peerFlag & 0x80000) != 0;
        boolean plainTextEncrypted = (peerFlag & 0x100000) != 0;
        boolean tracker = (sourceFlag & 1) != 0;
        boolean dht = (sourceFlag & 2) != 0;
        boolean pex = (sourceFlag & 4) != 0;
        boolean lsd = (sourceFlag & 8) != 0;
        boolean resumeData = (sourceFlag & 0x10) != 0;
        boolean incoming = (sourceFlag & 0x20) != 0;
        return new PeerFlag(interesting, choked, remoteInterested, remoteChoked, supportsExtensions, outgoingConnection, localConnection, handshake, connecting, onParole, seed, optimisticUnchoke, snubbed, uploadOnly, endGameMode, holePunched, i2pSocket, utpSocket, sslSocket, rc4Encrypted, plainTextEncrypted, tracker, dht, pex, lsd, resumeData, incoming);
    }

    public static class Config {
        private String name;
        private String type;
        private String endpoint;
        private String password;
        private boolean verifySsl;
        private String rpcUrl;
        private boolean incrementBan;
        private boolean ignorePrivate;
        private boolean paused;

        public static Config readFromYaml(ConfigurationSection section, String alternativeName) {
            Config config = new Config();
            config.setType("raccoonfink/deluge");
            config.setName(section.getString("name", alternativeName));
            config.setEndpoint(section.getString("endpoint", ""));
            if (config.getEndpoint().endsWith("/")) {
                config.setEndpoint(config.getEndpoint().substring(0, config.getEndpoint().length() - 1));
            }
            config.setPassword(section.getString("password", ""));
            config.setRpcUrl(section.getString("rpc-url", "/json"));
            config.setVerifySsl(section.getBoolean("verify-ssl", true));
            config.setIncrementBan(section.getBoolean("increment-ban", true));
            config.setIgnorePrivate(section.getBoolean("ignore-private", false));
            config.setPaused(section.getBoolean("paused", false));
            return config;
        }

        public YamlConfiguration saveToYaml() {
            YamlConfiguration section = new YamlConfiguration();
            section.set("type", (Object)"raccoonfink/deluge");
            section.set("name", (Object)this.name);
            section.set("endpoint", (Object)this.endpoint);
            section.set("password", (Object)this.password);
            section.set("rpc-url", (Object)this.rpcUrl);
            section.set("increment-ban", (Object)this.incrementBan);
            section.set("verify-ssl", (Object)this.verifySsl);
            section.set("ignore-private", (Object)this.ignorePrivate);
            section.set("paused", (Object)this.paused);
            return section;
        }

        @Generated
        public Config() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public boolean isVerifySsl() {
            return this.verifySsl;
        }

        @Generated
        public String getRpcUrl() {
            return this.rpcUrl;
        }

        @Generated
        public boolean isIncrementBan() {
            return this.incrementBan;
        }

        @Generated
        public boolean isIgnorePrivate() {
            return this.ignorePrivate;
        }

        @Generated
        public boolean isPaused() {
            return this.paused;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setVerifySsl(boolean verifySsl) {
            this.verifySsl = verifySsl;
        }

        @Generated
        public void setRpcUrl(String rpcUrl) {
            this.rpcUrl = rpcUrl;
        }

        @Generated
        public void setIncrementBan(boolean incrementBan) {
            this.incrementBan = incrementBan;
        }

        @Generated
        public void setIgnorePrivate(boolean ignorePrivate) {
            this.ignorePrivate = ignorePrivate;
        }

        @Generated
        public void setPaused(boolean paused) {
            this.paused = paused;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isVerifySsl() != other.isVerifySsl()) {
                return false;
            }
            if (this.isIncrementBan() != other.isIncrementBan()) {
                return false;
            }
            if (this.isIgnorePrivate() != other.isIgnorePrivate()) {
                return false;
            }
            if (this.isPaused() != other.isPaused()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$rpcUrl = this.getRpcUrl();
            String other$rpcUrl = other.getRpcUrl();
            return !(this$rpcUrl == null ? other$rpcUrl != null : !this$rpcUrl.equals(other$rpcUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isVerifySsl() ? 79 : 97);
            result = result * 59 + (this.isIncrementBan() ? 79 : 97);
            result = result * 59 + (this.isIgnorePrivate() ? 79 : 97);
            result = result * 59 + (this.isPaused() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $rpcUrl = this.getRpcUrl();
            result = result * 59 + ($rpcUrl == null ? 43 : $rpcUrl.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Deluge.Config(name=" + this.getName() + ", type=" + this.getType() + ", endpoint=" + this.getEndpoint() + ", password=" + this.getPassword() + ", verifySsl=" + this.isVerifySsl() + ", rpcUrl=" + this.getRpcUrl() + ", incrementBan=" + this.isIncrementBan() + ", ignorePrivate=" + this.isIgnorePrivate() + ", paused=" + this.isPaused() + ")";
        }
    }
}

