/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader.impl.transmission;

import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.peer.PeerFlag;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import cordelia.rpc.types.Peers;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class TRPeer
implements Peer {
    private final Peers backend;
    private final transient PeerAddress peerAddress;

    public TRPeer(Peers backend, Function<PeerAddress, PeerAddress> natConverter) {
        this.backend = backend;
        this.peerAddress = natConverter.apply(new PeerAddress(backend.getAddress(), backend.getPort(), backend.getAddress()));
    }

    @Override
    @NotNull
    public PeerAddress getPeerAddress() {
        return this.peerAddress;
    }

    @Override
    public String getPeerId() {
        return this.backend.getPeer_id() == null ? "" : new String(Base64.getDecoder().decode(this.backend.getPeer_id()), StandardCharsets.ISO_8859_1);
    }

    @Override
    public String getClientName() {
        return this.backend.getClientName();
    }

    @Override
    public long getDownloadSpeed() {
        return this.backend.getRateToClient() == null ? -1L : this.backend.getRateToClient();
    }

    @Override
    public long getDownloaded() {
        return this.backend.getBytes_to_client() == null ? -1L : this.backend.getBytes_to_client();
    }

    @Override
    public long getUploadSpeed() {
        return this.backend.getRateToPeer() == null ? -1L : this.backend.getRateToPeer();
    }

    @Override
    public long getUploaded() {
        return this.backend.getBytes_to_peer() == null ? -1L : this.backend.getBytes_to_peer();
    }

    @Override
    public double getProgress() {
        return this.backend.getProgress();
    }

    @Override
    public PeerFlag getFlags() {
        return new PeerFlag(this.backend.getFlagStr());
    }

    @Override
    public boolean isHandshaking() {
        return this.getDownloadSpeed() <= 0L && this.getUploadSpeed() <= 0L;
    }
}

