/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.PeerBanHelper;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.FeatureModule;
import com.ghostchu.peerbanhelper.module.ModuleManagerImpl;
import com.ghostchu.peerbanhelper.module.impl.webapi.body.GlobalOptionPatchBody;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.ReloadEntryDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.peerbanhelper.util.WebUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.rule.ModuleMatchCache;
import com.ghostchu.peerbanhelper.util.traversal.btstun.StunManager;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.simplereloadlib.ReloadStatus;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.gson.Gson;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.reflect.TypeToken;
import com.sun.management.HotSpotDiagnosticMXBean;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpStatus;
import io.javalin.security.RouteRole;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.management.MBeanServer;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.configuration.InvalidConfigurationException;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;

@Component
public final class PBHGeneralController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHGeneralController.class);
    private static final Gson GSON = JsonUtil.getGson().newBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private ModuleMatchCache moduleMatchCache;
    @Autowired
    private ModuleManagerImpl moduleManager;
    @Autowired
    private PeerBanHelper peerBanHelper;
    @Autowired
    private DownloaderServer downloaderServer;
    @Autowired
    private StunManager bTStunManager;
    @Autowired
    private HTTPUtil hTTPUtil;
    @Autowired
    private SystemInfo systemInfo;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - General";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-general";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/general/status", this::handleStatusGet, new RouteRole[]{Role.USER_READ})).post("/api/general/refreshNatStatus", this::handleRefreshNatStatus, new RouteRole[]{Role.USER_WRITE})).get("/api/general/checkModuleAvailable", this::handleModuleAvailable, new RouteRole[]{Role.USER_READ})).get("/api/general/stacktrace", this::handleDumpStackTrace, new RouteRole[]{Role.USER_READ})).get("/api/general/heapdump", this::handleHeapDump, new RouteRole[]{Role.USER_WRITE})).post("/api/general/reload", this::handleReloading, new RouteRole[]{Role.USER_WRITE})).get("/api/general/global", this::handleGlobalConfigRead, new RouteRole[]{Role.USER_READ})).patch("/api/general/global", this::handleGlobalConfig, new RouteRole[]{Role.USER_WRITE})).get("/api/general/{configName}", this::handleConfigGet, new RouteRole[]{Role.USER_READ})).put("/api/general/{configName}", this::handleConfigPut, new RouteRole[]{Role.USER_WRITE});
    }

    private void handleRefreshNatStatus(@NotNull Context context) {
        Thread.ofVirtual().name("Refresh NAT Status").start(() -> this.bTStunManager.refreshNatType());
        context.json((Object)new StdResp(true, "Refreshing NAT Status", null));
    }

    private void handleDumpStackTrace(Context context) {
        StringBuilder threadDump = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadMXBean.dumpAllThreads(true, true)) {
            threadDump.append(MsgUtil.threadInfoToString(threadInfo));
        }
        if ("application/json".equals(context.contentType())) {
            context.json((Object)new StdResp(true, null, threadDump.toString()));
        } else {
            context.result(threadDump.toString());
        }
    }

    private void handleGlobalConfigRead(Context context) {
        LinkedHashMap<String, Boolean> data = new LinkedHashMap<String, Boolean>();
        data.put("globalPaused", this.downloaderServer.isGlobalPaused());
        data.put("analytics", Main.getMainConfig().getBoolean("privacy.analytics"));
        context.json((Object)new StdResp(true, null, data));
    }

    private void handleGlobalConfig(Context context) {
        GlobalOptionPatchBody body = (GlobalOptionPatchBody)context.bodyAsClass(GlobalOptionPatchBody.class);
        if (body == null) {
            throw new IllegalArgumentException("Request body cannot be null");
        }
        if (body.globalPaused() != null) {
            this.downloaderServer.setGlobalPaused(body.globalPaused());
        }
        context.json((Object)new StdResp(true, "OK!", null));
    }

    private void handleModuleAvailable(Context context) {
        String moduleName = context.queryParam("module");
        if (moduleName == null) {
            throw new IllegalArgumentException("module argument cannot be null");
        }
        for (FeatureModule module : this.moduleManager.getModules()) {
            if (!module.getName().equalsIgnoreCase(moduleName) && !module.getConfigName().equalsIgnoreCase(moduleName) && !module.getClass().getName().equalsIgnoreCase(moduleName) && !module.getClass().getSimpleName().equalsIgnoreCase(moduleName) || !module.isModuleEnabled()) continue;
            context.json((Object)new StdResp(true, null, true));
            return;
        }
        context.json((Object)new StdResp(true, null, false));
    }

    private void handleHeapDump(Context context) throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        File hprof = Files.createTempFile("heapdump", ".hprof", new FileAttribute[0]).toFile();
        hprof.delete();
        File finalHprof = new File(Main.getDebugDirectory(), System.currentTimeMillis() + ".hprof.gz");
        System.gc();
        mxBean.dumpHeap(hprof.getAbsolutePath(), true);
        if (!finalHprof.exists()) {
            finalHprof.createNewFile();
        }
        try (FileInputStream filein = new FileInputStream(hprof);
             FileOutputStream fileout = new FileOutputStream(finalHprof);){
            MiscUtil.gzip(filein, fileout);
            context.header("Content-Disposition", "attachment; filename=\"" + finalHprof.getName() + "\"");
            context.header("Content-Length", String.valueOf(finalHprof.length()));
            context.header("Content-Type", "application/octet-stream");
            FileInputStream stream = new FileInputStream(finalHprof);
            context.result((InputStream)stream);
        }
    }

    private void handleStatusGet(Context context) {
        LinkedHashMap<String, Map<String, Object>> data = new LinkedHashMap<String, Map<String, Object>>();
        data.put("jvm", this.generateJvmData());
        data.put("system", this.generateSystemData(context, this.systemInfo));
        data.put("peerbanhelper", this.generatePbhData());
        context.json((Object)new StdResp(true, null, data));
    }

    private Map<String, Object> generatePbhData() {
        long compile_time = 0L;
        String release = ExternalSwitch.parse("pbh.release");
        if (release == null) {
            release = "unknown";
        }
        try {
            OffsetDateTime offsetDateTime;
            String meta = Main.getMeta().getCompileTime();
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
                offsetDateTime = OffsetDateTime.parse(meta, formatter);
            }
            catch (Exception e) {
                offsetDateTime = OffsetDateTime.parse(meta, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            compile_time = offsetDateTime.toInstant().toEpochMilli();
        }
        catch (Exception meta) {
            // empty catch block
        }
        LinkedHashMap<String, Object> pbh = new LinkedHashMap<String, Object>();
        pbh.put("version", Main.getMeta().getVersion());
        pbh.put("commit_id", Main.getMeta().getCommit());
        pbh.put("compile_time", compile_time / 1000L);
        pbh.put("release", release);
        pbh.put("uptime", (System.currentTimeMillis() - Main.getStartupAt()) / 1000L);
        pbh.put("data_dir", Main.getDataDirectory().getAbsolutePath());
        return pbh;
    }

    private Map<String, Object> generateSystemData(Context context, SystemInfo systemInfo) {
        LinkedHashMap<String, Object> os = new LinkedHashMap<String, Object>();
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        OperatingSystem operatingSystem = systemInfo.getOperatingSystem();
        if (osMXBean.getName().contains("Windows")) {
            os.put("os", "Windows");
            os.put("version", String.valueOf(operatingSystem));
        } else {
            os.put("os", osMXBean.getName());
            os.put("version", osMXBean.getVersion());
        }
        os.put("architecture", osMXBean.getArch());
        os.put("cores", osMXBean.getAvailableProcessors());
        Map<String, Object> mem = this.generateSystemMemoryData(systemInfo.getHardware());
        os.put("memory", mem);
        os.put("load", osMXBean.getSystemLoadAverage());
        Map<String, Object> network = this.generateNetworkStats(context);
        os.put("network", network);
        return os;
    }

    private Map<String, Object> generateNetworkStats(Context context) {
        String userIp = IPAddressUtil.getIPAddress(this.userIp(context)).toCompressedString();
        LinkedHashMap<String, Object> network = new LinkedHashMap<String, Object>();
        int proxy = Main.getMainConfig().getInt("proxy.setting");
        network.put("internet_access", this.hTTPUtil.getNetworkReachability());
        network.put("use_proxy", this.hTTPUtil.getProxyType() != Proxy.Type.DIRECT);
        network.put("reverse_proxy", WebUtil.isUsingReserveProxy(context));
        network.put("client_ip", userIp);
        network.put("nat_type", this.bTStunManager.getCachedNatType().name());
        return network;
    }

    private Map<String, Object> generateJvmData() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        LinkedHashMap<String, Object> jvm = new LinkedHashMap<String, Object>();
        jvm.put("version", runtimeMXBean.getVmVersion());
        jvm.put("vendor", runtimeMXBean.getVmVendor());
        jvm.put("runtime", runtimeMXBean.getVmName());
        jvm.put("bitness", Short.parseShort(System.getProperty("sun.arch.data.model")));
        LinkedHashMap<String, Map<String, Object>> mem = new LinkedHashMap<String, Map<String, Object>>();
        mem.put("heap", this.generateMemoryData(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage()));
        mem.put("non_heap", this.generateMemoryData(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage()));
        jvm.put("memory", mem);
        jvm.put("startup_arguments", ManagementFactory.getRuntimeMXBean().getInputArguments());
        return jvm;
    }

    private Map<String, Object> generateSystemMemoryData(HardwareAbstractionLayer hardware) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        GlobalMemory mem = hardware.getMemory();
        data.put("total", mem.getTotal());
        data.put("free", mem.getAvailable());
        data.put("page_size", mem.getPageSize());
        return data;
    }

    private Map<String, Object> generateMemoryData(MemoryUsage heapMemoryMXBean) {
        LinkedHashMap<String, Object> mem = new LinkedHashMap<String, Object>();
        mem.put("init", heapMemoryMXBean.getInit());
        mem.put("max", heapMemoryMXBean.getMax());
        mem.put("used", heapMemoryMXBean.getUsed());
        mem.put("free", heapMemoryMXBean.getMax() - heapMemoryMXBean.getUsed());
        mem.put("committed", heapMemoryMXBean.getCommitted());
        return mem;
    }

    private void handleReloading(Context context) {
        Main.setupConfiguration();
        Map result = Main.getReloadManager().reload();
        ArrayList entryList = new ArrayList();
        result.forEach((container, r) -> {
            Reloadable reloadable;
            Object entryName = container.getReloadable() == null ? container.getReloadableMethod().getDeclaringClass().getName() + "#" + container.getReloadableMethod().getName() : ((reloadable = (Reloadable)container.getReloadable().get()) == null ? "<invalid>" : reloadable.getClass().getName());
            entryList.add(new ReloadEntryDTO((String)entryName, r.getStatus().name()));
        });
        this.moduleMatchCache.invalidateAll();
        boolean success = true;
        TranslationComponent message = new TranslationComponent(Lang.RELOAD_RESULT_SUCCESS);
        if (result.values().stream().anyMatch(r -> r.getStatus() == ReloadStatus.SCHEDULED)) {
            message = new TranslationComponent(Lang.RELOAD_RESULT_SCHEDULED);
        }
        if (result.values().stream().anyMatch(r -> r.getStatus() == ReloadStatus.REQUIRE_RESTART)) {
            message = new TranslationComponent(Lang.RELOAD_RESULT_REQUIRE_RESTART);
        }
        if (result.values().stream().anyMatch(r -> r.getStatus() == ReloadStatus.EXCEPTION)) {
            success = false;
            message = new TranslationComponent(Lang.RELOAD_RESULT_FAILED);
        }
        context.json((Object)new StdResp(success, TextManager.tl(this.locale(context), message), entryList));
    }

    private void handleConfigGet(Context context) throws IOException, InvalidConfigurationException {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.getOptions().setParseComments(true).setWidth(1000);
        switch (context.pathParam("configName")) {
            case "config": {
                yamlConfiguration.load(Main.getMainConfigFile());
                if (ExternalSwitch.parseBoolean("pbh.demoMode")) {
                    yamlConfiguration.set("client", null);
                    yamlConfiguration.set("btn.app-id", (Object)"REDACTED_IN_DEMO_MODE");
                    yamlConfiguration.set("btn.app-secret", (Object)"REDACTED_IN_DEMO_MODE");
                    yamlConfiguration.set("pbh-plus-key", (Object)"REDACTED_IN_DEMO_MODE");
                    yamlConfiguration.set("server.token", (Object)"REDACTED_IN_DEMO_MODE");
                    yamlConfiguration.set("installation-id", (Object)"Not Available In Demo Mode");
                    yamlConfiguration.set("proxy", null);
                }
                PBHGeneralController.sectionToList((ConfigurationSection)yamlConfiguration, "push-notification", "push-notification-name");
                break;
            }
            case "profile": {
                yamlConfiguration.load(Main.getProfileConfigFile());
                PBHGeneralController.stringListToMapList((ConfigurationSection)yamlConfiguration, "module.peer-id-blacklist", "banned-peer-id");
                PBHGeneralController.stringListToMapList((ConfigurationSection)yamlConfiguration, "module.client-name-blacklist", "banned-client-name");
                PBHGeneralController.stringListToMapList((ConfigurationSection)yamlConfiguration, "module.ptr-blacklist", "ptr-rules");
                break;
            }
            default: {
                context.status(HttpStatus.NOT_FOUND);
                return;
            }
        }
        context.json((Object)new StdResp(true, null, PBHGeneralController.replaceKeys((ConfigurationSection)yamlConfiguration, "-", "_")));
    }

    private void handleConfigPut(Context context) throws IOException, InvalidConfigurationException {
        File configFile;
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.getOptions().setParseComments(true).setWidth(1000);
        switch (context.pathParam("configName")) {
            case "config": {
                configFile = Main.getMainConfigFile();
                break;
            }
            case "profile": {
                configFile = Main.getProfileConfigFile();
                break;
            }
            default: {
                context.status(HttpStatus.NOT_FOUND);
                return;
            }
        }
        yamlConfiguration.load(configFile);
        Map newData = (Map)GSON.fromJson(context.body(), Map.class);
        PBHGeneralController.mergeYaml((ConfigurationSection)yamlConfiguration, newData, "_", "-");
        yamlConfiguration.save(configFile);
        context.status(HttpStatus.CREATED);
        this.handleReloading(context);
    }

    private static void stringListToMapList(ConfigurationSection cfg, String path, String field) {
        ConfigurationSection section = cfg.getConfigurationSection(path);
        if (section != null) {
            List<Map> list = section.getStringList(field).stream().map(item -> (Map)GSON.fromJson(item, new TypeToken<Map<String, String>>(){}.getType())).toList();
            section.set(field, list);
            cfg.set(path, (Object)section);
        }
    }

    private static void sectionToList(ConfigurationSection cfg, String path, String key) {
        ConfigurationSection section = cfg.getConfigurationSection(path);
        if (section != null) {
            List<Object> list = section.getKeys(false).stream().map(k -> {
                ConfigurationSection s2 = section.getConfigurationSection(k);
                if (s2 != null) {
                    s2.set(key, k);
                    return s2;
                }
                return section.get(k);
            }).toList();
            cfg.set(path, list);
        }
    }

    private static Map<String, Object> replaceKeys(ConfigurationSection cfg, String target, String replacement) {
        return cfg.getValues(false).entrySet().stream().collect(LinkedHashMap::new, (map, entry) -> {
            String updatedKey = ((String)entry.getKey()).replace(target, replacement);
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection) {
                ConfigurationSection c = (ConfigurationSection)value;
                map.put(updatedKey, PBHGeneralController.replaceKeys(c, target, replacement));
            } else if (value instanceof List) {
                List list = (List)value;
                List<Object> updatedList = list.stream().map(item -> {
                    Map<String, Object> map;
                    if (item instanceof ConfigurationSection) {
                        ConfigurationSection c = (ConfigurationSection)item;
                        map = PBHGeneralController.replaceKeys(c, target, replacement);
                    } else {
                        map = item;
                    }
                    return map;
                }).toList();
                map.put(updatedKey, updatedList);
            } else {
                map.put(updatedKey, value);
            }
        }, HashMap::putAll);
    }

    private static Map<String, Object> replaceKeys(Map<String, Object> originalMap, String target, String replacement) {
        return originalMap.entrySet().stream().collect(LinkedHashMap::new, (map, entry) -> {
            String updatedKey = ((String)entry.getKey()).replace(target, replacement);
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map m = (Map)value;
                map.put(updatedKey, PBHGeneralController.replaceKeys(m, target, replacement));
            } else if (value instanceof List) {
                List list = (List)value;
                List<Object> updatedList = list.stream().map(item -> item instanceof Map ? PBHGeneralController.replaceKeys(item, target, replacement) : item).toList();
                map.put(updatedKey, updatedList);
            } else {
                map.put(updatedKey, value);
            }
        }, HashMap::putAll);
    }

    private static void mergeYaml(ConfigurationSection cfg, Map<String, Object> newMap, String target, String replacement) {
        String path = cfg.getCurrentPath();
        newMap.forEach((key, val) -> {
            String originalKey;
            switch (originalKey = cfg.contains(key) ? key : key.replace(target, replacement)) {
                case "push-notification": {
                    if (!"".equals(path)) break;
                    val = ((List)val).stream().filter(Map.class::isInstance).map(Map.class::cast).collect(LinkedHashMap::new, (map, entry) -> {
                        String name = (String)entry.remove("push_notification_name");
                        map.put(name, entry);
                    }, HashMap::putAll);
                    break;
                }
                case "banned-peer-id": {
                    if (!"module.peer-id-blacklist".equals(path)) break;
                    val = ((List)val).stream().filter(Map.class::isInstance).map(arg_0 -> ((Gson)GSON).toJson(arg_0)).toList();
                    break;
                }
                case "banned-client-name": {
                    if (!"module.client-name-blacklist".equals(path)) break;
                    val = ((List)val).stream().filter(Map.class::isInstance).map(arg_0 -> ((Gson)GSON).toJson(arg_0)).toList();
                    break;
                }
                case "ptr-rules": {
                    if (!"module.ptr-blacklist".equals(path)) break;
                    val = ((List)val).stream().filter(Map.class::isInstance).map(arg_0 -> ((Gson)GSON).toJson(arg_0)).toList();
                }
            }
            if (val instanceof Map) {
                Map map2 = (Map)val;
                ConfigurationSection section = Optional.ofNullable(cfg.getConfigurationSection(originalKey)).orElseGet(() -> cfg.createSection(originalKey));
                PBHGeneralController.mergeYaml(section, map2, target, replacement);
                cfg.set(originalKey, (Object)section);
            } else if (val instanceof List) {
                List list = (List)val;
                List<Object> updatedList = list.stream().map(item -> item instanceof Map ? PBHGeneralController.replaceKeys(item, target, replacement) : item).toList();
                cfg.set(originalKey, updatedList);
            } else {
                cfg.set(originalKey, val);
            }
        });
    }

    @Override
    public void onDisable() {
    }
}

