/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.pbhplus;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.pbhplus.bean.License;
import com.ghostchu.peerbanhelper.pbhplus.bean.V1License;
import com.ghostchu.peerbanhelper.pbhplus.bean.V2License;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.TimeUtil;
import com.ghostchu.peerbanhelper.util.encrypt.RSAUtils;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;

@Component
public class LicenseParser {
    public static final String OFFICIAL_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCHxgRTk+Zx/pkN8rpK+Lbr1/f1meapIRDJIgBiSfFy4xdbmDF8wE9PJhdM+3peThz9dJQlt6dkeduIVp65rGS9oZdj7gO5YKtUCDir4NgGQGe1p2C41Xv6RiOXObLmF+ubAJILsimwtDyJT8IysEh9hgaZWnvRXT8JX9wB0Ti2rwIDAQAB";
    private final Map.Entry<PrivateKey, PublicKey> localKeyPair;
    private final String hardwareUUIDHash;

    public LicenseParser(SystemInfo systemInfo) throws Exception {
        String hardwareUUID = systemInfo.getHardware().getComputerSystem().getHardwareUUID();
        this.hardwareUUIDHash = Hashing.sha256().hashString((CharSequence)hardwareUUID, StandardCharsets.UTF_8).toString().substring(0, 10);
        this.localKeyPair = this.loadLocalKeyPair();
    }

    @NotNull
    public License fromLicense(String encryptedLicense) throws IllegalArgumentException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, InvalidKeySpecException, BadPaddingException, IOException, InvalidKeyException {
        JsonElement parser;
        byte[] encrypted = Base64.getDecoder().decode(encryptedLicense);
        String json = null;
        try {
            json = new String(RSAUtils.decryptByPublicKey(encrypted, Base64.getEncoder().encodeToString(this.localKeyPair.getValue().getEncoded())), StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (json == null) {
            json = new String(RSAUtils.decryptByPublicKey(encrypted, OFFICIAL_PUBLIC_KEY), StandardCharsets.UTF_8);
        }
        if (!(parser = JsonParser.parseString(json)).isJsonObject()) {
            throw new IllegalArgumentException("License data is not a valid JSON object");
        }
        JsonObject licenseObject = parser.getAsJsonObject();
        JsonElement verifyMagicObj = licenseObject.get("verifyMagic");
        if (verifyMagicObj == null || !verifyMagicObj.isJsonPrimitive()) {
            throw new IllegalArgumentException("License data is missing 'verifyMagic' field or it is not a string");
        }
        if (!"PeerBanHelper".equals(verifyMagicObj.getAsString())) {
            throw new IllegalArgumentException("Incorrect verify magic: excepted->PeerBanHelper, actual->" + String.valueOf(verifyMagicObj));
        }
        JsonElement version = licenseObject.get("licenseVersion");
        License license = null;
        if (version == null) {
            license = this.fromLicenseV1(json);
        } else if (version.getAsInt() == 2) {
            license = this.fromLicenseV2(json);
        }
        if (license == null) {
            throw new IllegalArgumentException("Unsupported license version: " + version.getAsInt() + ", Try update PeerBanHelper.");
        }
        license.setKeyText(encryptedLicense);
        return license;
    }

    @NotNull
    private License fromLicenseV2(@NotNull String json) {
        return (License)JsonUtil.standard().fromJson(json, V2License.class);
    }

    @NotNull
    private License fromLicenseV1(@NotNull String json) {
        return (License)JsonUtil.standard().fromJson(json, V1License.class);
    }

    public String generateLocalLicense() throws Exception {
        V2License key = new V2License("", "PeerBanHelper", 2, "local", TextManager.tlUI(Lang.FREE_LICENSE_SOURCE, new Object[0]), System.getProperty("user.name", "Local User"), null, null, null, null, null, BigDecimal.ZERO, System.currentTimeMillis(), System.currentTimeMillis(), LocalDateTime.now().plusDays(15L).atOffset(TimeUtil.getSystemZoneOffset()).toInstant().toEpochMilli(), TextManager.tlUI(Lang.FREE_LICENSE_DESCRIPTION, new Object[0]), "Local License", List.of("basic"));
        byte[] encrypted = RSAUtils.encryptByPrivateKey(JsonUtil.standard().toJson((Object)key).getBytes(StandardCharsets.UTF_8), Base64.getEncoder().encodeToString(this.getLocalKeyPair().getKey().getEncoded()));
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public Map.Entry<PrivateKey, PublicKey> getLocalKeyPair() {
        return this.localKeyPair;
    }

    private Map.Entry<PrivateKey, PublicKey> loadLocalKeyPair() throws Exception {
        File publicKeyFile = new File(Main.getDataDirectory(), "local_license2_keypair_" + this.hardwareUUIDHash + ".pub");
        File privateKeyFile = new File(Main.getDataDirectory(), "local_license2_keypair_" + this.hardwareUUIDHash + ".key");
        if (!publicKeyFile.exists() || !privateKeyFile.exists()) {
            Map<String, Object> map = RSAUtils.genKeyPair();
            RSAPrivateKey privateKeyObj = (RSAPrivateKey)map.get("RSAPrivateKey");
            RSAPublicKey publicKeyObj = (RSAPublicKey)map.get("RSAPublicKey");
            Files.write(privateKeyFile.toPath(), privateKeyObj.getEncoded(), new OpenOption[0]);
            Files.write(publicKeyFile.toPath(), publicKeyObj.getEncoded(), new OpenOption[0]);
        }
        byte[] privateKeyBytes = Files.readAllBytes(privateKeyFile.toPath());
        byte[] publicKeyBytes = Files.readAllBytes(publicKeyFile.toPath());
        PrivateKey privateKey = RSAUtils.getRSAPrivateKeyFromRawEncoded(privateKeyBytes);
        PublicKey publicKey = RSAUtils.getRSAPublicKeyFromRawEncoded(publicKeyBytes);
        return Map.entry(privateKey, publicKey);
    }
}

