/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.traversal.btstun.StunManager;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.Proxy;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;

@Component
public class CommonDataCollector {
    @Autowired
    private HTTPUtil httpUtil;
    @Autowired
    private StunManager bTStunManager;
    @Autowired
    private SystemInfo systemInfo;

    public Map<String, Object> generatePbhData() {
        long compile_time = 0L;
        String release = ExternalSwitch.parse("pbh.release");
        if (release == null) {
            release = "unknown";
        }
        try {
            OffsetDateTime offsetDateTime;
            String meta = Main.getMeta().getCompileTime();
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
                offsetDateTime = OffsetDateTime.parse(meta, formatter);
            }
            catch (Exception e) {
                offsetDateTime = OffsetDateTime.parse(meta, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            compile_time = offsetDateTime.toInstant().toEpochMilli();
        }
        catch (Exception meta) {
            // empty catch block
        }
        LinkedHashMap<String, Object> pbh = new LinkedHashMap<String, Object>();
        pbh.put("version", Main.getMeta().getVersion());
        pbh.put("commit_id", Main.getMeta().getCommit());
        pbh.put("compile_time", compile_time / 1000L);
        pbh.put("release", release);
        pbh.put("gui_available", Main.getGuiManager().isGuiAvailable());
        pbh.put("default_locale", Main.DEF_LOCALE);
        return pbh;
    }

    public Map<String, Object> generateSystemData() {
        LinkedHashMap<String, Object> os = new LinkedHashMap<String, Object>();
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        OperatingSystem operatingSystem = this.systemInfo.getOperatingSystem();
        if (osMXBean.getName().contains("Windows")) {
            os.put("os", "Windows");
            os.put("version", String.valueOf(operatingSystem));
        } else {
            os.put("os", osMXBean.getName());
            os.put("version", osMXBean.getVersion());
        }
        os.put("architecture", osMXBean.getArch());
        os.put("cores", osMXBean.getAvailableProcessors());
        Map<String, Object> mem = this.generateSystemMemoryData(this.systemInfo.getHardware());
        os.put("memory", mem);
        Map<String, Object> network = this.generateNetworkStats();
        os.put("network", network);
        return os;
    }

    public Map<String, Object> generateNetworkStats() {
        LinkedHashMap<String, Object> network = new LinkedHashMap<String, Object>();
        network.put("internet_access", this.httpUtil.getNetworkReachability());
        network.put("use_proxy", this.httpUtil.getProxyType() != Proxy.Type.DIRECT);
        network.put("nat_type", this.bTStunManager.getCachedNatType().name());
        return network;
    }

    public Map<String, Object> generateJvmData() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        LinkedHashMap<String, Object> jvm = new LinkedHashMap<String, Object>();
        jvm.put("version", runtimeMXBean.getVmVersion());
        jvm.put("vendor", runtimeMXBean.getVmVendor());
        jvm.put("runtime", runtimeMXBean.getVmName());
        jvm.put("bitness", this.systemInfo.getOperatingSystem().getBitness());
        LinkedHashMap<String, Map<String, Object>> mem = new LinkedHashMap<String, Map<String, Object>>();
        mem.put("heap", this.generateMemoryData(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage()));
        mem.put("non_heap", this.generateMemoryData(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage()));
        jvm.put("memory", mem);
        return jvm;
    }

    private Map<String, Object> generateSystemMemoryData(HardwareAbstractionLayer hardware) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        GlobalMemory mem = hardware.getMemory();
        data.put("total", mem.getTotal());
        data.put("free", mem.getAvailable());
        return data;
    }

    private Map<String, Object> generateMemoryData(MemoryUsage heapMemoryMXBean) {
        LinkedHashMap<String, Object> mem = new LinkedHashMap<String, Object>();
        mem.put("init", heapMemoryMXBean.getInit());
        mem.put("max", heapMemoryMXBean.getMax());
        mem.put("used", heapMemoryMXBean.getUsed());
        mem.put("free", heapMemoryMXBean.getMax() - heapMemoryMXBean.getUsed());
        mem.put("committed", heapMemoryMXBean.getCommitted());
        return mem;
    }
}

