/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.backgroundtask;

import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTask;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTaskManager;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTaskStatus;
import jakarta.annotation.PreDestroy;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\fH\u0002J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0012\u001a\u00020\tJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016J\u001e\u0010\u0017\u001a\u00020\f2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rJ\u001e\u0010\u0019\u001a\u00020\f2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rJ\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\fH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTaskManager;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "taskList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTask;", "statusListeners", "Lkotlin/Function1;", "", "Lcom/ghostchu/peerbanhelper/util/backgroundtask/TaskStatusListener;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "cleanTask", "addTask", "task", "addTaskAsync", "Ljava/util/concurrent/CompletableFuture;", "getTaskList", "", "addStatusListener", "listener", "removeStatusListener", "notifyListeners", "shutdown", "peerbanhelper"})
public final class BackgroundTaskManager {
    private final Logger logger = LoggerFactory.getLogger(BackgroundTaskManager.class);
    @NotNull
    private final CopyOnWriteArrayList<BackgroundTask> taskList = new CopyOnWriteArrayList();
    @NotNull
    private final CopyOnWriteArrayList<Function1<BackgroundTask, Unit>> statusListeners = new CopyOnWriteArrayList();
    @NotNull
    private final CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Dispatchers.getIO(), (int)8, null, (int)2, null)));

    public BackgroundTaskManager() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ BackgroundTaskManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            BackgroundTaskManager.access$cleanTask(this.this$0);
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 != var3_3) continue;
                            return var3_3;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void cleanTask() {
        OffsetDateTime now = OffsetDateTime.now();
        this.taskList.removeIf(arg_0 -> BackgroundTaskManager.cleanTask$lambda$1(arg_0 -> BackgroundTaskManager.cleanTask$lambda$0(now, arg_0), arg_0));
    }

    @NotNull
    public final BackgroundTask addTask(@NotNull BackgroundTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.addTaskAsync(task);
        return task;
    }

    @NotNull
    public final CompletableFuture<BackgroundTask> addTaskAsync(@NotNull BackgroundTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        CompletableFuture<BackgroundTask> future = new CompletableFuture<BackgroundTask>();
        task.setStatus(BackgroundTaskStatus.QUEUED);
        this.taskList.add(task);
        this.notifyListeners(task);
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(task, this, future, null){
            int label;
            final /* synthetic */ BackgroundTask $task;
            final /* synthetic */ BackgroundTaskManager this$0;
            final /* synthetic */ CompletableFuture<BackgroundTask> $future;
            {
                this.$task = $task;
                this.this$0 = $receiver;
                this.$future = $future;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            this.$task.setStatus(BackgroundTaskStatus.RUNNING);
                            BackgroundTaskManager.access$notifyListeners(this.this$0, this.$task);
                            Consumer<BackgroundTask> callback = arg_0 -> addTaskAsync.1.invokeSuspend$lambda$0(this.this$0, arg_0);
                            this.$task.start(callback);
                            this.$task.complete();
                            BackgroundTaskManager.access$notifyListeners(this.this$0, this.$task);
                            this.$future.complete(this.$task);
                        }
                        catch (CancellationException e) {
                            this.$task.setFinishedAt(OffsetDateTime.now());
                            this.$task.setStatus(BackgroundTaskStatus.CANCELLED);
                            BackgroundTaskManager.access$notifyListeners(this.this$0, this.$task);
                            this.$future.completeExceptionally(e);
                            throw e;
                        }
                        catch (Exception e) {
                            BackgroundTaskManager.access$getLogger$p(this.this$0).error("Background task '" + this.$task.getTitle() + "' failed", (Throwable)e);
                            this.$task.fail();
                            BackgroundTaskManager.access$notifyListeners(this.this$0, this.$task);
                            this.$future.completeExceptionally(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(BackgroundTaskManager this$0, BackgroundTask updatedTask) {
                Intrinsics.checkNotNull((Object)updatedTask);
                BackgroundTaskManager.access$notifyListeners(this$0, updatedTask);
            }
        }), (int)3, null);
        return future;
    }

    @NotNull
    public final List<BackgroundTask> getTaskList() {
        ArrayList orderableList = new ArrayList(this.taskList);
        CollectionsKt.sortWith((List)orderableList, (arg_0, arg_1) -> BackgroundTaskManager.getTaskList$lambda$1(BackgroundTaskManager::getTaskList$lambda$0, arg_0, arg_1));
        return orderableList;
    }

    public final void addStatusListener(@NotNull Function1<? super BackgroundTask, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.statusListeners.add(listener);
    }

    public final void removeStatusListener(@NotNull Function1<? super BackgroundTask, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.statusListeners.remove(listener);
    }

    private final void notifyListeners(BackgroundTask task) {
        Iterator<Function1<BackgroundTask, Unit>> iterator = this.statusListeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Function1<BackgroundTask, Unit>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Function1<BackgroundTask, Unit> listener = iterator2.next();
            try {
                listener.invoke((Object)task);
            }
            catch (Exception e) {
                this.logger.error("Error notifying task status listener", (Throwable)e);
            }
        }
    }

    @PreDestroy
    public final void shutdown() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, (String)"BackgroundTaskManager is shutting down", null, (int)2, null);
    }

    private static final boolean cleanTask$lambda$0(OffsetDateTime $now, BackgroundTask task) {
        boolean bl;
        if (!task.getStatus().isActive()) {
            OffsetDateTime finishedAt = task.getFinishedAt();
            bl = task.getStatus() == BackgroundTaskStatus.COMPLETED && finishedAt != null && $now.isAfter(finishedAt.plusMinutes(1L)) ? true : (finishedAt != null && $now.isAfter(finishedAt.plusMinutes(30L)) ? true : task.isDisposalImmediatelyAfterComplete());
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean cleanTask$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int getTaskList$lambda$0(BackgroundTask a, BackgroundTask b) {
        int n;
        if (a.getStatus().isActive() && !b.getStatus().isActive()) {
            n = -1;
        } else if (!a.getStatus().isActive() && b.getStatus().isActive()) {
            n = 1;
        } else {
            boolean aIsCompleteOrFailed = a.getStatus() == BackgroundTaskStatus.COMPLETED || a.getStatus() == BackgroundTaskStatus.FAILED;
            boolean bIsCompleteOrFailed = b.getStatus() == BackgroundTaskStatus.COMPLETED || b.getStatus() == BackgroundTaskStatus.FAILED;
            n = aIsCompleteOrFailed && !bIsCompleteOrFailed ? -1 : (!aIsCompleteOrFailed && bIsCompleteOrFailed ? 1 : b.getStartAt().compareTo(a.getStartAt()));
        }
        return n;
    }

    private static final int getTaskList$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ void access$notifyListeners(BackgroundTaskManager $this, BackgroundTask task) {
        $this.notifyListeners(task);
    }

    public static final /* synthetic */ Logger access$getLogger$p(BackgroundTaskManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$cleanTask(BackgroundTaskManager $this) {
        $this.cleanTask();
    }
}

