/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.ipdb;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.LazyLoad;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTaskManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPDB;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.util.lab.Experiments;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.sentry.Sentry;
import java.io.File;
import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IPDBManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IPDBManager.class);
    private final Cache<String, IPDBResponse> geoIpCache = CacheBuilder.newBuilder().expireAfterAccess((long)ExternalSwitch.parseInt("pbh.geoIpCache.timeout", 300000), TimeUnit.MILLISECONDS).maximumSize((long)ExternalSwitch.parseInt("pbh.geoIpCache.size", 300)).softValues().build();
    private final HTTPUtil hTTPUtil;
    private final BackgroundTaskManager backgroundTaskManager;
    @Nullable
    private IPDB ipdb = null;

    public IPDBManager(HTTPUtil hTTPUtil, Laboratory laboratory, BackgroundTaskManager backgroundTaskManager) {
        this.hTTPUtil = hTTPUtil;
        this.backgroundTaskManager = backgroundTaskManager;
        if (laboratory.isExperimentActivated(Experiments.ASYNC_IPDB_SETUP.getExperiment())) {
            CompletableFuture.runAsync(this::setupIPDB);
        } else {
            this.setupIPDB();
        }
    }

    private void setupIPDB() {
        try {
            String accountId = Main.getMainConfig().getString("ip-database.account-id", "");
            String licenseKey = Main.getMainConfig().getString("ip-database.license-key", "");
            String databaseCity = Main.getMainConfig().getString("ip-database.database-city", "GeoLite2-City");
            String databaseASN = Main.getMainConfig().getString("ip-database.database-asn", "GeoLite2-ASN");
            boolean autoUpdate = Main.getMainConfig().getBoolean("ip-database.auto-update");
            this.ipdb = new IPDB(new File(Main.getDataDirectory(), "ipdb"), accountId, licenseKey, databaseCity, databaseASN, autoUpdate, Main.getUserAgent(), this.hTTPUtil, this.backgroundTaskManager);
            Runtime.getRuntime().addShutdownHook(Thread.ofPlatform().name("IPDB Shutdown Worker").unstarted(() -> {
                try {
                    if (this.ipdb != null) {
                        this.ipdb.close();
                    }
                }
                catch (Exception e) {
                    Sentry.captureException((Throwable)e);
                }
            }));
        }
        catch (Exception e) {
            log.info(TextManager.tlUI(Lang.IPDB_INVALID, new Object[0]), (Throwable)e);
            Sentry.captureException((Throwable)e);
        }
    }

    public IPDBResponse queryIPDB(InetAddress address) {
        try {
            return (IPDBResponse)this.geoIpCache.get((Object)address.getHostAddress(), () -> {
                if (this.ipdb == null) {
                    return new IPDBResponse(new LazyLoad<IPGeoData>(() -> null));
                }
                return new IPDBResponse(new LazyLoad<IPGeoData>(() -> {
                    try {
                        return this.ipdb.query(address);
                    }
                    catch (Exception e) {
                        Sentry.captureException((Throwable)e);
                        return null;
                    }
                }));
            });
        }
        catch (ExecutionException e) {
            Sentry.captureException((Throwable)e);
            return new IPDBResponse(null);
        }
    }

    @Nullable
    @Generated
    public IPDB getIpdb() {
        return this.ipdb;
    }

    public record IPDBResponse(LazyLoad<IPGeoData> geoData) {
    }
}

