/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.push.impl;

import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.push.AbstractPushProvider;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;

public final class PushDeerPushProvider
extends AbstractPushProvider {
    private final Config config;
    private final String name;
    private final HTTPUtil httpUtil;

    public PushDeerPushProvider(String name, Config config, HTTPUtil httpUtil) {
        this.name = name;
        this.config = config;
        this.httpUtil = httpUtil;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getConfigType() {
        return "pushdeer";
    }

    @Override
    public JsonObject saveJson() {
        return JsonUtil.readObject(JsonUtil.standard().toJson((Object)this.config));
    }

    @Override
    public ConfigurationSection saveYaml() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("type", (Object)"pushdeer");
        section.set("endpoint", (Object)this.config.getEndpoint());
        section.set("pushkey", (Object)this.config.getPushKey());
        return section;
    }

    public static PushDeerPushProvider loadFromJson(String name, JsonObject json, HTTPUtil httpUtil) {
        return new PushDeerPushProvider(name, (Config)JsonUtil.getGson().fromJson((JsonElement)json, Config.class), httpUtil);
    }

    public static PushDeerPushProvider loadFromYaml(String name, ConfigurationSection section, HTTPUtil httpUtil) {
        String endpoint = section.getString("endpoint", "https://api2.pushdeer.com/message/push");
        String pushKey = section.getString("pushkey", "");
        Config config = new Config(endpoint, pushKey);
        return new PushDeerPushProvider(name, config, httpUtil);
    }

    @Override
    public boolean push(String title, String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pushkey", this.config.getPushKey());
        map.put("text", title);
        map.put("desp", content);
        map.put("type", "markdown");
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson(map), (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(this.config.getEndpoint()).post(requestBody).header("Content-Type", "application/json").build();
        try (Response response = this.httpUtil.newBuilder().build().newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalStateException("HTTP Failed while sending push messages to PushDeer: " + response.body().string());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to send push message to PushDeer", e);
        }
        return true;
    }

    public static class Config {
        @SerializedName(value="endpoint")
        private String endpoint;
        @SerializedName(value="pushkey")
        private String pushKey;

        @Generated
        public Config(String endpoint, String pushKey) {
            this.endpoint = endpoint;
            this.pushKey = pushKey;
        }

        @Generated
        public String getEndpoint() {
            return this.endpoint;
        }

        @Generated
        public String getPushKey() {
            return this.pushKey;
        }

        @Generated
        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public void setPushKey(String pushKey) {
            this.pushKey = pushKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                return false;
            }
            String this$pushKey = this.getPushKey();
            String other$pushKey = other.getPushKey();
            return !(this$pushKey == null ? other$pushKey != null : !this$pushKey.equals(other$pushKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            String $pushKey = this.getPushKey();
            result = result * 59 + ($pushKey == null ? 43 : $pushKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PushDeerPushProvider.Config(endpoint=" + this.getEndpoint() + ", pushKey=" + this.getPushKey() + ")";
        }
    }
}

