/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.push.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.push.AbstractPushProvider;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;

public final class TelegramPushProvider
extends AbstractPushProvider {
    private final Config config;
    private final String name;
    private final HTTPUtil httpUtil;

    public TelegramPushProvider(String name, Config config, HTTPUtil httpUtil) {
        this.name = name;
        this.config = config;
        this.httpUtil = httpUtil;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getConfigType() {
        return "telegram";
    }

    public static TelegramPushProvider loadFromJson(String name, JsonObject json, HTTPUtil httpUtil) {
        return new TelegramPushProvider(name, (Config)JsonUtil.getGson().fromJson((JsonElement)json, Config.class), httpUtil);
    }

    public static TelegramPushProvider loadFromYaml(String name, ConfigurationSection section, HTTPUtil httpUtil) {
        String token = section.getString("token", "");
        String chatid = section.getString("chatid", "");
        Config config = new Config(token, chatid);
        return new TelegramPushProvider(name, config, httpUtil);
    }

    @Override
    public JsonObject saveJson() {
        return JsonUtil.readObject(JsonUtil.standard().toJson((Object)this.config));
    }

    @Override
    public ConfigurationSection saveYaml() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("type", (Object)"telegram");
        section.set("token", (Object)this.config.getToken());
        section.set("chatid", (Object)this.config.getChatId());
        return section;
    }

    @Override
    public boolean push(String title, String content) {
        String markdown = "*" + title + "*\n" + content;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("chat_id", this.config.getChatId());
        map.put("caption", markdown);
        map.put("text", markdown);
        map.put("photo", "https://raw.githubusercontent.com/PBH-BTN/PeerBanHelper/refs/heads/master/src/main/resources/assets/icon.png");
        map.put("parse_mode", "Markdown");
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson(map), (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url("https://api.telegram.org/bot" + this.config.getToken() + "/sendPhoto").post(requestBody).header("Content-Type", "application/json").build();
        try (Response response = this.httpUtil.newBuilder().build().newCall(request).execute();){
            if (!response.isSuccessful()) {
                String responseBody = response.body().string();
                TelegramErrResponse tgr = (TelegramErrResponse)JsonUtil.getGson().fromJson(responseBody, TelegramErrResponse.class);
                throw new IllegalStateException("HTTP Failed while sending push messages to Telegram: " + tgr.getDescription());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to send push message to Telegram", e);
        }
        return true;
    }

    public static class Config {
        private String token;
        private String chatId;

        @Generated
        public Config(String token, String chatId) {
            this.token = token;
            this.chatId = chatId;
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public String getChatId() {
            return this.chatId;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public void setChatId(String chatId) {
            this.chatId = chatId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$chatId = this.getChatId();
            String other$chatId = other.getChatId();
            return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $chatId = this.getChatId();
            result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TelegramPushProvider.Config(token=" + this.getToken() + ", chatId=" + this.getChatId() + ")";
        }
    }

    public static class TelegramErrResponse {
        @JsonProperty(value="ok")
        private Boolean ok;
        @JsonProperty(value="error_code")
        private Integer error_code;
        @JsonProperty(value="description")
        private String description;

        @Generated
        public TelegramErrResponse() {
        }

        @Generated
        public Boolean getOk() {
            return this.ok;
        }

        @Generated
        public Integer getError_code() {
            return this.error_code;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setOk(Boolean ok) {
            this.ok = ok;
        }

        @Generated
        public void setError_code(Integer error_code) {
            this.error_code = error_code;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TelegramErrResponse)) {
                return false;
            }
            TelegramErrResponse other = (TelegramErrResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$ok = this.getOk();
            Boolean other$ok = other.getOk();
            if (this$ok == null ? other$ok != null : !((Object)this$ok).equals(other$ok)) {
                return false;
            }
            Integer this$error_code = this.getError_code();
            Integer other$error_code = other.getError_code();
            if (this$error_code == null ? other$error_code != null : !((Object)this$error_code).equals(other$error_code)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TelegramErrResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $ok = this.getOk();
            result = result * 59 + ($ok == null ? 43 : ((Object)$ok).hashCode());
            Integer $error_code = this.getError_code();
            result = result * 59 + ($error_code == null ? 43 : ((Object)$error_code).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TelegramPushProvider.TelegramErrResponse(ok=" + this.getOk() + ", error_code=" + this.getError_code() + ", description=" + this.getDescription() + ")";
        }
    }
}

