/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.rule.matcher;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.rule.AbstractJsonMatcher;
import com.ghostchu.peerbanhelper.util.rule.MatchResult;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.google.gson.JsonObject;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class StringEqualsMatcher
extends AbstractJsonMatcher {
    private final String rule;
    private MatchResult hit;
    private MatchResult miss;

    public StringEqualsMatcher(JsonObject syntax) {
        super(syntax);
        this.rule = syntax.get("content").getAsString();
        this.hit = new MatchResult(MatchResultEnum.TRUE, new TranslationComponent(Lang.MATCH_STRING_EQUALS, this.rule));
        this.miss = new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent(Lang.MATCH_STRING_EQUALS, this.rule));
        if (syntax.has("hit")) {
            this.hit = new MatchResult(MatchResultEnum.valueOf(syntax.get("hit").getAsString()), new TranslationComponent(Lang.MATCH_STRING_EQUALS, "Hit-" + this.rule));
        }
        if (syntax.has("miss")) {
            this.miss = new MatchResult(MatchResultEnum.valueOf(syntax.get("miss").getAsString()), new TranslationComponent(Lang.MATCH_STRING_EQUALS, "Miss-" + this.rule));
        }
    }

    @Override
    @NotNull
    public MatchResult match0(@NotNull String content) {
        if (content.equalsIgnoreCase(this.rule)) {
            return this.hit;
        }
        return this.miss;
    }

    @Override
    public TranslationComponent matcherName() {
        return new TranslationComponent(Lang.MATCH_STRING_EQUALS, this.rule);
    }

    @Override
    public String matcherIdentifier() {
        return "peerbanhelper:stringequalsmatcher";
    }

    @Override
    public String metadata() {
        return this.rule;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringEqualsMatcher)) {
            return false;
        }
        StringEqualsMatcher other = (StringEqualsMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$rule = this.rule;
        String other$rule = other.rule;
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        MatchResult this$hit = this.hit;
        MatchResult other$hit = other.hit;
        if (this$hit == null ? other$hit != null : !((Object)this$hit).equals(other$hit)) {
            return false;
        }
        MatchResult this$miss = this.miss;
        MatchResult other$miss = other.miss;
        return !(this$miss == null ? other$miss != null : !((Object)this$miss).equals(other$miss));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringEqualsMatcher;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $rule = this.rule;
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        MatchResult $hit = this.hit;
        result = result * 59 + ($hit == null ? 43 : ((Object)$hit).hashCode());
        MatchResult $miss = this.miss;
        result = result * 59 + ($miss == null ? 43 : ((Object)$miss).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "StringEqualsMatcher(super=" + super.toString() + ", rule=" + this.rule + ", hit=" + String.valueOf(this.hit) + ", miss=" + String.valueOf(this.miss) + ")";
    }
}

