/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.umami;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.util.CommonDataCollector;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UmamiHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UmamiHelper.class);
    private final String umamiUrl = "https://uma.pbh-btn.com/api/send";
    private final String websiteId = "f9ed8c46-5d57-4ae5-ab45-227658dffb41";
    private final CommonDataCollector dataCollector;
    private final OkHttpClient client;

    public UmamiHelper(@Autowired HTTPUtil httpUtil, @Autowired CommonDataCollector dataCollector) {
        this.dataCollector = dataCollector;
        this.client = httpUtil.newBuilder().build();
    }

    public void sendBootEvent() {
        this.sendEvent("/lifecycle/boot", "application-boot");
    }

    public void sendHeartbeatEvent() {
        this.sendEvent("/lifecycle/heartbeat", "application-heartbeat");
    }

    private void sendEvent(String url, String eventName) {
        if (!Main.getMainConfig().getBoolean("privacy.analytics")) {
            return;
        }
        Thread.ofVirtual().name("Umami Event Sender").start(() -> {
            UmamiEvent event = new UmamiEvent();
            event.setType("event");
            UmamiEvent.PayloadDTO payload = new UmamiEvent.PayloadDTO();
            payload.setId(Main.getMainConfig().getString("installation-id"));
            payload.setUrl(url);
            payload.setHostname("backend.peerbanhelper");
            payload.setName(eventName);
            payload.setWebsite("f9ed8c46-5d57-4ae5-ab45-227658dffb41");
            payload.setData(this.createData());
            event.setPayload(payload);
            String json = JsonUtil.standard().toJson((Object)event);
            Request postReq = new Request.Builder().url("https://uma.pbh-btn.com/api/send").post(RequestBody.create((byte[])json.getBytes(StandardCharsets.UTF_8))).header("Content-Type", "application/json").build();
            try (Response response = this.client.newCall(postReq).execute();){
                if (!response.isSuccessful()) {
                    log.debug("Unable to send Umami event: HTTP {}: {}", (Object)response.code(), (Object)response.body().string());
                    return;
                }
                log.debug("Successfully sent Umami event.");
            }
            catch (IOException e) {
                log.debug("Unable to send Umami event due exception: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    public Map<String, Object> createData() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("jvm", this.dataCollector.generateJvmData());
        data.put("pbh", this.dataCollector.generatePbhData());
        data.put("system", this.dataCollector.generateSystemData());
        data.put("networking", this.dataCollector.generateNetworkStats());
        return data;
    }

    public static class UmamiEvent {
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="payload")
        private PayloadDTO payload;

        @Generated
        public UmamiEvent() {
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public PayloadDTO getPayload() {
            return this.payload;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setPayload(PayloadDTO payload) {
            this.payload = payload;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UmamiEvent)) {
                return false;
            }
            UmamiEvent other = (UmamiEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            PayloadDTO this$payload = this.getPayload();
            PayloadDTO other$payload = other.getPayload();
            return !(this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UmamiEvent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            PayloadDTO $payload = this.getPayload();
            result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UmamiHelper.UmamiEvent(type=" + this.getType() + ", payload=" + String.valueOf(this.getPayload()) + ")";
        }

        public static class PayloadDTO {
            @SerializedName(value="id")
            private String id;
            @SerializedName(value="website")
            private String website;
            @SerializedName(value="url")
            private String url;
            @SerializedName(value="hostname")
            private String hostname;
            @SerializedName(value="name")
            private String name;
            @SerializedName(value="data")
            private Map<String, Object> data;

            @Generated
            public PayloadDTO() {
            }

            @Generated
            public String getId() {
                return this.id;
            }

            @Generated
            public String getWebsite() {
                return this.website;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public String getHostname() {
                return this.hostname;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public Map<String, Object> getData() {
                return this.data;
            }

            @Generated
            public void setId(String id) {
                this.id = id;
            }

            @Generated
            public void setWebsite(String website) {
                this.website = website;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public void setHostname(String hostname) {
                this.hostname = hostname;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setData(Map<String, Object> data) {
                this.data = data;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PayloadDTO)) {
                    return false;
                }
                PayloadDTO other = (PayloadDTO)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$website = this.getWebsite();
                String other$website = other.getWebsite();
                if (this$website == null ? other$website != null : !this$website.equals(other$website)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                    return false;
                }
                String this$hostname = this.getHostname();
                String other$hostname = other.getHostname();
                if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                Map<String, Object> this$data = this.getData();
                Map<String, Object> other$data = other.getData();
                return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PayloadDTO;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $website = this.getWebsite();
                result = result * 59 + ($website == null ? 43 : $website.hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                String $hostname = this.getHostname();
                result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                Map<String, Object> $data = this.getData();
                result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "UmamiHelper.UmamiEvent.PayloadDTO(id=" + this.getId() + ", website=" + this.getWebsite() + ", url=" + this.getUrl() + ", hostname=" + this.getHostname() + ", name=" + this.getName() + ", data=" + String.valueOf(this.getData()) + ")";
            }
        }
    }
}

