/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.web;

import com.formdev.flatlaf.util.StringUtils;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.pbhplus.LicenseManager;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.SharedObject;
import com.ghostchu.peerbanhelper.util.WebUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.web.EarlyStartupHandler;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.exception.BlockScannerException;
import com.ghostchu.peerbanhelper.web.exception.DemoModeException;
import com.ghostchu.peerbanhelper.web.exception.IPAddressBannedException;
import com.ghostchu.peerbanhelper.web.exception.NeedInitException;
import com.ghostchu.peerbanhelper.web.exception.NotLoggedInException;
import com.ghostchu.peerbanhelper.web.exception.RequirePBHPlusLicenseException;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import inet.ipaddr.IPAddress;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.HttpStatus;
import io.javalin.http.staticfiles.Location;
import io.javalin.json.JsonMapper;
import io.javalin.plugin.bundled.CorsPluginConfig;
import io.sentry.Sentry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class JavalinWebContainer
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavalinWebContainer.class);
    private Javalin javalin;
    private LicenseManager licenseManager;
    private String token;
    private final Cache<@NotNull IPAddress, @NotNull AtomicInteger> FAIL2BAN = CacheBuilder.newBuilder().expireAfterWrite((long)ExternalSwitch.parseInt("pbh.web.fail2ban.timeout", 900000), TimeUnit.MILLISECONDS).build();
    private final Cache<@NotNull IPAddress, @NotNull Long> LOGIN_SESSION_TIMETABLE = CacheBuilder.newBuilder().maximumSize(50L).build();
    private static final String[] blockUserAgent = new String[]{"censys", "shodan", "zoomeye", "threatbook", "fofa", "zmap", "nmap", "archive"};
    private volatile boolean started;
    private boolean webuiAnalyticsEnabled;
    private final AtomicReference<Handler> spaHandler = new AtomicReference<EarlyStartupHandler>(new EarlyStartupHandler());
    private final JsonMapper gsonMapper = new JsonMapper(this){
        {
            Objects.requireNonNull(this$0);
        }

        @NotNull
        public String toJsonString(@NotNull Object obj, @NotNull Type type) {
            return JsonUtil.standard().toJson(obj, type);
        }

        @NotNull
        public <T> T fromJsonString(@NotNull String json, @NotNull Type targetType) {
            return (T)JsonUtil.standard().fromJson(json, targetType);
        }
    };

    public JavalinWebContainer() {
        this.reloadConfig();
        Main.getReloadManager().register((Reloadable)this);
    }

    public void setupJavalin() {
        this.javalin = (Javalin)((Javalin)((Javalin)Javalin.create(c -> {
            c.http.gzipOnlyCompression();
            c.showJavalinBanner = false;
            c.jsonMapper(this.gsonMapper);
            c.useVirtualThreads = true;
            c.startupWatcherEnabled = false;
            if (Main.getMainConfig().getBoolean("server.allow-cors") || ExternalSwitch.parse("pbh.allowCors") != null) {
                c.bundledPlugins.enableCors(cors -> cors.addRule(CorsPluginConfig.CorsRule::anyHost));
            }
            if (Main.getMainConfig().getBoolean("server.external-webui", false)) {
                c.staticFiles.add(staticFiles -> {
                    staticFiles.hostedPath = "/";
                    staticFiles.directory = new File(Main.getDataDirectory(), "static").getPath();
                    staticFiles.location = Location.EXTERNAL;
                    staticFiles.precompress = false;
                    staticFiles.skipFileFunction = req -> req.getRequestURI().endsWith("index.html");
                });
                c.spaRoot.addFile("/", new File(new File(Main.getDataDirectory(), "static"), "index.html").getPath(), Location.EXTERNAL);
            } else {
                c.spaRoot.addHandler("/", ctx -> this.spaHandler.get().handle(ctx));
                c.staticFiles.add(staticFiles -> {
                    staticFiles.hostedPath = "/";
                    staticFiles.directory = "/static";
                    staticFiles.location = Location.CLASSPATH;
                    staticFiles.precompress = false;
                    staticFiles.skipFileFunction = req -> req.getRequestURI().endsWith("index.html");
                });
            }
        }).exception(IPAddressBannedException.class, (e, ctx) -> {
            ctx.status(HttpStatus.TOO_MANY_REQUESTS);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.reqLocale(ctx), Lang.WEBAPI_AUTH_BANNED_TOO_FREQ, new Object[0]), null));
        }).exception(NotLoggedInException.class, (e, ctx) -> {
            ctx.status(HttpStatus.FORBIDDEN);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.reqLocale(ctx), Lang.WEBAPI_NOT_LOGGED, new Object[0]), null));
        }).exception(NeedInitException.class, (e, ctx) -> {
            ctx.status(HttpStatus.SEE_OTHER);
            ctx.header("Location", "/init");
            ctx.json((Object)new StdResp(false, TextManager.tl(this.reqLocale(ctx), Lang.WEBAPI_NEED_INIT, new Object[0]), Map.of("location", "/init")));
        }).exception(IllegalArgumentException.class, (e, ctx) -> {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, e.getMessage(), e.getMessage()));
        }).exception(RequirePBHPlusLicenseException.class, (e, ctx) -> {
            ctx.status(HttpStatus.PAYMENT_REQUIRED);
            ctx.json((Object)new StdResp(false, e.getMessage(), e.getMessage()));
        }).exception(BlockScannerException.class, (e, ctx) -> {
            ctx.status(HttpStatus.NOT_FOUND);
            ctx.header("Server", "nginx");
            ctx.result("404 not found");
            ctx.attribute("skipAfter", (Object)true);
        }).exception(DemoModeException.class, (e, ctx) -> {
            ctx.status(HttpStatus.BAD_REQUEST);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.reqLocale(ctx), Lang.DEMO_MODE_OPERATION_NOT_PERMITTED, new Object[0]), null));
        }).exception(Exception.class, (e, ctx) -> {
            ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
            ctx.json((Object)new StdResp(false, TextManager.tl(this.reqLocale(ctx), Lang.WEBAPI_INTERNAL_ERROR, new Object[0]), null));
            log.error("500 Internal Server Error", (Throwable)e);
        }).beforeMatched(ctx -> {
            if (!this.securityCheck(ctx)) {
                throw new BlockScannerException();
            }
            if (ctx.routeRoles().isEmpty()) {
                return;
            }
            if (ctx.routeRoles().contains((Object)Role.ANYONE)) {
                return;
            }
            if (ctx.routeRoles().contains((Object)Role.PBH_PLUS) && this.licenseManager != null && !this.licenseManager.isFeatureEnabled("basic")) {
                throw new RequirePBHPlusLicenseException("PBH Plus License not activated");
            }
            if (ctx.routeRoles().contains((Object)Role.USER_WRITE) && ExternalSwitch.parseBoolean("pbh.demoMode")) {
                throw new DemoModeException();
            }
            if (ctx.path().startsWith("/init")) {
                return;
            }
            if (this.token == null || this.token.isBlank()) {
                throw new NeedInitException();
            }
            String authenticated = (String)ctx.sessionAttribute("authenticated");
            if (authenticated != null && authenticated.equals(this.token)) {
                return;
            }
            if (!this.allowAttemptLogin(WebUtil.userIp(ctx), ctx.userAgent())) {
                throw new IPAddressBannedException();
            }
            TokenAuthResult tokenAuthResult = this.isContextAuthorized(ctx);
            if (tokenAuthResult == TokenAuthResult.SUCCESS) {
                String silentLoginSecret = ctx.queryParam("silentLogin");
                this.markLoginSuccess(WebUtil.userIp(ctx), ctx.userAgent(), SharedObject.SILENT_LOGIN_TOKEN_FOR_GUI.equals(silentLoginSecret));
                return;
            }
            if (tokenAuthResult == TokenAuthResult.FAILED) {
                this.markLoginFailed(WebUtil.userIp(ctx), ctx.userAgent());
            }
            if (ExternalSwitch.parseBoolean("pbh.web.requireLogin", true)) {
                throw new NotLoggedInException();
            }
        })).options("/*", ctx -> ctx.status(200))).after(ctx -> {
            if (ctx.attribute("skipAfter") != null) {
                return;
            }
            ctx.header("Server", Main.getUserAgent());
        });
    }

    public void setSpaHandlerToReady() {
        this.spaHandler.set(this::handleSpaRequest);
    }

    private void handleSpaRequest(@NotNull Context ctx) throws IOException {
        try (InputStream in = this.getClass().getResourceAsStream("/static/index.html");){
            if (in == null) {
                ctx.status(HttpStatus.NOT_FOUND);
                ctx.result("SPA index.html not found in classpath.");
                return;
            }
            String data = new String(in.readAllBytes());
            if (this.webuiAnalyticsEnabled) {
                data = data.replace("<title>PeerBanHelper</title>", "<title>PeerBanHelper</title>\n<script>\n        window.beforeSendHandler = function(type, payload) {\n            payload.hostname = \"privacy-redacted.local\";\n            payload.referrer = \"http://privacy-redacted.local\";\n            try {\n                if (payload.url.startsWith('http')) {\n                    const urlObj = new URL(payload.url);\n                    payload.url = \"http://privacy-redacted.local\" + urlObj.pathname + urlObj.search;\n                } else {\n                    payload.url = \"http://privacy-redacted.local\" + (payload.url.startsWith('/') ? payload.url : '/' + payload.url);\n                }\n            } catch (e) {\n                payload.url = payload.url.replace(/^https?:\\/\\/[^/]+/, 'http://0.0.0.0');\n            }\n            return payload;\n        };\n</script>\n<script defer src=\"https://uma.pbh-btn.com/script.js\"\ndata-website-id=\"58076dc4-266e-4984-abb6-7c48afa22d4d\"\ndata-exclude-search=\"true\"\ndata-exclude-ip=\"true\"\ndata-exclude-token=\"true\"\ndata-before-send=\"beforeSendHandler\"\n></script>\n");
            }
            ctx.html(data);
        }
    }

    private void reloadConfig() {
        this.webuiAnalyticsEnabled = Main.getMainConfig().getBoolean("privacy.analytics", true);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private boolean securityCheck(Context ctx) {
        String userAgent = ctx.userAgent();
        if (userAgent == null) {
            return false;
        }
        if (userAgent.isBlank()) {
            return false;
        }
        String ua = userAgent.toLowerCase();
        for (String s : blockUserAgent) {
            if (!ua.contains(s)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TokenAuthResult isContextAuthorized(Context ctx) {
        String tk = "";
        String authToken = ctx.header("Authorization");
        if (authToken != null) {
            if (authToken.startsWith("Bearer ")) {
                tk = authToken.substring(7);
            }
        } else {
            tk = ctx.queryParam("token");
        }
        if (StringUtils.isEmpty((String)tk)) {
            return TokenAuthResult.NO_AUTH_TOKEN_PROVIDED;
        }
        return this.token.equals(tk) ? TokenAuthResult.SUCCESS : TokenAuthResult.FAILED;
    }

    public void start(String host, int port, String token) {
        this.token = token;
        this.javalin.start(host, port);
        this.started = true;
    }

    public Javalin javalin() {
        return this.javalin;
    }

    public String reqLocale(Context context) {
        for (AcceptLanguages requestLocale : this.requestLocales(context)) {
            String pbhCode = requestLocale.code.toLowerCase(Locale.ROOT).replace("-", "_");
            if (!TextManager.INSTANCE_HOLDER.getAvailableLanguages().contains(pbhCode)) continue;
            return pbhCode;
        }
        return Main.DEF_LOCALE;
    }

    private List<AcceptLanguages> requestLocales(Context context) {
        String[] browserRequested;
        String headerLocale = context.header("Accept-Language");
        if (headerLocale == null) {
            return List.of(new AcceptLanguages(Main.DEF_LOCALE, 1.0f));
        }
        ArrayList<AcceptLanguages> preferLocales = new ArrayList<AcceptLanguages>();
        for (String s : browserRequested = headerLocale.split(",")) {
            String[] localeSettings = s.split(";");
            String localeCode = localeSettings[0];
            float prefer = 1.0f;
            try {
                if (localeSettings.length > 1) {
                    prefer = Float.parseFloat(localeSettings[1].substring(2));
                }
            }
            catch (Exception e) {
                Sentry.captureException((Throwable)e);
            }
            preferLocales.add(new AcceptLanguages(localeCode, prefer));
        }
        preferLocales.sort(Comparator.reverseOrder());
        return preferLocales;
    }

    public boolean allowAttemptLogin(String ip, String userAgent) {
        boolean allowed;
        AtomicInteger counter = (AtomicInteger)this.FAIL2BAN.get((Object)this.getPrefixedIPAddr(ip), () -> new AtomicInteger(0));
        boolean bl = allowed = counter.get() <= 10;
        if (!allowed) {
            log.warn(TextManager.tlUI(Lang.WEBUI_SECURITY_LOGIN_FAILED_FAIL2BAN, ip, userAgent));
        }
        return allowed;
    }

    public synchronized void markLoginFailed(String ip, String userAgent) {
        AtomicInteger counter = (AtomicInteger)this.FAIL2BAN.get((Object)this.getPrefixedIPAddr(ip), () -> new AtomicInteger(0));
        counter.incrementAndGet();
        log.warn(TextManager.tlUI(Lang.WEBUI_SECURITY_LOGIN_FAILED, ip, userAgent));
    }

    private IPAddress getPrefixedIPAddr(String ip) {
        IPAddress ipAddr = IPAddressUtil.getIPAddress(ip);
        if (ipAddr.isIPv4Convertible()) {
            ipAddr = ipAddr.toIPv4();
        }
        ipAddr = ipAddr.isIPv4() ? IPAddressUtil.toPrefixBlockAndZeroHost(ipAddr, 24) : IPAddressUtil.toPrefixBlockAndZeroHost(ipAddr, 50);
        return ipAddr;
    }

    public synchronized void markLoginSuccess(String ip, String userAgent, boolean silent) {
        IPAddress ipBlock = this.getPrefixedIPAddr(ip);
        AtomicInteger counter = (AtomicInteger)this.FAIL2BAN.get((Object)ipBlock, () -> new AtomicInteger(0));
        counter.set(0);
        if (this.LOGIN_SESSION_TIMETABLE.getIfPresent((Object)ipBlock) == null) {
            this.LOGIN_SESSION_TIMETABLE.put((Object)ipBlock, (Object)System.currentTimeMillis());
            log.info(TextManager.tlUI(Lang.WEBUI_SECURITY_LOGIN_SUCCESS, ip, userAgent));
            if (!silent) {
                Main.getGuiManager().createNotification(Level.INFO, TextManager.tlUI(Lang.WEBUI_SECURITY_LOGIN_SUCCESS_NOTIFICATION_TITLE, new Object[0]), TextManager.tlUI(Lang.WEBUI_SECURITY_LOGIN_SUCCESS_NOTIFICATION_DESCRIPTION, ip, userAgent));
            }
        }
    }

    private Cache<@NotNull IPAddress, @NotNull AtomicInteger> fail2Ban() {
        return this.FAIL2BAN;
    }

    @Generated
    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }

    public static enum TokenAuthResult {
        NO_AUTH_TOKEN_PROVIDED,
        SUCCESS,
        FAILED;

    }

    public record AcceptLanguages(String code, float prefer) implements Comparable<AcceptLanguages>
    {
        @Override
        public int compareTo(@NotNull AcceptLanguages o) {
            return Float.compare(this.prefer, o.prefer);
        }
    }
}

