/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import com.google.gson.JsonObject;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.responses.DelugeResponse;

public final class ConnectedResponse
extends DelugeResponse {
    private final boolean m_connected;

    public ConnectedResponse(Integer httpResponseCode, JsonObject response) throws DelugeException {
        super(httpResponseCode, response);
        if (!response.has("result")) {
            throw new DelugeException("Missing 'result' field in JSON response");
        }
        this.m_connected = response.get("result").getAsBoolean();
    }

    public ConnectedResponse(Integer httpResponseCode, JsonObject response, boolean isConnected) throws DelugeException {
        super(httpResponseCode, response);
        this.m_connected = isConnected;
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    @Override
    public JsonObject toResponseJSON() {
        JsonObject ret = super.toResponseJSON();
        ret.addProperty("result", Boolean.valueOf(this.isConnected()));
        return ret;
    }
}

