/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.ErrorDetails;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationFilter;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.api.output.ValidateOutput;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.extensibility.AppliedMigration;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.info.AppliedMigrationAttributes;
import org.flywaydb.core.internal.info.MigrationInfoContext;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.Pair;

public class MigrationInfoServiceImpl
implements MigrationInfoService,
OperationResult {
    private final CompositeMigrationResolver migrationResolver;
    private final SchemaHistory schemaHistory;
    private final Database database;
    private final Configuration configuration;
    private final MigrationVersion target;
    private final boolean outOfOrder;
    private final ValidatePattern[] ignorePatterns;
    private final MigrationPattern[] cherryPick;
    private List<MigrationInfoImpl> migrationInfos;
    private Boolean allSchemasEmpty;

    public MigrationInfoServiceImpl(CompositeMigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Configuration configuration, MigrationVersion target, boolean outOfOrder, ValidatePattern[] ignorePatterns, MigrationPattern[] cherryPick) {
        this.migrationResolver = migrationResolver;
        this.configuration = configuration;
        this.database = database;
        this.schemaHistory = schemaHistory;
        this.target = target;
        this.outOfOrder = outOfOrder;
        this.ignorePatterns = ignorePatterns;
        this.cherryPick = cherryPick;
    }

    public void refresh() {
        Collection<ResolvedMigration> resolvedMigrations = this.migrationResolver.resolveMigrations(this.configuration);
        List<AppliedMigration> appliedMigrations = this.schemaHistory.allAppliedMigrations();
        MigrationInfoContext context = new MigrationInfoContext();
        context.target = this.target;
        context.outOfOrder = this.outOfOrder;
        context.ignorePatterns = this.ignorePatterns;
        context.cherryPick = this.cherryPick;
        Map<Pair<MigrationVersion, MigrationType>, ResolvedMigration> resolvedVersioned = this.getResolvedVersionedMigrations(resolvedMigrations, context);
        TreeMap<String, ResolvedMigration> resolvedRepeatable = new TreeMap<String, ResolvedMigration>(this.getResolvedRepeatableMigrations(resolvedMigrations));
        ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedVersioned = new ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>>(this.getAppliedVersionedMigrations(appliedMigrations, context));
        ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedRepeatable = new ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>>(this.getAppliedRepeatableMigrations(appliedMigrations));
        this.updateContextFromAppliedVersionedMigrations(appliedVersioned, context);
        if (MigrationVersion.CURRENT == this.target) {
            context.target = context.lastApplied;
        }
        ArrayList<MigrationInfoImpl> migrationInfos1 = new ArrayList<MigrationInfoImpl>();
        for (Pair pair : appliedVersioned) {
            ResolvedMigration resolvedMigration = resolvedVersioned.get(Pair.of(((AppliedMigration)pair.getLeft()).getVersion(), ((AppliedMigration)pair.getLeft()).getType()));
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, (AppliedMigration)pair.getLeft(), context, ((AppliedMigrationAttributes)pair.getRight()).outOfOrder, ((AppliedMigrationAttributes)pair.getRight()).deleted, ((AppliedMigrationAttributes)pair.getRight()).undone));
        }
        for (ResolvedMigration resolvedMigration : this.getPendingResolvedVersionedMigrations(appliedVersioned, resolvedVersioned, context)) {
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, null, context, false, false, false));
        }
        if (this.configuration.isFailOnMissingTarget() && this.target != null && this.target != MigrationVersion.CURRENT && this.target != MigrationVersion.LATEST && this.target != MigrationVersion.NEXT) {
            this.validateTarget(this.target, migrationInfos1);
        }
        context.latestRepeatableRuns = this.getLatestRepeatableRuns(appliedRepeatable);
        for (Pair pair : appliedRepeatable) {
            AppliedMigration appliedRepeatableMigration = (AppliedMigration)pair.getLeft();
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedRepeatable.get(appliedRepeatableMigration.getDescription());
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, appliedRepeatableMigration, context, false, ((AppliedMigrationAttributes)pair.getRight()).deleted, false));
        }
        for (ResolvedMigration resolvedMigration : this.getPendingResolvedRepeatableMigrations(appliedRepeatable, resolvedRepeatable, context)) {
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, null, context, false, false, false));
        }
        Collections.sort(migrationInfos1);
        this.migrationInfos = migrationInfos1;
        if (context.target == MigrationVersion.NEXT) {
            MigrationInfoImpl[] pendingMigrationInfos = this.pending();
            context.target = pendingMigrationInfos.length == 0 ? null : pendingMigrationInfos[0].getVersion();
        }
    }

    private Map<Pair<MigrationVersion, MigrationType>, ResolvedMigration> getResolvedVersionedMigrations(Collection<ResolvedMigration> resolvedMigrations, MigrationInfoContext context) {
        TreeMap<Pair<MigrationVersion, MigrationType>, ResolvedMigration> resolvedVersionedMigrations = new TreeMap<Pair<MigrationVersion, MigrationType>, ResolvedMigration>((p1, p2) -> ((MigrationVersion)p1.getLeft()).compareTo((MigrationVersion)p2.getLeft()) == 0 ? ((MigrationType)p1.getRight()).toString().compareTo(((MigrationType)p2.getRight()).toString()) : ((MigrationVersion)p1.getLeft()).compareTo((MigrationVersion)p2.getLeft()));
        for (ResolvedMigration resolvedMigration : resolvedMigrations) {
            MigrationVersion version = resolvedMigration.getVersion();
            if (version == null) continue;
            if (version.compareTo(context.lastResolved) > 0) {
                context.lastResolved = version;
            }
            resolvedVersionedMigrations.put(Pair.of(version, resolvedMigration.getType()), resolvedMigration);
        }
        return resolvedVersionedMigrations;
    }

    private Map<String, ResolvedMigration> getResolvedRepeatableMigrations(Collection<ResolvedMigration> resolvedMigrations) {
        TreeMap<String, ResolvedMigration> resolvedRepeatableMigrations = new TreeMap<String, ResolvedMigration>();
        for (ResolvedMigration resolvedMigration : resolvedMigrations) {
            if (resolvedMigration.getVersion() != null) continue;
            resolvedRepeatableMigrations.put(resolvedMigration.getDescription(), resolvedMigration);
        }
        return resolvedRepeatableMigrations;
    }

    private List<Pair<AppliedMigration, AppliedMigrationAttributes>> getAppliedVersionedMigrations(List<AppliedMigration> appliedMigrations, MigrationInfoContext context) {
        ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedVersionedMigrations = new ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>>();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            appliedMigration.updateAttributes(appliedVersionedMigrations);
            MigrationVersion version = appliedMigration.getVersion();
            if (version == null) continue;
            if (appliedMigration.getType() == CoreMigrationType.SCHEMA) {
                context.schema = version;
            }
            if (appliedMigration.getType().isBaseline() && (context.appliedBaseline == null || version.isNewerThan(context.appliedBaseline.getVersion()))) {
                context.appliedBaseline = version;
            }
            if (appliedMigration.getType().equals(CoreMigrationType.DELETE) && appliedMigration.isSuccess()) {
                this.markAsDeleted(version, appliedVersionedMigrations);
                continue;
            }
            appliedVersionedMigrations.add(Pair.of(appliedMigration, new AppliedMigrationAttributes()));
        }
        return appliedVersionedMigrations;
    }

    private List<Pair<AppliedMigration, AppliedMigrationAttributes>> getAppliedRepeatableMigrations(List<AppliedMigration> appliedMigrations) {
        ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedRepeatableMigrations = new ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>>();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            if (appliedMigration.getVersion() != null) continue;
            appliedRepeatableMigrations.add(Pair.of(appliedMigration, new AppliedMigrationAttributes()));
            if (!appliedMigration.getType().equals(CoreMigrationType.DELETE) || !appliedMigration.isSuccess()) continue;
            this.markRepeatableAsDeleted(appliedMigration.getDescription(), appliedRepeatableMigrations);
        }
        return appliedRepeatableMigrations;
    }

    private void validateTarget(MigrationVersion target, List<MigrationInfoImpl> migrationInfos) {
        boolean targetFound = false;
        for (MigrationInfoImpl migration : migrationInfos) {
            if (target.compareTo(migration.getVersion()) != 0) continue;
            targetFound = true;
            break;
        }
        if (!targetFound) {
            throw new FlywayException("No migration with a target version " + String.valueOf(target) + " could be found. Ensure target is specified correctly and the migration exists.");
        }
    }

    private Set<ResolvedMigration> getPendingResolvedVersionedMigrations(List<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedVersionedMigrations, Map<Pair<MigrationVersion, MigrationType>, ResolvedMigration> resolvedVersionedMigrations, MigrationInfoContext context) {
        HashSet<ResolvedMigration> pendingResolvedVersionedMigrations = new HashSet<ResolvedMigration>(resolvedVersionedMigrations.values());
        for (Pair<AppliedMigration, AppliedMigrationAttributes> av : appliedVersionedMigrations) {
            ResolvedMigration resolvedMigration = resolvedVersionedMigrations.get(Pair.of(av.getLeft().getVersion(), av.getLeft().getType()));
            if (resolvedMigration == null || av.getRight().deleted || av.getLeft().getType() == CoreMigrationType.DELETE || av.getRight().undone) continue;
            pendingResolvedVersionedMigrations.remove(resolvedMigration);
        }
        for (ResolvedMigration resolvedMigration : pendingResolvedVersionedMigrations) {
            if (!resolvedMigration.getType().isBaseline() || context.pendingBaseline != null && !resolvedMigration.getVersion().isNewerThan(context.pendingBaseline.getVersion())) continue;
            context.pendingBaseline = resolvedMigration.getVersion();
        }
        return pendingResolvedVersionedMigrations;
    }

    private Set<ResolvedMigration> getPendingResolvedRepeatableMigrations(List<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedRepeatableMigrations, Map<String, ResolvedMigration> resolvedRepeatableMigrations, MigrationInfoContext context) {
        HashSet<ResolvedMigration> pendingResolvedVRepeatableMigrations = new HashSet<ResolvedMigration>(resolvedRepeatableMigrations.values());
        for (Pair<AppliedMigration, AppliedMigrationAttributes> av : appliedRepeatableMigrations) {
            AppliedMigration appliedRepeatableMigration = av.getLeft();
            String desc = appliedRepeatableMigration.getDescription();
            int rank = appliedRepeatableMigration.getInstalledRank();
            ResolvedMigration resolvedMigration = resolvedRepeatableMigrations.get(desc);
            int latestRank = context.latestRepeatableRuns.get(desc);
            if (av.getRight().deleted || av.getLeft().getType() == CoreMigrationType.DELETE || resolvedMigration == null || rank != latestRank || !resolvedMigration.checksumMatches(appliedRepeatableMigration.getChecksum())) continue;
            pendingResolvedVRepeatableMigrations.remove(resolvedMigration);
        }
        return pendingResolvedVRepeatableMigrations;
    }

    private Map<String, Integer> getLatestRepeatableRuns(List<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedRepeatableMigrations) {
        HashMap<String, Integer> latestRepeatableRuns = new HashMap<String, Integer>();
        for (Pair<AppliedMigration, AppliedMigrationAttributes> av : appliedRepeatableMigrations) {
            if (av.getRight().deleted && av.getLeft().getType() == CoreMigrationType.DELETE) continue;
            AppliedMigration appliedRepeatableMigration = av.getLeft();
            String desc = appliedRepeatableMigration.getDescription();
            int rank = appliedRepeatableMigration.getInstalledRank();
            if (latestRepeatableRuns.containsKey(desc) && rank <= (Integer)latestRepeatableRuns.get(desc)) continue;
            latestRepeatableRuns.put(desc, rank);
        }
        return latestRepeatableRuns;
    }

    private void updateContextFromAppliedVersionedMigrations(List<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedVersionedMigrations, MigrationInfoContext context) {
        for (Pair<AppliedMigration, AppliedMigrationAttributes> av : appliedVersionedMigrations) {
            AppliedMigration appliedMigration = av.getLeft();
            MigrationVersion version = appliedMigration.getVersion();
            if (version.compareTo(context.lastApplied) > 0) {
                if (av.getLeft().getType() == CoreMigrationType.DELETE || av.getRight().deleted || !av.getLeft().isVersioned() || av.getRight().undone) continue;
                context.lastApplied = version;
                continue;
            }
            av.getRight().outOfOrder = true;
        }
    }

    private void markRepeatableAsDeleted(String description, List<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedRepeatable) {
        for (int i = appliedRepeatable.size() - 1; i >= 0; --i) {
            Pair<AppliedMigration, AppliedMigrationAttributes> ar = appliedRepeatable.get(i);
            if (ar.getLeft().getType().isSynthetic() || !description.equals(ar.getLeft().getDescription())) continue;
            if (!ar.getRight().deleted) {
                ar.getRight().deleted = true;
            }
            return;
        }
    }

    private void markAsDeleted(MigrationVersion version, List<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedVersioned) {
        for (int i = appliedVersioned.size() - 1; i >= 0; --i) {
            Pair<AppliedMigration, AppliedMigrationAttributes> av = appliedVersioned.get(i);
            if (av.getLeft().getType().isSynthetic() || !version.equals(av.getLeft().getVersion())) continue;
            if (av.getRight().deleted) {
                throw new FlywayException("Corrupted schema history: multiple delete entries for version " + String.valueOf(version), CoreErrorCode.DUPLICATE_DELETED_MIGRATION);
            }
            av.getRight().deleted = true;
            return;
        }
    }

    @Override
    public MigrationInfo[] all() {
        return (MigrationInfo[])this.migrationInfos.toArray(MigrationInfo[]::new);
    }

    @Override
    public MigrationInfo[] all(MigrationFilter filter) {
        if (filter == null) {
            return (MigrationInfo[])this.migrationInfos.toArray(MigrationInfo[]::new);
        }
        return (MigrationInfo[])this.migrationInfos.stream().filter(m -> filter.matches((MigrationInfo)m) || m.getState() == MigrationState.AVAILABLE).toArray(MigrationInfo[]::new);
    }

    @Override
    public MigrationInfo current() {
        MigrationInfoImpl current = null;
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied() || MigrationState.DELETED.equals((Object)migrationInfo.getState()) || migrationInfo.getType().equals(CoreMigrationType.DELETE) || MigrationState.UNDONE.equals((Object)migrationInfo.getState()) || !migrationInfo.isVersioned() || current != null && migrationInfo.getVersion().compareTo(current.getVersion()) <= 0) continue;
            current = migrationInfo;
        }
        if (current != null) {
            return current;
        }
        for (int i = this.migrationInfos.size() - 1; i >= 0; --i) {
            MigrationInfoImpl migrationInfo;
            migrationInfo = this.migrationInfos.get(i);
            if (!migrationInfo.getState().isApplied() || MigrationState.DELETED.equals((Object)migrationInfo.getState()) || migrationInfo.getType().equals(CoreMigrationType.DELETE) || MigrationState.UNDONE.equals((Object)migrationInfo.getState()) || migrationInfo.getVersion() != null) continue;
            return migrationInfo;
        }
        return null;
    }

    public MigrationInfoImpl[] pending() {
        ArrayList<MigrationInfoImpl> pendingMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (MigrationState.PENDING != migrationInfo.getState()) continue;
            pendingMigrations.add(migrationInfo);
        }
        return (MigrationInfoImpl[])pendingMigrations.toArray(MigrationInfoImpl[]::new);
    }

    public MigrationInfoImpl[] applied() {
        ArrayList<MigrationInfoImpl> appliedMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied()) continue;
            appliedMigrations.add(migrationInfo);
        }
        return (MigrationInfoImpl[])appliedMigrations.toArray(MigrationInfoImpl[]::new);
    }

    public MigrationInfo[] resolved() {
        ArrayList<MigrationInfo> resolvedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isResolved()) continue;
            resolvedMigrations.add(migrationInfo);
        }
        return (MigrationInfo[])resolvedMigrations.toArray(MigrationInfo[]::new);
    }

    public MigrationInfoImpl[] failed() {
        ArrayList<MigrationInfoImpl> failedMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isFailed()) continue;
            failedMigrations.add(migrationInfo);
        }
        return (MigrationInfoImpl[])failedMigrations.toArray(MigrationInfoImpl[]::new);
    }

    public MigrationInfo[] future() {
        ArrayList<MigrationInfo> futureMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.FUTURE_SUCCESS && migrationInfo.getState() != MigrationState.FUTURE_FAILED || !migrationInfo.isVersioned()) continue;
            futureMigrations.add(migrationInfo);
        }
        return (MigrationInfo[])futureMigrations.toArray(MigrationInfo[]::new);
    }

    public MigrationInfo[] outOfOrder() {
        ArrayList<MigrationInfo> outOfOrderMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.OUT_OF_ORDER) continue;
            outOfOrderMigrations.add(migrationInfo);
        }
        return (MigrationInfo[])outOfOrderMigrations.toArray(MigrationInfo[]::new);
    }

    public MigrationInfoImpl[] undo() {
        ArrayList<MigrationInfoImpl> result = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getType().isUndo()) continue;
            result.add(migrationInfo);
        }
        return (MigrationInfoImpl[])result.toArray(MigrationInfoImpl[]::new);
    }

    public List<ValidateOutput> validate() {
        ArrayList<ValidateOutput> invalidMigrations = new ArrayList<ValidateOutput>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            ErrorDetails validateError = migrationInfo.validate();
            if (validateError == null) continue;
            invalidMigrations.add(CommandResultFactory.createValidateOutput(migrationInfo, validateError));
        }
        return invalidMigrations;
    }

    public void setAllSchemasEmpty(Schema[] schemas) {
        this.allSchemasEmpty = Arrays.stream(schemas).filter(Schema::exists).allMatch(Schema::empty);
    }

    @Override
    public InfoResult getInfoResult() {
        return this.getInfoResult(this.all());
    }

    public InfoResult getInfoResult(MigrationInfo[] infos) {
        return CommandResultFactory.createInfoResult(this.configuration, this.database, infos, this.current(), (boolean)this.allSchemasEmpty);
    }

    @Override
    public InfoResult getInfoResult(MigrationFilter filter) {
        return this.getInfoResult(this.all(filter));
    }
}

