# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_pgp_sig2dot_cli_global_optspecs
	string join \n v/verbose q/quiet h/help V/version
end

function __fish_pgp_sig2dot_cli_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_pgp_sig2dot_cli_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_pgp_sig2dot_cli_using_subcommand
	set -l cmd (__fish_pgp_sig2dot_cli_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_needs_command" -s h -l help -d 'Print help'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_needs_command" -s V -l version -d 'Print version'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_needs_command" -f -a "cli" -d 'Generate Cli manual or shell auto complete file'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_needs_command" -f -a "draw" -d 'Draw the trust graph'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_needs_command" -f -a "fetch" -d 'Fetch keys from the Internet by multiple sources'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and not __fish_seen_subcommand_from manpage complete help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and not __fish_seen_subcommand_from manpage complete help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and not __fish_seen_subcommand_from manpage complete help" -s h -l help -d 'Print help'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and not __fish_seen_subcommand_from manpage complete help" -f -a "manpage" -d 'Generate manual file'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and not __fish_seen_subcommand_from manpage complete help" -f -a "complete" -d 'Generate shell auto complete file'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and not __fish_seen_subcommand_from manpage complete help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from manpage" -l path -d 'Output Path' -r
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from manpage" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from manpage" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from manpage" -s h -l help -d 'Print help'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from complete" -l output -d 'Output Path' -r
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from complete" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from complete" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from complete" -s h -l help -d 'Print help'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from help" -f -a "manpage" -d 'Generate manual file'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from help" -f -a "complete" -d 'Generate shell auto complete file'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand cli; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -s k -l fingerprint -d 'Specific keys by fingerprint' -r
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -s i -l import -d 'Import OpenPGP key set from file or stdin' -r
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -l keyserver -d 'Key server address' -r
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -l gossip -d 'Gossip the trust paths to the targets (given above by `--fingerprint`), with an integer value which means the depth limit of gossiping' -r
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -l trust-root -d 'Set the trust roots in the gossip mode' -r
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -s t -l type -d 'The output format' -r -f -a "DOT\t''
METADATA\t'DOT format with metadata in JSON format in label'
KEY_BLOCK\t'OpenPGP key block format can be imported to GnuPG, etc'
MAP42\t'Works with https://github.com/cryolitia/map42'"
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -s p -l show-primary-uid-only -d 'Include only primary UIDs'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -l show-self-sigs -d 'Include self-signatures'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -l online -d 'Fetch the newest keys from key server'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand draw" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand fetch" -l keyserver -d 'Key server addresses' -r
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand fetch" -l from -d 'Sources to fetch keys from' -r -f -a "key-server\t'Fetch from key servers'
wkd\t'Fetch from Web Key Directory'
github\t'Fetch from GitHub'
all\t'All'"
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand fetch" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand fetch" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand help; and not __fish_seen_subcommand_from cli draw fetch help" -f -a "cli" -d 'Generate Cli manual or shell auto complete file'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand help; and not __fish_seen_subcommand_from cli draw fetch help" -f -a "draw" -d 'Draw the trust graph'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand help; and not __fish_seen_subcommand_from cli draw fetch help" -f -a "fetch" -d 'Fetch keys from the Internet by multiple sources'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand help; and not __fish_seen_subcommand_from cli draw fetch help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand help; and __fish_seen_subcommand_from cli" -f -a "manpage" -d 'Generate manual file'
complete -c pgp-sig2dot-cli -n "__fish_pgp_sig2dot_cli_using_subcommand help; and __fish_seen_subcommand_from cli" -f -a "complete" -d 'Generate shell auto complete file'
