/* Generated by wayland-scanner 1.24.0 */

#ifndef KDE_LOCKSCREEN_OVERLAY_V1_CLIENT_PROTOCOL_H
#define KDE_LOCKSCREEN_OVERLAY_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_kde_lockscreen_overlay_v1 The kde_lockscreen_overlay_v1 protocol
 * @section page_ifaces_kde_lockscreen_overlay_v1 Interfaces
 * - @subpage page_iface_kde_lockscreen_overlay_v1 - Allow surfaces over the lockscreen
 * @section page_copyright_kde_lockscreen_overlay_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2022 Aleix Pol Gonzalez <aleixpol@kde.org>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct kde_lockscreen_overlay_v1;
struct wl_surface;

#ifndef KDE_LOCKSCREEN_OVERLAY_V1_INTERFACE
#define KDE_LOCKSCREEN_OVERLAY_V1_INTERFACE
/**
 * @page page_iface_kde_lockscreen_overlay_v1 kde_lockscreen_overlay_v1
 * @section page_iface_kde_lockscreen_overlay_v1_desc Description
 *
 * Allows a client to request a surface to be visible when the system is locked.
 *
 * This is meant to be used for specific high urgency cases like phone calls or alarms.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 * @section page_iface_kde_lockscreen_overlay_v1_api API
 * See @ref iface_kde_lockscreen_overlay_v1.
 */
/**
 * @defgroup iface_kde_lockscreen_overlay_v1 The kde_lockscreen_overlay_v1 interface
 *
 * Allows a client to request a surface to be visible when the system is locked.
 *
 * This is meant to be used for specific high urgency cases like phone calls or alarms.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 */
extern const struct wl_interface kde_lockscreen_overlay_v1_interface;
#endif

#ifndef KDE_LOCKSCREEN_OVERLAY_V1_ERROR_ENUM
#define KDE_LOCKSCREEN_OVERLAY_V1_ERROR_ENUM
enum kde_lockscreen_overlay_v1_error {
	/**
	 * the client provided an invalid surface state
	 */
	KDE_LOCKSCREEN_OVERLAY_V1_ERROR_INVALID_SURFACE_STATE = 0,
};
#endif /* KDE_LOCKSCREEN_OVERLAY_V1_ERROR_ENUM */

#define KDE_LOCKSCREEN_OVERLAY_V1_ALLOW 0
#define KDE_LOCKSCREEN_OVERLAY_V1_DESTROY 1


/**
 * @ingroup iface_kde_lockscreen_overlay_v1
 */
#define KDE_LOCKSCREEN_OVERLAY_V1_ALLOW_SINCE_VERSION 1
/**
 * @ingroup iface_kde_lockscreen_overlay_v1
 */
#define KDE_LOCKSCREEN_OVERLAY_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_kde_lockscreen_overlay_v1 */
static inline void
kde_lockscreen_overlay_v1_set_user_data(struct kde_lockscreen_overlay_v1 *kde_lockscreen_overlay_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_lockscreen_overlay_v1, user_data);
}

/** @ingroup iface_kde_lockscreen_overlay_v1 */
static inline void *
kde_lockscreen_overlay_v1_get_user_data(struct kde_lockscreen_overlay_v1 *kde_lockscreen_overlay_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_lockscreen_overlay_v1);
}

static inline uint32_t
kde_lockscreen_overlay_v1_get_version(struct kde_lockscreen_overlay_v1 *kde_lockscreen_overlay_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_lockscreen_overlay_v1);
}

/**
 * @ingroup iface_kde_lockscreen_overlay_v1
 *
 * Informs the compositor that the surface could be shown when the screen is locked. This request should be called while the surface is unmapped.
 */
static inline void
kde_lockscreen_overlay_v1_allow(struct kde_lockscreen_overlay_v1 *kde_lockscreen_overlay_v1, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_lockscreen_overlay_v1,
			 KDE_LOCKSCREEN_OVERLAY_V1_ALLOW, NULL, wl_proxy_get_version((struct wl_proxy *) kde_lockscreen_overlay_v1), 0, surface);
}

/**
 * @ingroup iface_kde_lockscreen_overlay_v1
 *
 * This won't affect the surface previously marked with the allow request.
 */
static inline void
kde_lockscreen_overlay_v1_destroy(struct kde_lockscreen_overlay_v1 *kde_lockscreen_overlay_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_lockscreen_overlay_v1,
			 KDE_LOCKSCREEN_OVERLAY_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_lockscreen_overlay_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
