from typing import Any, Dict, Iterable, Iterator
from collections.abc import MutableMapping

from ._value import AbstractBaseMutableTag, AbstractBaseTag
from ._dtype import AnyNBT
from ._int import ByteTag, ShortTag, IntTag, LongTag
from ._float import FloatTag, DoubleTag
from ._string import StringTag
from ._list import ListTag
from ._array import ByteArrayTag, IntArrayTag, LongArrayTag

class CompoundTag(AbstractBaseMutableTag, MutableMapping[str, AnyNBT]):
    tag_id: int
    def __init__(self, value: Any = (), **kwvals: AnyNBT): ...
    @staticmethod
    def fromkeys(keys: Iterable[str], value: AbstractBaseTag = None): ...
    @property
    def py_dict(self) -> Dict[str, AnyNBT]: ...
    def get_byte(self, key: str, default: ByteTag = None) -> ByteTag: ...
    def get_short(self, key: str, default: ShortTag = None) -> ShortTag: ...
    def get_int(self, key: str, default: IntTag = None) -> IntTag: ...
    def get_long(self, key: str, default: LongTag = None) -> LongTag: ...
    def get_float(self, key: str, default: FloatTag = None) -> FloatTag: ...
    def get_double(self, key: str, default: DoubleTag = None) -> DoubleTag: ...
    def get_string(self, key: str, default: StringTag = None) -> StringTag: ...
    def get_list(self, key: str, default: ListTag = None) -> ListTag: ...
    def get_compound(self, key: str, default: CompoundTag = None) -> CompoundTag: ...
    def get_byte_array(
        self, key: str, default: ByteArrayTag = None
    ) -> ByteArrayTag: ...
    def get_int_array(self, key: str, default: IntArrayTag = None) -> IntArrayTag: ...
    def get_long_array(
        self, key: str, default: LongArrayTag = None
    ) -> LongArrayTag: ...
    def setdefault_byte(self, key: str, default: ByteTag = None) -> ByteTag: ...
    def setdefault_short(self, key: str, default: ShortTag = None) -> ShortTag: ...
    def setdefault_int(self, key: str, default: IntTag = None) -> IntTag: ...
    def setdefault_long(self, key: str, default: LongTag = None) -> LongTag: ...
    def setdefault_float(self, key: str, default: FloatTag = None) -> FloatTag: ...
    def setdefault_double(self, key: str, default: DoubleTag = None) -> DoubleTag: ...
    def setdefault_string(self, key: str, default: StringTag = None) -> StringTag: ...
    def setdefault_list(self, key: str, default: ListTag = None) -> ListTag: ...
    def setdefault_compound(
        self, key: str, default: CompoundTag = None
    ) -> CompoundTag: ...
    def setdefault_byte_array(
        self, key: str, default: ByteArrayTag = None
    ) -> ByteArrayTag: ...
    def setdefault_int_array(
        self, key: str, default: IntArrayTag = None
    ) -> IntArrayTag: ...
    def setdefault_long_array(
        self, key: str, default: LongArrayTag = None
    ) -> LongArrayTag: ...
    def __getitem__(self, item: str) -> AnyNBT: ...
    def __setitem__(self, key: str, value: AnyNBT) -> None: ...
    def __delitem__(self, item: str) -> None: ...
    def __iter__(self) -> Iterator[str]: ...
    def __len__(self) -> int: ...
