# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NetworkConfiguration(object):
    """
    A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NetworkConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param subnet_id:
            The value to assign to the subnet_id property of this NetworkConfiguration.
        :type subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this NetworkConfiguration.
        :type nsg_ids: list[str]

        """
        self.swagger_types = {
            'subnet_id': 'str',
            'nsg_ids': 'list[str]'
        }
        self.attribute_map = {
            'subnet_id': 'subnetId',
            'nsg_ids': 'nsgIds'
        }
        self._subnet_id = None
        self._nsg_ids = None

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this NetworkConfiguration.
        The Oracle Cloud Identifier (`OCID`__) of the subnet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this NetworkConfiguration.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this NetworkConfiguration.
        The Oracle Cloud Identifier (`OCID`__) of the subnet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this NetworkConfiguration.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this NetworkConfiguration.
        The list of Oracle Cloud Identifiers (`OCID`__) corresponding to Network Security Groups.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The nsg_ids of this NetworkConfiguration.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this NetworkConfiguration.
        The list of Oracle Cloud Identifiers (`OCID`__) corresponding to Network Security Groups.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param nsg_ids: The nsg_ids of this NetworkConfiguration.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
