# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101

from .realtime_message_authentication import RealtimeMessageAuthentication
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RealtimeMessageAuthenticationToken(RealtimeMessageAuthentication):
    """
    The payload for JWT based authentication.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RealtimeMessageAuthenticationToken object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_speech.models.RealtimeMessageAuthenticationToken.authentication_type` attribute
        of this class is ``TOKEN`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param authentication_type:
            The value to assign to the authentication_type property of this RealtimeMessageAuthenticationToken.
            Allowed values for this property are: "CREDENTIALS", "TOKEN"
        :type authentication_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RealtimeMessageAuthenticationToken.
        :type compartment_id: str

        :param token:
            The value to assign to the token property of this RealtimeMessageAuthenticationToken.
        :type token: str

        """
        self.swagger_types = {
            'authentication_type': 'str',
            'compartment_id': 'str',
            'token': 'str'
        }
        self.attribute_map = {
            'authentication_type': 'authenticationType',
            'compartment_id': 'compartmentId',
            'token': 'token'
        }
        self._authentication_type = None
        self._compartment_id = None
        self._token = None
        self._authentication_type = 'TOKEN'

    @property
    def token(self):
        """
        **[Required]** Gets the token of this RealtimeMessageAuthenticationToken.
        The token (JWT) obtained from the realtime transcription session endpoint.


        :return: The token of this RealtimeMessageAuthenticationToken.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Sets the token of this RealtimeMessageAuthenticationToken.
        The token (JWT) obtained from the realtime transcription session endpoint.


        :param token: The token of this RealtimeMessageAuthenticationToken.
        :type: str
        """
        self._token = token

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
