# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .stream_source_details import StreamSourceDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RtspSourceDetails(StreamSourceDetails):
    """
    Details of RtspDevice
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RtspSourceDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_vision.models.RtspSourceDetails.source_type` attribute
        of this class is ``RTSP`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param stream_network_access_details:
            The value to assign to the stream_network_access_details property of this RtspSourceDetails.
        :type stream_network_access_details: oci.ai_vision.models.StreamNetworkAccessDetails

        :param source_type:
            The value to assign to the source_type property of this RtspSourceDetails.
            Allowed values for this property are: "RTSP"
        :type source_type: str

        :param secret_id:
            The value to assign to the secret_id property of this RtspSourceDetails.
        :type secret_id: str

        :param camera_url:
            The value to assign to the camera_url property of this RtspSourceDetails.
        :type camera_url: str

        """
        self.swagger_types = {
            'stream_network_access_details': 'StreamNetworkAccessDetails',
            'source_type': 'str',
            'secret_id': 'str',
            'camera_url': 'str'
        }
        self.attribute_map = {
            'stream_network_access_details': 'streamNetworkAccessDetails',
            'source_type': 'sourceType',
            'secret_id': 'secretId',
            'camera_url': 'cameraUrl'
        }
        self._stream_network_access_details = None
        self._source_type = None
        self._secret_id = None
        self._camera_url = None
        self._source_type = 'RTSP'

    @property
    def secret_id(self):
        """
        Gets the secret_id of this RtspSourceDetails.
        `OCID`__ of secret where credentials are stored in username:password format.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The secret_id of this RtspSourceDetails.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this RtspSourceDetails.
        `OCID`__ of secret where credentials are stored in username:password format.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param secret_id: The secret_id of this RtspSourceDetails.
        :type: str
        """
        self._secret_id = secret_id

    @property
    def camera_url(self):
        """
        **[Required]** Gets the camera_url of this RtspSourceDetails.
        url of camera


        :return: The camera_url of this RtspSourceDetails.
        :rtype: str
        """
        return self._camera_url

    @camera_url.setter
    def camera_url(self, camera_url):
        """
        Sets the camera_url of this RtspSourceDetails.
        url of camera


        :param camera_url: The camera_url of this RtspSourceDetails.
        :type: str
        """
        self._camera_url = camera_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
