# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoLabel(object):
    """
    Detected label in a video.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoLabel object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this VideoLabel.
        :type name: str

        :param segments:
            The value to assign to the segments property of this VideoLabel.
        :type segments: list[oci.ai_vision.models.VideoLabelSegment]

        """
        self.swagger_types = {
            'name': 'str',
            'segments': 'list[VideoLabelSegment]'
        }
        self.attribute_map = {
            'name': 'name',
            'segments': 'segments'
        }
        self._name = None
        self._segments = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this VideoLabel.
        Detected label name.


        :return: The name of this VideoLabel.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VideoLabel.
        Detected label name.


        :param name: The name of this VideoLabel.
        :type: str
        """
        self._name = name

    @property
    def segments(self):
        """
        **[Required]** Gets the segments of this VideoLabel.
        Label segments in a video.


        :return: The segments of this VideoLabel.
        :rtype: list[oci.ai_vision.models.VideoLabelSegment]
        """
        return self._segments

    @segments.setter
    def segments(self, segments):
        """
        Sets the segments of this VideoLabel.
        Label segments in a video.


        :param segments: The segments of this VideoLabel.
        :type: list[oci.ai_vision.models.VideoLabelSegment]
        """
        self._segments = segments

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
