# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201

from .update_config_details import UpdateConfigDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateMacsApmExtensionDetails(UpdateConfigDetails):
    """
    An object that represents APM Agent provisioning via a Management Agent.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateMacsApmExtensionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.apm_config.models.UpdateMacsApmExtensionDetails.config_type` attribute
        of this class is ``MACS_APM_EXTENSION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_type:
            The value to assign to the config_type property of this UpdateMacsApmExtensionDetails.
            Allowed values for this property are: "SPAN_FILTER", "METRIC_GROUP", "APDEX", "OPTIONS", "AGENT", "MACS_APM_EXTENSION"
        :type config_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateMacsApmExtensionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateMacsApmExtensionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this UpdateMacsApmExtensionDetails.
        :type display_name: str

        :param process_filter:
            The value to assign to the process_filter property of this UpdateMacsApmExtensionDetails.
        :type process_filter: list[str]

        :param run_as_user:
            The value to assign to the run_as_user property of this UpdateMacsApmExtensionDetails.
        :type run_as_user: str

        :param service_name:
            The value to assign to the service_name property of this UpdateMacsApmExtensionDetails.
        :type service_name: str

        :param agent_version:
            The value to assign to the agent_version property of this UpdateMacsApmExtensionDetails.
        :type agent_version: str

        :param attach_install_dir:
            The value to assign to the attach_install_dir property of this UpdateMacsApmExtensionDetails.
        :type attach_install_dir: str

        """
        self.swagger_types = {
            'config_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'process_filter': 'list[str]',
            'run_as_user': 'str',
            'service_name': 'str',
            'agent_version': 'str',
            'attach_install_dir': 'str'
        }
        self.attribute_map = {
            'config_type': 'configType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'process_filter': 'processFilter',
            'run_as_user': 'runAsUser',
            'service_name': 'serviceName',
            'agent_version': 'agentVersion',
            'attach_install_dir': 'attachInstallDir'
        }
        self._config_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._display_name = None
        self._process_filter = None
        self._run_as_user = None
        self._service_name = None
        self._agent_version = None
        self._attach_install_dir = None
        self._config_type = 'MACS_APM_EXTENSION'

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateMacsApmExtensionDetails.
        The name by which a configuration entity is displayed to the end user.


        :return: The display_name of this UpdateMacsApmExtensionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateMacsApmExtensionDetails.
        The name by which a configuration entity is displayed to the end user.


        :param display_name: The display_name of this UpdateMacsApmExtensionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def process_filter(self):
        """
        Gets the process_filter of this UpdateMacsApmExtensionDetails.
        Filter patterns used to discover active Java processes for provisioning the APM Agent.


        :return: The process_filter of this UpdateMacsApmExtensionDetails.
        :rtype: list[str]
        """
        return self._process_filter

    @process_filter.setter
    def process_filter(self, process_filter):
        """
        Sets the process_filter of this UpdateMacsApmExtensionDetails.
        Filter patterns used to discover active Java processes for provisioning the APM Agent.


        :param process_filter: The process_filter of this UpdateMacsApmExtensionDetails.
        :type: list[str]
        """
        self._process_filter = process_filter

    @property
    def run_as_user(self):
        """
        Gets the run_as_user of this UpdateMacsApmExtensionDetails.
        The OS user that should be used to discover Java processes.


        :return: The run_as_user of this UpdateMacsApmExtensionDetails.
        :rtype: str
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """
        Sets the run_as_user of this UpdateMacsApmExtensionDetails.
        The OS user that should be used to discover Java processes.


        :param run_as_user: The run_as_user of this UpdateMacsApmExtensionDetails.
        :type: str
        """
        self._run_as_user = run_as_user

    @property
    def service_name(self):
        """
        Gets the service_name of this UpdateMacsApmExtensionDetails.
        The name of the service being monitored. This argument enables you to filter by
        service and view traces and other signals in the APM Explorer user interface.


        :return: The service_name of this UpdateMacsApmExtensionDetails.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """
        Sets the service_name of this UpdateMacsApmExtensionDetails.
        The name of the service being monitored. This argument enables you to filter by
        service and view traces and other signals in the APM Explorer user interface.


        :param service_name: The service_name of this UpdateMacsApmExtensionDetails.
        :type: str
        """
        self._service_name = service_name

    @property
    def agent_version(self):
        """
        Gets the agent_version of this UpdateMacsApmExtensionDetails.
        The version of the referenced agent bundle.


        :return: The agent_version of this UpdateMacsApmExtensionDetails.
        :rtype: str
        """
        return self._agent_version

    @agent_version.setter
    def agent_version(self, agent_version):
        """
        Sets the agent_version of this UpdateMacsApmExtensionDetails.
        The version of the referenced agent bundle.


        :param agent_version: The agent_version of this UpdateMacsApmExtensionDetails.
        :type: str
        """
        self._agent_version = agent_version

    @property
    def attach_install_dir(self):
        """
        Gets the attach_install_dir of this UpdateMacsApmExtensionDetails.
        The directory owned by runAsUser.


        :return: The attach_install_dir of this UpdateMacsApmExtensionDetails.
        :rtype: str
        """
        return self._attach_install_dir

    @attach_install_dir.setter
    def attach_install_dir(self, attach_install_dir):
        """
        Sets the attach_install_dir of this UpdateMacsApmExtensionDetails.
        The directory owned by runAsUser.


        :param attach_install_dir: The attach_install_dir of this UpdateMacsApmExtensionDetails.
        :type: str
        """
        self._attach_install_dir = attach_install_dir

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
