# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOccCustomerDetails(object):
    """
    Details about the update request for updating the customer.
    """

    #: A constant which can be used with the status property of a UpdateOccCustomerDetails.
    #: This constant has a value of "ENABLED"
    STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the status property of a UpdateOccCustomerDetails.
    #: This constant has a value of "DISABLED"
    STATUS_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOccCustomerDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateOccCustomerDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateOccCustomerDetails.
        :type description: str

        :param status:
            The value to assign to the status property of this UpdateOccCustomerDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type status: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'status': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'status': 'status'
        }
        self._display_name = None
        self._description = None
        self._status = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateOccCustomerDetails.
        The display name of the customer.


        :return: The display_name of this UpdateOccCustomerDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateOccCustomerDetails.
        The display name of the customer.


        :param display_name: The display_name of this UpdateOccCustomerDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateOccCustomerDetails.
        Additional information about the customer.


        :return: The description of this UpdateOccCustomerDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateOccCustomerDetails.
        Additional information about the customer.


        :param description: The description of this UpdateOccCustomerDetails.
        :type: str
        """
        self._description = description

    @property
    def status(self):
        """
        Gets the status of this UpdateOccCustomerDetails.
        To determine whether the customer group is enabled/disabled.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The status of this UpdateOccCustomerDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this UpdateOccCustomerDetails.
        To determine whether the customer group is enabled/disabled.


        :param status: The status of this UpdateOccCustomerDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            raise ValueError(
                f"Invalid value for `status`, must be None or one of {allowed_values}"
            )
        self._status = status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
