# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreatePrivateIpDetails(object):
    """
    CreatePrivateIpDetails model.
    """

    #: A constant which can be used with the lifetime property of a CreatePrivateIpDetails.
    #: This constant has a value of "EPHEMERAL"
    LIFETIME_EPHEMERAL = "EPHEMERAL"

    #: A constant which can be used with the lifetime property of a CreatePrivateIpDetails.
    #: This constant has a value of "RESERVED"
    LIFETIME_RESERVED = "RESERVED"

    def __init__(self, **kwargs):
        """
        Initializes a new CreatePrivateIpDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param defined_tags:
            The value to assign to the defined_tags property of this CreatePrivateIpDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this CreatePrivateIpDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreatePrivateIpDetails.
        :type freeform_tags: dict(str, str)

        :param hostname_label:
            The value to assign to the hostname_label property of this CreatePrivateIpDetails.
        :type hostname_label: str

        :param ip_address:
            The value to assign to the ip_address property of this CreatePrivateIpDetails.
        :type ip_address: str

        :param vnic_id:
            The value to assign to the vnic_id property of this CreatePrivateIpDetails.
        :type vnic_id: str

        :param vlan_id:
            The value to assign to the vlan_id property of this CreatePrivateIpDetails.
        :type vlan_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreatePrivateIpDetails.
        :type subnet_id: str

        :param lifetime:
            The value to assign to the lifetime property of this CreatePrivateIpDetails.
            Allowed values for this property are: "EPHEMERAL", "RESERVED"
        :type lifetime: str

        :param route_table_id:
            The value to assign to the route_table_id property of this CreatePrivateIpDetails.
        :type route_table_id: str

        """
        self.swagger_types = {
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'hostname_label': 'str',
            'ip_address': 'str',
            'vnic_id': 'str',
            'vlan_id': 'str',
            'subnet_id': 'str',
            'lifetime': 'str',
            'route_table_id': 'str'
        }
        self.attribute_map = {
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'hostname_label': 'hostnameLabel',
            'ip_address': 'ipAddress',
            'vnic_id': 'vnicId',
            'vlan_id': 'vlanId',
            'subnet_id': 'subnetId',
            'lifetime': 'lifetime',
            'route_table_id': 'routeTableId'
        }
        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None
        self._hostname_label = None
        self._ip_address = None
        self._vnic_id = None
        self._vlan_id = None
        self._subnet_id = None
        self._lifetime = None
        self._route_table_id = None

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreatePrivateIpDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreatePrivateIpDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreatePrivateIpDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreatePrivateIpDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this CreatePrivateIpDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this CreatePrivateIpDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreatePrivateIpDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreatePrivateIpDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreatePrivateIpDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreatePrivateIpDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreatePrivateIpDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreatePrivateIpDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def hostname_label(self):
        """
        Gets the hostname_label of this CreatePrivateIpDetails.
        The hostname for the private IP. Used for DNS. The value
        is the hostname portion of the private IP's fully qualified domain name (FQDN)
        (for example, `bminstance1` in FQDN `bminstance1.subnet123.vcn1.oraclevcn.com`).
        Must be unique across all VNICs in the subnet and comply with
        `RFC 952`__ and
        `RFC 1123`__.

        For more information, see
        `DNS in Your Virtual Cloud Network`__.

        Example: `bminstance1`

        __ https://tools.ietf.org/html/rfc952
        __ https://tools.ietf.org/html/rfc1123
        __ https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm


        :return: The hostname_label of this CreatePrivateIpDetails.
        :rtype: str
        """
        return self._hostname_label

    @hostname_label.setter
    def hostname_label(self, hostname_label):
        """
        Sets the hostname_label of this CreatePrivateIpDetails.
        The hostname for the private IP. Used for DNS. The value
        is the hostname portion of the private IP's fully qualified domain name (FQDN)
        (for example, `bminstance1` in FQDN `bminstance1.subnet123.vcn1.oraclevcn.com`).
        Must be unique across all VNICs in the subnet and comply with
        `RFC 952`__ and
        `RFC 1123`__.

        For more information, see
        `DNS in Your Virtual Cloud Network`__.

        Example: `bminstance1`

        __ https://tools.ietf.org/html/rfc952
        __ https://tools.ietf.org/html/rfc1123
        __ https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm


        :param hostname_label: The hostname_label of this CreatePrivateIpDetails.
        :type: str
        """
        self._hostname_label = hostname_label

    @property
    def ip_address(self):
        """
        Gets the ip_address of this CreatePrivateIpDetails.
        A private IP address of your choice. Must be an available IP address within
        the subnet's CIDR. If you don't specify a value, Oracle automatically
        assigns a private IP address from the subnet.

        Example: `10.0.3.3`


        :return: The ip_address of this CreatePrivateIpDetails.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this CreatePrivateIpDetails.
        A private IP address of your choice. Must be an available IP address within
        the subnet's CIDR. If you don't specify a value, Oracle automatically
        assigns a private IP address from the subnet.

        Example: `10.0.3.3`


        :param ip_address: The ip_address of this CreatePrivateIpDetails.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def vnic_id(self):
        """
        Gets the vnic_id of this CreatePrivateIpDetails.
        The `OCID`__ of the VNIC to assign the private IP to. The VNIC and private IP
        must be in the same subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vnic_id of this CreatePrivateIpDetails.
        :rtype: str
        """
        return self._vnic_id

    @vnic_id.setter
    def vnic_id(self, vnic_id):
        """
        Sets the vnic_id of this CreatePrivateIpDetails.
        The `OCID`__ of the VNIC to assign the private IP to. The VNIC and private IP
        must be in the same subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vnic_id: The vnic_id of this CreatePrivateIpDetails.
        :type: str
        """
        self._vnic_id = vnic_id

    @property
    def vlan_id(self):
        """
        Gets the vlan_id of this CreatePrivateIpDetails.
        Use this attribute only with the Oracle Cloud VMware Solution.

        The `OCID`__ of the VLAN from which the private IP is to be drawn. The IP address,
        *if supplied*, must be valid for the given VLAN. See :class:`Vlan`.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vlan_id of this CreatePrivateIpDetails.
        :rtype: str
        """
        return self._vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        """
        Sets the vlan_id of this CreatePrivateIpDetails.
        Use this attribute only with the Oracle Cloud VMware Solution.

        The `OCID`__ of the VLAN from which the private IP is to be drawn. The IP address,
        *if supplied*, must be valid for the given VLAN. See :class:`Vlan`.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vlan_id: The vlan_id of this CreatePrivateIpDetails.
        :type: str
        """
        self._vlan_id = vlan_id

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this CreatePrivateIpDetails.
        The `OCID`__ of the subnet from which the private IP is to be drawn. The IP address,
        *if supplied*, must be valid for the given subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this CreatePrivateIpDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreatePrivateIpDetails.
        The `OCID`__ of the subnet from which the private IP is to be drawn. The IP address,
        *if supplied*, must be valid for the given subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this CreatePrivateIpDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def lifetime(self):
        """
        Gets the lifetime of this CreatePrivateIpDetails.
        Lifetime of the IP address.
        There are two types of IPs:
         - Ephemeral
         - Reserved

        Allowed values for this property are: "EPHEMERAL", "RESERVED"


        :return: The lifetime of this CreatePrivateIpDetails.
        :rtype: str
        """
        return self._lifetime

    @lifetime.setter
    def lifetime(self, lifetime):
        """
        Sets the lifetime of this CreatePrivateIpDetails.
        Lifetime of the IP address.
        There are two types of IPs:
         - Ephemeral
         - Reserved


        :param lifetime: The lifetime of this CreatePrivateIpDetails.
        :type: str
        """
        allowed_values = ["EPHEMERAL", "RESERVED"]
        if not value_allowed_none_or_none_sentinel(lifetime, allowed_values):
            raise ValueError(
                f"Invalid value for `lifetime`, must be None or one of {allowed_values}"
            )
        self._lifetime = lifetime

    @property
    def route_table_id(self):
        """
        Gets the route_table_id of this CreatePrivateIpDetails.
        The `OCID`__ of the route table the IP address or VNIC will use. For more information, see
        `Per-resource Routing`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm
        __ https://docs.oracle.com/iaas/Content/Network/Tasks/managingroutetables.htm#Overview_of_Routing_for_Your_VCN__source_routing


        :return: The route_table_id of this CreatePrivateIpDetails.
        :rtype: str
        """
        return self._route_table_id

    @route_table_id.setter
    def route_table_id(self, route_table_id):
        """
        Sets the route_table_id of this CreatePrivateIpDetails.
        The `OCID`__ of the route table the IP address or VNIC will use. For more information, see
        `Per-resource Routing`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm
        __ https://docs.oracle.com/iaas/Content/Network/Tasks/managingroutetables.htm#Overview_of_Routing_for_Your_VCN__source_routing


        :param route_table_id: The route_table_id of this CreatePrivateIpDetails.
        :type: str
        """
        self._route_table_id = route_table_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
