# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchSqlFirewallAllowedSqlDetails(object):
    """
    The details used to delete multiple allowed sqls.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatchSqlFirewallAllowedSqlDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param items:
            The value to assign to the items property of this PatchSqlFirewallAllowedSqlDetails.
        :type items: list[oci.data_safe.models.PatchInstruction]

        :param sql_firewall_policy_id:
            The value to assign to the sql_firewall_policy_id property of this PatchSqlFirewallAllowedSqlDetails.
        :type sql_firewall_policy_id: str

        """
        self.swagger_types = {
            'items': 'list[PatchInstruction]',
            'sql_firewall_policy_id': 'str'
        }
        self.attribute_map = {
            'items': 'items',
            'sql_firewall_policy_id': 'sqlFirewallPolicyId'
        }
        self._items = None
        self._sql_firewall_policy_id = None

    @property
    def items(self):
        """
        **[Required]** Gets the items of this PatchSqlFirewallAllowedSqlDetails.
        An array of patch instructions.


        :return: The items of this PatchSqlFirewallAllowedSqlDetails.
        :rtype: list[oci.data_safe.models.PatchInstruction]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this PatchSqlFirewallAllowedSqlDetails.
        An array of patch instructions.


        :param items: The items of this PatchSqlFirewallAllowedSqlDetails.
        :type: list[oci.data_safe.models.PatchInstruction]
        """
        self._items = items

    @property
    def sql_firewall_policy_id(self):
        """
        **[Required]** Gets the sql_firewall_policy_id of this PatchSqlFirewallAllowedSqlDetails.
        The OCID of the SQL firewall policy whose allowed SQL needs to be deleted.


        :return: The sql_firewall_policy_id of this PatchSqlFirewallAllowedSqlDetails.
        :rtype: str
        """
        return self._sql_firewall_policy_id

    @sql_firewall_policy_id.setter
    def sql_firewall_policy_id(self, sql_firewall_policy_id):
        """
        Sets the sql_firewall_policy_id of this PatchSqlFirewallAllowedSqlDetails.
        The OCID of the SQL firewall policy whose allowed SQL needs to be deleted.


        :param sql_firewall_policy_id: The sql_firewall_policy_id of this PatchSqlFirewallAllowedSqlDetails.
        :type: str
        """
        self._sql_firewall_policy_id = sql_firewall_policy_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
