# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SelectionDetails(object):
    """
    Details of the items to be selected and the mode of selection.
    """

    #: A constant which can be used with the selection_mode property of a SelectionDetails.
    #: This constant has a value of "LIST"
    SELECTION_MODE_LIST = "LIST"

    #: A constant which can be used with the selection_mode property of a SelectionDetails.
    #: This constant has a value of "SCIM_QUERY"
    SELECTION_MODE_SCIM_QUERY = "SCIM_QUERY"

    def __init__(self, **kwargs):
        """
        Initializes a new SelectionDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_safe.models.ListSelectionMode`
        * :class:`~oci.data_safe.models.ScimQuerySelectionMode`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param selection_mode:
            The value to assign to the selection_mode property of this SelectionDetails.
            Allowed values for this property are: "LIST", "SCIM_QUERY"
        :type selection_mode: str

        """
        self.swagger_types = {
            'selection_mode': 'str'
        }
        self.attribute_map = {
            'selection_mode': 'selectionMode'
        }
        self._selection_mode = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['selectionMode']

        if type == 'LIST':
            return 'ListSelectionMode'

        if type == 'SCIM_QUERY':
            return 'ScimQuerySelectionMode'
        else:
            return 'SelectionDetails'

    @property
    def selection_mode(self):
        """
        **[Required]** Gets the selection_mode of this SelectionDetails.
        The mode of selection of items, whether it is a list of ocids or a scimQuery. Allowed values:
        - LIST
        - SCIM_QUERY

        Allowed values for this property are: "LIST", "SCIM_QUERY"


        :return: The selection_mode of this SelectionDetails.
        :rtype: str
        """
        return self._selection_mode

    @selection_mode.setter
    def selection_mode(self, selection_mode):
        """
        Sets the selection_mode of this SelectionDetails.
        The mode of selection of items, whether it is a list of ocids or a scimQuery. Allowed values:
        - LIST
        - SCIM_QUERY


        :param selection_mode: The selection_mode of this SelectionDetails.
        :type: str
        """
        allowed_values = ["LIST", "SCIM_QUERY"]
        if not value_allowed_none_or_none_sentinel(selection_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `selection_mode`, must be None or one of {allowed_values}"
            )
        self._selection_mode = selection_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
