# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlFirewallViolationSummary(object):
    """
    The resource represents the SQL violations collected from the target database by Oracle Data Safe.
    """

    #: A constant which can be used with the sql_level property of a SqlFirewallViolationSummary.
    #: This constant has a value of "USER_ISSUED_SQL"
    SQL_LEVEL_USER_ISSUED_SQL = "USER_ISSUED_SQL"

    #: A constant which can be used with the sql_level property of a SqlFirewallViolationSummary.
    #: This constant has a value of "ALL_SQL"
    SQL_LEVEL_ALL_SQL = "ALL_SQL"

    #: A constant which can be used with the violation_action property of a SqlFirewallViolationSummary.
    #: This constant has a value of "BLOCKED"
    VIOLATION_ACTION_BLOCKED = "BLOCKED"

    #: A constant which can be used with the violation_action property of a SqlFirewallViolationSummary.
    #: This constant has a value of "ALLOWED"
    VIOLATION_ACTION_ALLOWED = "ALLOWED"

    def __init__(self, **kwargs):
        """
        Initializes a new SqlFirewallViolationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SqlFirewallViolationSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this SqlFirewallViolationSummary.
        :type compartment_id: str

        :param db_user_name:
            The value to assign to the db_user_name property of this SqlFirewallViolationSummary.
        :type db_user_name: str

        :param target_id:
            The value to assign to the target_id property of this SqlFirewallViolationSummary.
        :type target_id: str

        :param target_name:
            The value to assign to the target_name property of this SqlFirewallViolationSummary.
        :type target_name: str

        :param operation_time:
            The value to assign to the operation_time property of this SqlFirewallViolationSummary.
        :type operation_time: datetime

        :param time_collected:
            The value to assign to the time_collected property of this SqlFirewallViolationSummary.
        :type time_collected: datetime

        :param client_os_user_name:
            The value to assign to the client_os_user_name property of this SqlFirewallViolationSummary.
        :type client_os_user_name: str

        :param operation:
            The value to assign to the operation property of this SqlFirewallViolationSummary.
        :type operation: str

        :param sql_text:
            The value to assign to the sql_text property of this SqlFirewallViolationSummary.
        :type sql_text: str

        :param sql_accessed_objects:
            The value to assign to the sql_accessed_objects property of this SqlFirewallViolationSummary.
        :type sql_accessed_objects: str

        :param current_db_user_name:
            The value to assign to the current_db_user_name property of this SqlFirewallViolationSummary.
        :type current_db_user_name: str

        :param sql_level:
            The value to assign to the sql_level property of this SqlFirewallViolationSummary.
            Allowed values for this property are: "USER_ISSUED_SQL", "ALL_SQL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type sql_level: str

        :param client_ip:
            The value to assign to the client_ip property of this SqlFirewallViolationSummary.
        :type client_ip: str

        :param client_program:
            The value to assign to the client_program property of this SqlFirewallViolationSummary.
        :type client_program: str

        :param violation_cause:
            The value to assign to the violation_cause property of this SqlFirewallViolationSummary.
        :type violation_cause: str

        :param violation_action:
            The value to assign to the violation_action property of this SqlFirewallViolationSummary.
            Allowed values for this property are: "BLOCKED", "ALLOWED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type violation_action: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'db_user_name': 'str',
            'target_id': 'str',
            'target_name': 'str',
            'operation_time': 'datetime',
            'time_collected': 'datetime',
            'client_os_user_name': 'str',
            'operation': 'str',
            'sql_text': 'str',
            'sql_accessed_objects': 'str',
            'current_db_user_name': 'str',
            'sql_level': 'str',
            'client_ip': 'str',
            'client_program': 'str',
            'violation_cause': 'str',
            'violation_action': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'db_user_name': 'dbUserName',
            'target_id': 'targetId',
            'target_name': 'targetName',
            'operation_time': 'operationTime',
            'time_collected': 'timeCollected',
            'client_os_user_name': 'clientOsUserName',
            'operation': 'operation',
            'sql_text': 'sqlText',
            'sql_accessed_objects': 'sqlAccessedObjects',
            'current_db_user_name': 'currentDbUserName',
            'sql_level': 'sqlLevel',
            'client_ip': 'clientIp',
            'client_program': 'clientProgram',
            'violation_cause': 'violationCause',
            'violation_action': 'violationAction'
        }
        self._id = None
        self._compartment_id = None
        self._db_user_name = None
        self._target_id = None
        self._target_name = None
        self._operation_time = None
        self._time_collected = None
        self._client_os_user_name = None
        self._operation = None
        self._sql_text = None
        self._sql_accessed_objects = None
        self._current_db_user_name = None
        self._sql_level = None
        self._client_ip = None
        self._client_program = None
        self._violation_cause = None
        self._violation_action = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SqlFirewallViolationSummary.
        The OCID of the SQL violation.


        :return: The id of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SqlFirewallViolationSummary.
        The OCID of the SQL violation.


        :param id: The id of this SqlFirewallViolationSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this SqlFirewallViolationSummary.
        The OCID of the compartment containing the SQL violation.


        :return: The compartment_id of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this SqlFirewallViolationSummary.
        The OCID of the compartment containing the SQL violation.


        :param compartment_id: The compartment_id of this SqlFirewallViolationSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def db_user_name(self):
        """
        Gets the db_user_name of this SqlFirewallViolationSummary.
        The name of the database user.


        :return: The db_user_name of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._db_user_name

    @db_user_name.setter
    def db_user_name(self, db_user_name):
        """
        Sets the db_user_name of this SqlFirewallViolationSummary.
        The name of the database user.


        :param db_user_name: The db_user_name of this SqlFirewallViolationSummary.
        :type: str
        """
        self._db_user_name = db_user_name

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this SqlFirewallViolationSummary.
        The OCID of the target database.


        :return: The target_id of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this SqlFirewallViolationSummary.
        The OCID of the target database.


        :param target_id: The target_id of this SqlFirewallViolationSummary.
        :type: str
        """
        self._target_id = target_id

    @property
    def target_name(self):
        """
        **[Required]** Gets the target_name of this SqlFirewallViolationSummary.
        The name of the target database.


        :return: The target_name of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._target_name

    @target_name.setter
    def target_name(self, target_name):
        """
        Sets the target_name of this SqlFirewallViolationSummary.
        The name of the target database.


        :param target_name: The target_name of this SqlFirewallViolationSummary.
        :type: str
        """
        self._target_name = target_name

    @property
    def operation_time(self):
        """
        **[Required]** Gets the operation_time of this SqlFirewallViolationSummary.
        The time of the SQL violation occurrence in the target database.


        :return: The operation_time of this SqlFirewallViolationSummary.
        :rtype: datetime
        """
        return self._operation_time

    @operation_time.setter
    def operation_time(self, operation_time):
        """
        Sets the operation_time of this SqlFirewallViolationSummary.
        The time of the SQL violation occurrence in the target database.


        :param operation_time: The operation_time of this SqlFirewallViolationSummary.
        :type: datetime
        """
        self._operation_time = operation_time

    @property
    def time_collected(self):
        """
        **[Required]** Gets the time_collected of this SqlFirewallViolationSummary.
        The timestamp when this SQL violation was collected from the target database by Data Safe.


        :return: The time_collected of this SqlFirewallViolationSummary.
        :rtype: datetime
        """
        return self._time_collected

    @time_collected.setter
    def time_collected(self, time_collected):
        """
        Sets the time_collected of this SqlFirewallViolationSummary.
        The timestamp when this SQL violation was collected from the target database by Data Safe.


        :param time_collected: The time_collected of this SqlFirewallViolationSummary.
        :type: datetime
        """
        self._time_collected = time_collected

    @property
    def client_os_user_name(self):
        """
        Gets the client_os_user_name of this SqlFirewallViolationSummary.
        The name of the operating system user for the database session.


        :return: The client_os_user_name of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._client_os_user_name

    @client_os_user_name.setter
    def client_os_user_name(self, client_os_user_name):
        """
        Sets the client_os_user_name of this SqlFirewallViolationSummary.
        The name of the operating system user for the database session.


        :param client_os_user_name: The client_os_user_name of this SqlFirewallViolationSummary.
        :type: str
        """
        self._client_os_user_name = client_os_user_name

    @property
    def operation(self):
        """
        Gets the operation of this SqlFirewallViolationSummary.
        The name of the action executed by the user on the target database. For example, ALTER, CREATE, DROP.


        :return: The operation of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """
        Sets the operation of this SqlFirewallViolationSummary.
        The name of the action executed by the user on the target database. For example, ALTER, CREATE, DROP.


        :param operation: The operation of this SqlFirewallViolationSummary.
        :type: str
        """
        self._operation = operation

    @property
    def sql_text(self):
        """
        Gets the sql_text of this SqlFirewallViolationSummary.
        The SQL text caught by the firewall.


        :return: The sql_text of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._sql_text

    @sql_text.setter
    def sql_text(self, sql_text):
        """
        Sets the sql_text of this SqlFirewallViolationSummary.
        The SQL text caught by the firewall.


        :param sql_text: The sql_text of this SqlFirewallViolationSummary.
        :type: str
        """
        self._sql_text = sql_text

    @property
    def sql_accessed_objects(self):
        """
        Gets the sql_accessed_objects of this SqlFirewallViolationSummary.
        The objects accessed by the SQL.


        :return: The sql_accessed_objects of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._sql_accessed_objects

    @sql_accessed_objects.setter
    def sql_accessed_objects(self, sql_accessed_objects):
        """
        Sets the sql_accessed_objects of this SqlFirewallViolationSummary.
        The objects accessed by the SQL.


        :param sql_accessed_objects: The sql_accessed_objects of this SqlFirewallViolationSummary.
        :type: str
        """
        self._sql_accessed_objects = sql_accessed_objects

    @property
    def current_db_user_name(self):
        """
        Gets the current_db_user_name of this SqlFirewallViolationSummary.
        The name of the user that SQL was executed as.


        :return: The current_db_user_name of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._current_db_user_name

    @current_db_user_name.setter
    def current_db_user_name(self, current_db_user_name):
        """
        Sets the current_db_user_name of this SqlFirewallViolationSummary.
        The name of the user that SQL was executed as.


        :param current_db_user_name: The current_db_user_name of this SqlFirewallViolationSummary.
        :type: str
        """
        self._current_db_user_name = current_db_user_name

    @property
    def sql_level(self):
        """
        Gets the sql_level of this SqlFirewallViolationSummary.
        Specifies the level of SQL for this violation.
        USER_ISSUED_SQL - User issued SQL statements only.
        ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.

        Allowed values for this property are: "USER_ISSUED_SQL", "ALL_SQL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The sql_level of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._sql_level

    @sql_level.setter
    def sql_level(self, sql_level):
        """
        Sets the sql_level of this SqlFirewallViolationSummary.
        Specifies the level of SQL for this violation.
        USER_ISSUED_SQL - User issued SQL statements only.
        ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.


        :param sql_level: The sql_level of this SqlFirewallViolationSummary.
        :type: str
        """
        allowed_values = ["USER_ISSUED_SQL", "ALL_SQL"]
        if not value_allowed_none_or_none_sentinel(sql_level, allowed_values):
            sql_level = 'UNKNOWN_ENUM_VALUE'
        self._sql_level = sql_level

    @property
    def client_ip(self):
        """
        Gets the client_ip of this SqlFirewallViolationSummary.
        The IP address of the host machine from which the session was generated.


        :return: The client_ip of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._client_ip

    @client_ip.setter
    def client_ip(self, client_ip):
        """
        Sets the client_ip of this SqlFirewallViolationSummary.
        The IP address of the host machine from which the session was generated.


        :param client_ip: The client_ip of this SqlFirewallViolationSummary.
        :type: str
        """
        self._client_ip = client_ip

    @property
    def client_program(self):
        """
        Gets the client_program of this SqlFirewallViolationSummary.
        The application from which the SQL violation was generated. Examples include SQL Plus or SQL Developer.


        :return: The client_program of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._client_program

    @client_program.setter
    def client_program(self, client_program):
        """
        Sets the client_program of this SqlFirewallViolationSummary.
        The application from which the SQL violation was generated. Examples include SQL Plus or SQL Developer.


        :param client_program: The client_program of this SqlFirewallViolationSummary.
        :type: str
        """
        self._client_program = client_program

    @property
    def violation_cause(self):
        """
        Gets the violation_cause of this SqlFirewallViolationSummary.
        Indicates whether SQL or context violation.


        :return: The violation_cause of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._violation_cause

    @violation_cause.setter
    def violation_cause(self, violation_cause):
        """
        Sets the violation_cause of this SqlFirewallViolationSummary.
        Indicates whether SQL or context violation.


        :param violation_cause: The violation_cause of this SqlFirewallViolationSummary.
        :type: str
        """
        self._violation_cause = violation_cause

    @property
    def violation_action(self):
        """
        **[Required]** Gets the violation_action of this SqlFirewallViolationSummary.
        The action taken for this SQL violation.

        Allowed values for this property are: "BLOCKED", "ALLOWED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The violation_action of this SqlFirewallViolationSummary.
        :rtype: str
        """
        return self._violation_action

    @violation_action.setter
    def violation_action(self, violation_action):
        """
        Sets the violation_action of this SqlFirewallViolationSummary.
        The action taken for this SQL violation.


        :param violation_action: The violation_action of this SqlFirewallViolationSummary.
        :type: str
        """
        allowed_values = ["BLOCKED", "ALLOWED"]
        if not value_allowed_none_or_none_sentinel(violation_action, allowed_values):
            violation_action = 'UNKNOWN_ENUM_VALUE'
        self._violation_action = violation_action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
