# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .instance_component import InstanceComponent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataScienceModelDeploymentInstanceComponent(InstanceComponent):
    """
    Reference to Data Science Model Deployment
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataScienceModelDeploymentInstanceComponent object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.DataScienceModelDeploymentInstanceComponent.type` attribute
        of this class is ``DATA_SCIENCE_MODEL_DEPLOYMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this DataScienceModelDeploymentInstanceComponent.
            Allowed values for this property are: "DATA_SCIENCE_MODEL_DEPLOYMENT", "OBJECT_STORAGE_BUCKET", "OBJECT_STORAGE_OBJECT", "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER", "DATA_SCIENCE_SCHEDULE", "GENERIC_OCI_RESOURCE"
        :type type: str

        :param name:
            The value to assign to the name property of this DataScienceModelDeploymentInstanceComponent.
        :type name: str

        :param component_name:
            The value to assign to the component_name property of this DataScienceModelDeploymentInstanceComponent.
        :type component_name: str

        :param prediction_use_case_name:
            The value to assign to the prediction_use_case_name property of this DataScienceModelDeploymentInstanceComponent.
        :type prediction_use_case_name: str

        :param model_deployment_id:
            The value to assign to the model_deployment_id property of this DataScienceModelDeploymentInstanceComponent.
        :type model_deployment_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'component_name': 'str',
            'prediction_use_case_name': 'str',
            'model_deployment_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'component_name': 'componentName',
            'prediction_use_case_name': 'predictionUseCaseName',
            'model_deployment_id': 'modelDeploymentId'
        }
        self._type = None
        self._name = None
        self._component_name = None
        self._prediction_use_case_name = None
        self._model_deployment_id = None
        self._type = 'DATA_SCIENCE_MODEL_DEPLOYMENT'

    @property
    def prediction_use_case_name(self):
        """
        **[Required]** Gets the prediction_use_case_name of this DataScienceModelDeploymentInstanceComponent.
        Name of online prediction use-case (defined in ML Application) for which this Model Deployment serves predictions


        :return: The prediction_use_case_name of this DataScienceModelDeploymentInstanceComponent.
        :rtype: str
        """
        return self._prediction_use_case_name

    @prediction_use_case_name.setter
    def prediction_use_case_name(self, prediction_use_case_name):
        """
        Sets the prediction_use_case_name of this DataScienceModelDeploymentInstanceComponent.
        Name of online prediction use-case (defined in ML Application) for which this Model Deployment serves predictions


        :param prediction_use_case_name: The prediction_use_case_name of this DataScienceModelDeploymentInstanceComponent.
        :type: str
        """
        self._prediction_use_case_name = prediction_use_case_name

    @property
    def model_deployment_id(self):
        """
        **[Required]** Gets the model_deployment_id of this DataScienceModelDeploymentInstanceComponent.
        OCID of Data Science Model Deployment


        :return: The model_deployment_id of this DataScienceModelDeploymentInstanceComponent.
        :rtype: str
        """
        return self._model_deployment_id

    @model_deployment_id.setter
    def model_deployment_id(self, model_deployment_id):
        """
        Sets the model_deployment_id of this DataScienceModelDeploymentInstanceComponent.
        OCID of Data Science Model Deployment


        :param model_deployment_id: The model_deployment_id of this DataScienceModelDeploymentInstanceComponent.
        :type: str
        """
        self._model_deployment_id = model_deployment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
