# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImplementationLogging(object):
    """
    Configuration of Logging for ML Application Implementation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ImplementationLogging object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param implementation_log:
            The value to assign to the implementation_log property of this ImplementationLogging.
        :type implementation_log: oci.data_science.models.ImplementationLogDetails

        :param aggregated_instance_view_log:
            The value to assign to the aggregated_instance_view_log property of this ImplementationLogging.
        :type aggregated_instance_view_log: oci.data_science.models.ImplementationLogDetails

        :param trigger_log:
            The value to assign to the trigger_log property of this ImplementationLogging.
        :type trigger_log: oci.data_science.models.ImplementationLogDetails

        """
        self.swagger_types = {
            'implementation_log': 'ImplementationLogDetails',
            'aggregated_instance_view_log': 'ImplementationLogDetails',
            'trigger_log': 'ImplementationLogDetails'
        }
        self.attribute_map = {
            'implementation_log': 'implementationLog',
            'aggregated_instance_view_log': 'aggregatedInstanceViewLog',
            'trigger_log': 'triggerLog'
        }
        self._implementation_log = None
        self._aggregated_instance_view_log = None
        self._trigger_log = None

    @property
    def implementation_log(self):
        """
        Gets the implementation_log of this ImplementationLogging.

        :return: The implementation_log of this ImplementationLogging.
        :rtype: oci.data_science.models.ImplementationLogDetails
        """
        return self._implementation_log

    @implementation_log.setter
    def implementation_log(self, implementation_log):
        """
        Sets the implementation_log of this ImplementationLogging.

        :param implementation_log: The implementation_log of this ImplementationLogging.
        :type: oci.data_science.models.ImplementationLogDetails
        """
        self._implementation_log = implementation_log

    @property
    def aggregated_instance_view_log(self):
        """
        Gets the aggregated_instance_view_log of this ImplementationLogging.

        :return: The aggregated_instance_view_log of this ImplementationLogging.
        :rtype: oci.data_science.models.ImplementationLogDetails
        """
        return self._aggregated_instance_view_log

    @aggregated_instance_view_log.setter
    def aggregated_instance_view_log(self, aggregated_instance_view_log):
        """
        Sets the aggregated_instance_view_log of this ImplementationLogging.

        :param aggregated_instance_view_log: The aggregated_instance_view_log of this ImplementationLogging.
        :type: oci.data_science.models.ImplementationLogDetails
        """
        self._aggregated_instance_view_log = aggregated_instance_view_log

    @property
    def trigger_log(self):
        """
        Gets the trigger_log of this ImplementationLogging.

        :return: The trigger_log of this ImplementationLogging.
        :rtype: oci.data_science.models.ImplementationLogDetails
        """
        return self._trigger_log

    @trigger_log.setter
    def trigger_log(self, trigger_log):
        """
        Sets the trigger_log of this ImplementationLogging.

        :param trigger_log: The trigger_log of this ImplementationLogging.
        :type: oci.data_science.models.ImplementationLogDetails
        """
        self._trigger_log = trigger_log

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
