# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .job_probe_details import JobProbeDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobExecProbeDetails(JobProbeDetails):
    """
    Runs a command in the job run to check whether application is healthy or not.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JobExecProbeDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.JobExecProbeDetails.job_probe_check_type` attribute
        of this class is ``EXEC`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param job_probe_check_type:
            The value to assign to the job_probe_check_type property of this JobExecProbeDetails.
            Allowed values for this property are: "EXEC"
        :type job_probe_check_type: str

        :param command:
            The value to assign to the command property of this JobExecProbeDetails.
        :type command: list[str]

        :param period_in_seconds:
            The value to assign to the period_in_seconds property of this JobExecProbeDetails.
        :type period_in_seconds: int

        :param failure_threshold:
            The value to assign to the failure_threshold property of this JobExecProbeDetails.
        :type failure_threshold: int

        :param initial_delay_in_seconds:
            The value to assign to the initial_delay_in_seconds property of this JobExecProbeDetails.
        :type initial_delay_in_seconds: int

        """
        self.swagger_types = {
            'job_probe_check_type': 'str',
            'command': 'list[str]',
            'period_in_seconds': 'int',
            'failure_threshold': 'int',
            'initial_delay_in_seconds': 'int'
        }
        self.attribute_map = {
            'job_probe_check_type': 'jobProbeCheckType',
            'command': 'command',
            'period_in_seconds': 'periodInSeconds',
            'failure_threshold': 'failureThreshold',
            'initial_delay_in_seconds': 'initialDelayInSeconds'
        }
        self._job_probe_check_type = None
        self._command = None
        self._period_in_seconds = None
        self._failure_threshold = None
        self._initial_delay_in_seconds = None
        self._job_probe_check_type = 'EXEC'

    @property
    def command(self):
        """
        **[Required]** Gets the command of this JobExecProbeDetails.
        The commands to run in the target job run to perform the startup probe


        :return: The command of this JobExecProbeDetails.
        :rtype: list[str]
        """
        return self._command

    @command.setter
    def command(self, command):
        """
        Sets the command of this JobExecProbeDetails.
        The commands to run in the target job run to perform the startup probe


        :param command: The command of this JobExecProbeDetails.
        :type: list[str]
        """
        self._command = command

    @property
    def period_in_seconds(self):
        """
        Gets the period_in_seconds of this JobExecProbeDetails.
        Number of seconds how often the job run should perform a startup probe


        :return: The period_in_seconds of this JobExecProbeDetails.
        :rtype: int
        """
        return self._period_in_seconds

    @period_in_seconds.setter
    def period_in_seconds(self, period_in_seconds):
        """
        Sets the period_in_seconds of this JobExecProbeDetails.
        Number of seconds how often the job run should perform a startup probe


        :param period_in_seconds: The period_in_seconds of this JobExecProbeDetails.
        :type: int
        """
        self._period_in_seconds = period_in_seconds

    @property
    def failure_threshold(self):
        """
        Gets the failure_threshold of this JobExecProbeDetails.
        How many times the job will try before giving up when a probe fails.


        :return: The failure_threshold of this JobExecProbeDetails.
        :rtype: int
        """
        return self._failure_threshold

    @failure_threshold.setter
    def failure_threshold(self, failure_threshold):
        """
        Sets the failure_threshold of this JobExecProbeDetails.
        How many times the job will try before giving up when a probe fails.


        :param failure_threshold: The failure_threshold of this JobExecProbeDetails.
        :type: int
        """
        self._failure_threshold = failure_threshold

    @property
    def initial_delay_in_seconds(self):
        """
        Gets the initial_delay_in_seconds of this JobExecProbeDetails.
        Number of seconds after the job run has started before a startup probe is initiated.


        :return: The initial_delay_in_seconds of this JobExecProbeDetails.
        :rtype: int
        """
        return self._initial_delay_in_seconds

    @initial_delay_in_seconds.setter
    def initial_delay_in_seconds(self, initial_delay_in_seconds):
        """
        Sets the initial_delay_in_seconds of this JobExecProbeDetails.
        Number of seconds after the job run has started before a startup probe is initiated.


        :param initial_delay_in_seconds: The initial_delay_in_seconds of this JobExecProbeDetails.
        :type: int
        """
        self._initial_delay_in_seconds = initial_delay_in_seconds

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
