# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MemberModelEntries(object):
    """
    List of member models (inferenceKey & modelId) to be associated with the model group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MemberModelEntries object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_model_details:
            The value to assign to the member_model_details property of this MemberModelEntries.
        :type member_model_details: list[oci.data_science.models.MemberModelDetails]

        """
        self.swagger_types = {
            'member_model_details': 'list[MemberModelDetails]'
        }
        self.attribute_map = {
            'member_model_details': 'memberModelDetails'
        }
        self._member_model_details = None

    @property
    def member_model_details(self):
        """
        Gets the member_model_details of this MemberModelEntries.
        Each List item contains inference key and model ocid.


        :return: The member_model_details of this MemberModelEntries.
        :rtype: list[oci.data_science.models.MemberModelDetails]
        """
        return self._member_model_details

    @member_model_details.setter
    def member_model_details(self, member_model_details):
        """
        Sets the member_model_details of this MemberModelEntries.
        Each List item contains inference key and model ocid.


        :param member_model_details: The member_model_details of this MemberModelEntries.
        :type: list[oci.data_science.models.MemberModelDetails]
        """
        self._member_model_details = member_model_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
