# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAutonomousContainerDatabaseBase(object):
    """
    Describes the required parameters for the creation of an Autonomous Container Database.
    """

    #: A constant which can be used with the source property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "NONE"
    SOURCE_NONE = "NONE"

    #: A constant which can be used with the source property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "BACKUP_FROM_ID"
    SOURCE_BACKUP_FROM_ID = "BACKUP_FROM_ID"

    #: A constant which can be used with the service_level_agreement_type property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "STANDARD"
    SERVICE_LEVEL_AGREEMENT_TYPE_STANDARD = "STANDARD"

    #: A constant which can be used with the service_level_agreement_type property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "AUTONOMOUS_DATAGUARD"
    SERVICE_LEVEL_AGREEMENT_TYPE_AUTONOMOUS_DATAGUARD = "AUTONOMOUS_DATAGUARD"

    #: A constant which can be used with the protection_mode property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "MAXIMUM_AVAILABILITY"
    PROTECTION_MODE_MAXIMUM_AVAILABILITY = "MAXIMUM_AVAILABILITY"

    #: A constant which can be used with the protection_mode property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "MAXIMUM_PERFORMANCE"
    PROTECTION_MODE_MAXIMUM_PERFORMANCE = "MAXIMUM_PERFORMANCE"

    #: A constant which can be used with the patch_model property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "RELEASE_UPDATES"
    PATCH_MODEL_RELEASE_UPDATES = "RELEASE_UPDATES"

    #: A constant which can be used with the patch_model property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "RELEASE_UPDATE_REVISIONS"
    PATCH_MODEL_RELEASE_UPDATE_REVISIONS = "RELEASE_UPDATE_REVISIONS"

    #: A constant which can be used with the version_preference property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "NEXT_RELEASE_UPDATE"
    VERSION_PREFERENCE_NEXT_RELEASE_UPDATE = "NEXT_RELEASE_UPDATE"

    #: A constant which can be used with the version_preference property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "LATEST_RELEASE_UPDATE"
    VERSION_PREFERENCE_LATEST_RELEASE_UPDATE = "LATEST_RELEASE_UPDATE"

    #: A constant which can be used with the distribution_affinity property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "MINIMUM_DISTRIBUTION"
    DISTRIBUTION_AFFINITY_MINIMUM_DISTRIBUTION = "MINIMUM_DISTRIBUTION"

    #: A constant which can be used with the distribution_affinity property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "MAXIMUM_DISTRIBUTION"
    DISTRIBUTION_AFFINITY_MAXIMUM_DISTRIBUTION = "MAXIMUM_DISTRIBUTION"

    #: A constant which can be used with the net_services_architecture property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "DEDICATED"
    NET_SERVICES_ARCHITECTURE_DEDICATED = "DEDICATED"

    #: A constant which can be used with the net_services_architecture property of a CreateAutonomousContainerDatabaseBase.
    #: This constant has a value of "SHARED"
    NET_SERVICES_ARCHITECTURE_SHARED = "SHARED"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAutonomousContainerDatabaseBase object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database.models.CreateAutonomousContainerDatabaseDetails`
        * :class:`~oci.database.models.CreateAutonomousContainerDatabaseFromBackupDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param customer_contacts:
            The value to assign to the customer_contacts property of this CreateAutonomousContainerDatabaseBase.
        :type customer_contacts: list[oci.database.models.CustomerContact]

        :param okv_end_point_group_name:
            The value to assign to the okv_end_point_group_name property of this CreateAutonomousContainerDatabaseBase.
        :type okv_end_point_group_name: str

        :param source:
            The value to assign to the source property of this CreateAutonomousContainerDatabaseBase.
            Allowed values for this property are: "NONE", "BACKUP_FROM_ID"
        :type source: str

        :param display_name:
            The value to assign to the display_name property of this CreateAutonomousContainerDatabaseBase.
        :type display_name: str

        :param db_unique_name:
            The value to assign to the db_unique_name property of this CreateAutonomousContainerDatabaseBase.
        :type db_unique_name: str

        :param db_name:
            The value to assign to the db_name property of this CreateAutonomousContainerDatabaseBase.
        :type db_name: str

        :param service_level_agreement_type:
            The value to assign to the service_level_agreement_type property of this CreateAutonomousContainerDatabaseBase.
            Allowed values for this property are: "STANDARD", "AUTONOMOUS_DATAGUARD"
        :type service_level_agreement_type: str

        :param autonomous_exadata_infrastructure_id:
            The value to assign to the autonomous_exadata_infrastructure_id property of this CreateAutonomousContainerDatabaseBase.
        :type autonomous_exadata_infrastructure_id: str

        :param db_version:
            The value to assign to the db_version property of this CreateAutonomousContainerDatabaseBase.
        :type db_version: str

        :param database_software_image_id:
            The value to assign to the database_software_image_id property of this CreateAutonomousContainerDatabaseBase.
        :type database_software_image_id: str

        :param peer_autonomous_exadata_infrastructure_id:
            The value to assign to the peer_autonomous_exadata_infrastructure_id property of this CreateAutonomousContainerDatabaseBase.
        :type peer_autonomous_exadata_infrastructure_id: str

        :param peer_autonomous_container_database_display_name:
            The value to assign to the peer_autonomous_container_database_display_name property of this CreateAutonomousContainerDatabaseBase.
        :type peer_autonomous_container_database_display_name: str

        :param protection_mode:
            The value to assign to the protection_mode property of this CreateAutonomousContainerDatabaseBase.
            Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE"
        :type protection_mode: str

        :param fast_start_fail_over_lag_limit_in_seconds:
            The value to assign to the fast_start_fail_over_lag_limit_in_seconds property of this CreateAutonomousContainerDatabaseBase.
        :type fast_start_fail_over_lag_limit_in_seconds: int

        :param is_automatic_failover_enabled:
            The value to assign to the is_automatic_failover_enabled property of this CreateAutonomousContainerDatabaseBase.
        :type is_automatic_failover_enabled: bool

        :param peer_cloud_autonomous_vm_cluster_id:
            The value to assign to the peer_cloud_autonomous_vm_cluster_id property of this CreateAutonomousContainerDatabaseBase.
        :type peer_cloud_autonomous_vm_cluster_id: str

        :param peer_autonomous_vm_cluster_id:
            The value to assign to the peer_autonomous_vm_cluster_id property of this CreateAutonomousContainerDatabaseBase.
        :type peer_autonomous_vm_cluster_id: str

        :param peer_autonomous_container_database_compartment_id:
            The value to assign to the peer_autonomous_container_database_compartment_id property of this CreateAutonomousContainerDatabaseBase.
        :type peer_autonomous_container_database_compartment_id: str

        :param peer_autonomous_container_database_backup_config:
            The value to assign to the peer_autonomous_container_database_backup_config property of this CreateAutonomousContainerDatabaseBase.
        :type peer_autonomous_container_database_backup_config: oci.database.models.PeerAutonomousContainerDatabaseBackupConfig

        :param peer_db_unique_name:
            The value to assign to the peer_db_unique_name property of this CreateAutonomousContainerDatabaseBase.
        :type peer_db_unique_name: str

        :param autonomous_vm_cluster_id:
            The value to assign to the autonomous_vm_cluster_id property of this CreateAutonomousContainerDatabaseBase.
        :type autonomous_vm_cluster_id: str

        :param cloud_autonomous_vm_cluster_id:
            The value to assign to the cloud_autonomous_vm_cluster_id property of this CreateAutonomousContainerDatabaseBase.
        :type cloud_autonomous_vm_cluster_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateAutonomousContainerDatabaseBase.
        :type compartment_id: str

        :param patch_model:
            The value to assign to the patch_model property of this CreateAutonomousContainerDatabaseBase.
            Allowed values for this property are: "RELEASE_UPDATES", "RELEASE_UPDATE_REVISIONS"
        :type patch_model: str

        :param maintenance_window_details:
            The value to assign to the maintenance_window_details property of this CreateAutonomousContainerDatabaseBase.
        :type maintenance_window_details: oci.database.models.MaintenanceWindow

        :param standby_maintenance_buffer_in_days:
            The value to assign to the standby_maintenance_buffer_in_days property of this CreateAutonomousContainerDatabaseBase.
        :type standby_maintenance_buffer_in_days: int

        :param version_preference:
            The value to assign to the version_preference property of this CreateAutonomousContainerDatabaseBase.
            Allowed values for this property are: "NEXT_RELEASE_UPDATE", "LATEST_RELEASE_UPDATE"
        :type version_preference: str

        :param is_dst_file_update_enabled:
            The value to assign to the is_dst_file_update_enabled property of this CreateAutonomousContainerDatabaseBase.
        :type is_dst_file_update_enabled: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAutonomousContainerDatabaseBase.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAutonomousContainerDatabaseBase.
        :type defined_tags: dict(str, dict(str, object))

        :param backup_config:
            The value to assign to the backup_config property of this CreateAutonomousContainerDatabaseBase.
        :type backup_config: oci.database.models.AutonomousContainerDatabaseBackupConfig

        :param kms_key_id:
            The value to assign to the kms_key_id property of this CreateAutonomousContainerDatabaseBase.
        :type kms_key_id: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this CreateAutonomousContainerDatabaseBase.
        :type kms_key_version_id: str

        :param vault_id:
            The value to assign to the vault_id property of this CreateAutonomousContainerDatabaseBase.
        :type vault_id: str

        :param key_store_id:
            The value to assign to the key_store_id property of this CreateAutonomousContainerDatabaseBase.
        :type key_store_id: str

        :param db_split_threshold:
            The value to assign to the db_split_threshold property of this CreateAutonomousContainerDatabaseBase.
        :type db_split_threshold: int

        :param vm_failover_reservation:
            The value to assign to the vm_failover_reservation property of this CreateAutonomousContainerDatabaseBase.
        :type vm_failover_reservation: int

        :param distribution_affinity:
            The value to assign to the distribution_affinity property of this CreateAutonomousContainerDatabaseBase.
            Allowed values for this property are: "MINIMUM_DISTRIBUTION", "MAXIMUM_DISTRIBUTION"
        :type distribution_affinity: str

        :param net_services_architecture:
            The value to assign to the net_services_architecture property of this CreateAutonomousContainerDatabaseBase.
            Allowed values for this property are: "DEDICATED", "SHARED"
        :type net_services_architecture: str

        """
        self.swagger_types = {
            'customer_contacts': 'list[CustomerContact]',
            'okv_end_point_group_name': 'str',
            'source': 'str',
            'display_name': 'str',
            'db_unique_name': 'str',
            'db_name': 'str',
            'service_level_agreement_type': 'str',
            'autonomous_exadata_infrastructure_id': 'str',
            'db_version': 'str',
            'database_software_image_id': 'str',
            'peer_autonomous_exadata_infrastructure_id': 'str',
            'peer_autonomous_container_database_display_name': 'str',
            'protection_mode': 'str',
            'fast_start_fail_over_lag_limit_in_seconds': 'int',
            'is_automatic_failover_enabled': 'bool',
            'peer_cloud_autonomous_vm_cluster_id': 'str',
            'peer_autonomous_vm_cluster_id': 'str',
            'peer_autonomous_container_database_compartment_id': 'str',
            'peer_autonomous_container_database_backup_config': 'PeerAutonomousContainerDatabaseBackupConfig',
            'peer_db_unique_name': 'str',
            'autonomous_vm_cluster_id': 'str',
            'cloud_autonomous_vm_cluster_id': 'str',
            'compartment_id': 'str',
            'patch_model': 'str',
            'maintenance_window_details': 'MaintenanceWindow',
            'standby_maintenance_buffer_in_days': 'int',
            'version_preference': 'str',
            'is_dst_file_update_enabled': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'backup_config': 'AutonomousContainerDatabaseBackupConfig',
            'kms_key_id': 'str',
            'kms_key_version_id': 'str',
            'vault_id': 'str',
            'key_store_id': 'str',
            'db_split_threshold': 'int',
            'vm_failover_reservation': 'int',
            'distribution_affinity': 'str',
            'net_services_architecture': 'str'
        }
        self.attribute_map = {
            'customer_contacts': 'customerContacts',
            'okv_end_point_group_name': 'okvEndPointGroupName',
            'source': 'source',
            'display_name': 'displayName',
            'db_unique_name': 'dbUniqueName',
            'db_name': 'dbName',
            'service_level_agreement_type': 'serviceLevelAgreementType',
            'autonomous_exadata_infrastructure_id': 'autonomousExadataInfrastructureId',
            'db_version': 'dbVersion',
            'database_software_image_id': 'databaseSoftwareImageId',
            'peer_autonomous_exadata_infrastructure_id': 'peerAutonomousExadataInfrastructureId',
            'peer_autonomous_container_database_display_name': 'peerAutonomousContainerDatabaseDisplayName',
            'protection_mode': 'protectionMode',
            'fast_start_fail_over_lag_limit_in_seconds': 'fastStartFailOverLagLimitInSeconds',
            'is_automatic_failover_enabled': 'isAutomaticFailoverEnabled',
            'peer_cloud_autonomous_vm_cluster_id': 'peerCloudAutonomousVmClusterId',
            'peer_autonomous_vm_cluster_id': 'peerAutonomousVmClusterId',
            'peer_autonomous_container_database_compartment_id': 'peerAutonomousContainerDatabaseCompartmentId',
            'peer_autonomous_container_database_backup_config': 'peerAutonomousContainerDatabaseBackupConfig',
            'peer_db_unique_name': 'peerDbUniqueName',
            'autonomous_vm_cluster_id': 'autonomousVmClusterId',
            'cloud_autonomous_vm_cluster_id': 'cloudAutonomousVmClusterId',
            'compartment_id': 'compartmentId',
            'patch_model': 'patchModel',
            'maintenance_window_details': 'maintenanceWindowDetails',
            'standby_maintenance_buffer_in_days': 'standbyMaintenanceBufferInDays',
            'version_preference': 'versionPreference',
            'is_dst_file_update_enabled': 'isDstFileUpdateEnabled',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'backup_config': 'backupConfig',
            'kms_key_id': 'kmsKeyId',
            'kms_key_version_id': 'kmsKeyVersionId',
            'vault_id': 'vaultId',
            'key_store_id': 'keyStoreId',
            'db_split_threshold': 'dbSplitThreshold',
            'vm_failover_reservation': 'vmFailoverReservation',
            'distribution_affinity': 'distributionAffinity',
            'net_services_architecture': 'netServicesArchitecture'
        }
        self._customer_contacts = None
        self._okv_end_point_group_name = None
        self._source = None
        self._display_name = None
        self._db_unique_name = None
        self._db_name = None
        self._service_level_agreement_type = None
        self._autonomous_exadata_infrastructure_id = None
        self._db_version = None
        self._database_software_image_id = None
        self._peer_autonomous_exadata_infrastructure_id = None
        self._peer_autonomous_container_database_display_name = None
        self._protection_mode = None
        self._fast_start_fail_over_lag_limit_in_seconds = None
        self._is_automatic_failover_enabled = None
        self._peer_cloud_autonomous_vm_cluster_id = None
        self._peer_autonomous_vm_cluster_id = None
        self._peer_autonomous_container_database_compartment_id = None
        self._peer_autonomous_container_database_backup_config = None
        self._peer_db_unique_name = None
        self._autonomous_vm_cluster_id = None
        self._cloud_autonomous_vm_cluster_id = None
        self._compartment_id = None
        self._patch_model = None
        self._maintenance_window_details = None
        self._standby_maintenance_buffer_in_days = None
        self._version_preference = None
        self._is_dst_file_update_enabled = None
        self._freeform_tags = None
        self._defined_tags = None
        self._backup_config = None
        self._kms_key_id = None
        self._kms_key_version_id = None
        self._vault_id = None
        self._key_store_id = None
        self._db_split_threshold = None
        self._vm_failover_reservation = None
        self._distribution_affinity = None
        self._net_services_architecture = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['source']

        if type == 'NONE':
            return 'CreateAutonomousContainerDatabaseDetails'

        if type == 'BACKUP_FROM_ID':
            return 'CreateAutonomousContainerDatabaseFromBackupDetails'
        else:
            return 'CreateAutonomousContainerDatabaseBase'

    @property
    def customer_contacts(self):
        """
        Gets the customer_contacts of this CreateAutonomousContainerDatabaseBase.
        Customer Contacts. Setting this to an empty list removes all customer contacts.


        :return: The customer_contacts of this CreateAutonomousContainerDatabaseBase.
        :rtype: list[oci.database.models.CustomerContact]
        """
        return self._customer_contacts

    @customer_contacts.setter
    def customer_contacts(self, customer_contacts):
        """
        Sets the customer_contacts of this CreateAutonomousContainerDatabaseBase.
        Customer Contacts. Setting this to an empty list removes all customer contacts.


        :param customer_contacts: The customer_contacts of this CreateAutonomousContainerDatabaseBase.
        :type: list[oci.database.models.CustomerContact]
        """
        self._customer_contacts = customer_contacts

    @property
    def okv_end_point_group_name(self):
        """
        Gets the okv_end_point_group_name of this CreateAutonomousContainerDatabaseBase.
        The OKV End Point Group name for the Autonomous Container Database.


        :return: The okv_end_point_group_name of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._okv_end_point_group_name

    @okv_end_point_group_name.setter
    def okv_end_point_group_name(self, okv_end_point_group_name):
        """
        Sets the okv_end_point_group_name of this CreateAutonomousContainerDatabaseBase.
        The OKV End Point Group name for the Autonomous Container Database.


        :param okv_end_point_group_name: The okv_end_point_group_name of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._okv_end_point_group_name = okv_end_point_group_name

    @property
    def source(self):
        """
        Gets the source of this CreateAutonomousContainerDatabaseBase.
        The source of the database. Use `NONE` to create a new Autonomous Container Database (ACD). Use `BACKUP_FROM_ID` to create a new ACD from a specified backup.

        Allowed values for this property are: "NONE", "BACKUP_FROM_ID"


        :return: The source of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this CreateAutonomousContainerDatabaseBase.
        The source of the database. Use `NONE` to create a new Autonomous Container Database (ACD). Use `BACKUP_FROM_ID` to create a new ACD from a specified backup.


        :param source: The source of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        allowed_values = ["NONE", "BACKUP_FROM_ID"]
        if not value_allowed_none_or_none_sentinel(source, allowed_values):
            raise ValueError(
                f"Invalid value for `source`, must be None or one of {allowed_values}"
            )
        self._source = source

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateAutonomousContainerDatabaseBase.
        The display name for the Autonomous Container Database.


        :return: The display_name of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateAutonomousContainerDatabaseBase.
        The display name for the Autonomous Container Database.


        :param display_name: The display_name of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._display_name = display_name

    @property
    def db_unique_name(self):
        """
        Gets the db_unique_name of this CreateAutonomousContainerDatabaseBase.
        **Deprecated.** The `DB_UNIQUE_NAME` value is set by Oracle Cloud Infrastructure.  Do not specify a value for this parameter. Specifying a value for this field will cause Terraform operations to fail.


        :return: The db_unique_name of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._db_unique_name

    @db_unique_name.setter
    def db_unique_name(self, db_unique_name):
        """
        Sets the db_unique_name of this CreateAutonomousContainerDatabaseBase.
        **Deprecated.** The `DB_UNIQUE_NAME` value is set by Oracle Cloud Infrastructure.  Do not specify a value for this parameter. Specifying a value for this field will cause Terraform operations to fail.


        :param db_unique_name: The db_unique_name of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._db_unique_name = db_unique_name

    @property
    def db_name(self):
        """
        Gets the db_name of this CreateAutonomousContainerDatabaseBase.
        The Database name for the Autonomous Container Database. The name must be unique within the Cloud Autonomous VM Cluster, starting with an alphabetic character, followed by 1 to 7 alphanumeric characters.


        :return: The db_name of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._db_name

    @db_name.setter
    def db_name(self, db_name):
        """
        Sets the db_name of this CreateAutonomousContainerDatabaseBase.
        The Database name for the Autonomous Container Database. The name must be unique within the Cloud Autonomous VM Cluster, starting with an alphabetic character, followed by 1 to 7 alphanumeric characters.


        :param db_name: The db_name of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._db_name = db_name

    @property
    def service_level_agreement_type(self):
        """
        Gets the service_level_agreement_type of this CreateAutonomousContainerDatabaseBase.
        The service level agreement type of the Autonomous Container Database. The default is STANDARD. For an autonomous dataguard Autonomous Container Database, the specified Autonomous Exadata Infrastructure must be associated with a remote Autonomous Exadata Infrastructure.

        Allowed values for this property are: "STANDARD", "AUTONOMOUS_DATAGUARD"


        :return: The service_level_agreement_type of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._service_level_agreement_type

    @service_level_agreement_type.setter
    def service_level_agreement_type(self, service_level_agreement_type):
        """
        Sets the service_level_agreement_type of this CreateAutonomousContainerDatabaseBase.
        The service level agreement type of the Autonomous Container Database. The default is STANDARD. For an autonomous dataguard Autonomous Container Database, the specified Autonomous Exadata Infrastructure must be associated with a remote Autonomous Exadata Infrastructure.


        :param service_level_agreement_type: The service_level_agreement_type of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        allowed_values = ["STANDARD", "AUTONOMOUS_DATAGUARD"]
        if not value_allowed_none_or_none_sentinel(service_level_agreement_type, allowed_values):
            raise ValueError(
                f"Invalid value for `service_level_agreement_type`, must be None or one of {allowed_values}"
            )
        self._service_level_agreement_type = service_level_agreement_type

    @property
    def autonomous_exadata_infrastructure_id(self):
        """
        Gets the autonomous_exadata_infrastructure_id of this CreateAutonomousContainerDatabaseBase.
        **No longer used.** This parameter is no longer used for Autonomous Database on dedicated Exadata infrasture. Specify a `cloudAutonomousVmClusterId` instead. Using this parameter will cause the operation to fail.


        :return: The autonomous_exadata_infrastructure_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._autonomous_exadata_infrastructure_id

    @autonomous_exadata_infrastructure_id.setter
    def autonomous_exadata_infrastructure_id(self, autonomous_exadata_infrastructure_id):
        """
        Sets the autonomous_exadata_infrastructure_id of this CreateAutonomousContainerDatabaseBase.
        **No longer used.** This parameter is no longer used for Autonomous Database on dedicated Exadata infrasture. Specify a `cloudAutonomousVmClusterId` instead. Using this parameter will cause the operation to fail.


        :param autonomous_exadata_infrastructure_id: The autonomous_exadata_infrastructure_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._autonomous_exadata_infrastructure_id = autonomous_exadata_infrastructure_id

    @property
    def db_version(self):
        """
        Gets the db_version of this CreateAutonomousContainerDatabaseBase.
        The base version for the Autonomous Container Database.


        :return: The db_version of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._db_version

    @db_version.setter
    def db_version(self, db_version):
        """
        Sets the db_version of this CreateAutonomousContainerDatabaseBase.
        The base version for the Autonomous Container Database.


        :param db_version: The db_version of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._db_version = db_version

    @property
    def database_software_image_id(self):
        """
        Gets the database_software_image_id of this CreateAutonomousContainerDatabaseBase.
        The Autonomous Database Software Image `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The database_software_image_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._database_software_image_id

    @database_software_image_id.setter
    def database_software_image_id(self, database_software_image_id):
        """
        Sets the database_software_image_id of this CreateAutonomousContainerDatabaseBase.
        The Autonomous Database Software Image `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param database_software_image_id: The database_software_image_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._database_software_image_id = database_software_image_id

    @property
    def peer_autonomous_exadata_infrastructure_id(self):
        """
        Gets the peer_autonomous_exadata_infrastructure_id of this CreateAutonomousContainerDatabaseBase.
        *No longer used.* This parameter is no longer used for Autonomous Database on dedicated Exadata infrasture. Specify a `peerCloudAutonomousVmClusterId` instead. Using this parameter will cause the operation to fail.


        :return: The peer_autonomous_exadata_infrastructure_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._peer_autonomous_exadata_infrastructure_id

    @peer_autonomous_exadata_infrastructure_id.setter
    def peer_autonomous_exadata_infrastructure_id(self, peer_autonomous_exadata_infrastructure_id):
        """
        Sets the peer_autonomous_exadata_infrastructure_id of this CreateAutonomousContainerDatabaseBase.
        *No longer used.* This parameter is no longer used for Autonomous Database on dedicated Exadata infrasture. Specify a `peerCloudAutonomousVmClusterId` instead. Using this parameter will cause the operation to fail.


        :param peer_autonomous_exadata_infrastructure_id: The peer_autonomous_exadata_infrastructure_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._peer_autonomous_exadata_infrastructure_id = peer_autonomous_exadata_infrastructure_id

    @property
    def peer_autonomous_container_database_display_name(self):
        """
        Gets the peer_autonomous_container_database_display_name of this CreateAutonomousContainerDatabaseBase.
        The display name for the peer Autonomous Container Database.


        :return: The peer_autonomous_container_database_display_name of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._peer_autonomous_container_database_display_name

    @peer_autonomous_container_database_display_name.setter
    def peer_autonomous_container_database_display_name(self, peer_autonomous_container_database_display_name):
        """
        Sets the peer_autonomous_container_database_display_name of this CreateAutonomousContainerDatabaseBase.
        The display name for the peer Autonomous Container Database.


        :param peer_autonomous_container_database_display_name: The peer_autonomous_container_database_display_name of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._peer_autonomous_container_database_display_name = peer_autonomous_container_database_display_name

    @property
    def protection_mode(self):
        """
        Gets the protection_mode of this CreateAutonomousContainerDatabaseBase.
        The protection mode of this Autonomous Data Guard association. For more information, see
        `Oracle Data Guard Protection Modes`__
        in the Oracle Data Guard documentation.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000

        Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE"


        :return: The protection_mode of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._protection_mode

    @protection_mode.setter
    def protection_mode(self, protection_mode):
        """
        Sets the protection_mode of this CreateAutonomousContainerDatabaseBase.
        The protection mode of this Autonomous Data Guard association. For more information, see
        `Oracle Data Guard Protection Modes`__
        in the Oracle Data Guard documentation.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000


        :param protection_mode: The protection_mode of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        allowed_values = ["MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE"]
        if not value_allowed_none_or_none_sentinel(protection_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `protection_mode`, must be None or one of {allowed_values}"
            )
        self._protection_mode = protection_mode

    @property
    def fast_start_fail_over_lag_limit_in_seconds(self):
        """
        Gets the fast_start_fail_over_lag_limit_in_seconds of this CreateAutonomousContainerDatabaseBase.
        The lag time for my preference based on data loss tolerance in seconds.


        :return: The fast_start_fail_over_lag_limit_in_seconds of this CreateAutonomousContainerDatabaseBase.
        :rtype: int
        """
        return self._fast_start_fail_over_lag_limit_in_seconds

    @fast_start_fail_over_lag_limit_in_seconds.setter
    def fast_start_fail_over_lag_limit_in_seconds(self, fast_start_fail_over_lag_limit_in_seconds):
        """
        Sets the fast_start_fail_over_lag_limit_in_seconds of this CreateAutonomousContainerDatabaseBase.
        The lag time for my preference based on data loss tolerance in seconds.


        :param fast_start_fail_over_lag_limit_in_seconds: The fast_start_fail_over_lag_limit_in_seconds of this CreateAutonomousContainerDatabaseBase.
        :type: int
        """
        self._fast_start_fail_over_lag_limit_in_seconds = fast_start_fail_over_lag_limit_in_seconds

    @property
    def is_automatic_failover_enabled(self):
        """
        Gets the is_automatic_failover_enabled of this CreateAutonomousContainerDatabaseBase.
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association


        :return: The is_automatic_failover_enabled of this CreateAutonomousContainerDatabaseBase.
        :rtype: bool
        """
        return self._is_automatic_failover_enabled

    @is_automatic_failover_enabled.setter
    def is_automatic_failover_enabled(self, is_automatic_failover_enabled):
        """
        Sets the is_automatic_failover_enabled of this CreateAutonomousContainerDatabaseBase.
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association


        :param is_automatic_failover_enabled: The is_automatic_failover_enabled of this CreateAutonomousContainerDatabaseBase.
        :type: bool
        """
        self._is_automatic_failover_enabled = is_automatic_failover_enabled

    @property
    def peer_cloud_autonomous_vm_cluster_id(self):
        """
        Gets the peer_cloud_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the peer cloud Autonomous Exadata VM Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The peer_cloud_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._peer_cloud_autonomous_vm_cluster_id

    @peer_cloud_autonomous_vm_cluster_id.setter
    def peer_cloud_autonomous_vm_cluster_id(self, peer_cloud_autonomous_vm_cluster_id):
        """
        Sets the peer_cloud_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the peer cloud Autonomous Exadata VM Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param peer_cloud_autonomous_vm_cluster_id: The peer_cloud_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._peer_cloud_autonomous_vm_cluster_id = peer_cloud_autonomous_vm_cluster_id

    @property
    def peer_autonomous_vm_cluster_id(self):
        """
        Gets the peer_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the peer Autonomous VM cluster for Autonomous Data Guard. Required to enable Data Guard.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The peer_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._peer_autonomous_vm_cluster_id

    @peer_autonomous_vm_cluster_id.setter
    def peer_autonomous_vm_cluster_id(self, peer_autonomous_vm_cluster_id):
        """
        Sets the peer_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the peer Autonomous VM cluster for Autonomous Data Guard. Required to enable Data Guard.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param peer_autonomous_vm_cluster_id: The peer_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._peer_autonomous_vm_cluster_id = peer_autonomous_vm_cluster_id

    @property
    def peer_autonomous_container_database_compartment_id(self):
        """
        Gets the peer_autonomous_container_database_compartment_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the compartment where the standby Autonomous Container Database
        will be created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The peer_autonomous_container_database_compartment_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._peer_autonomous_container_database_compartment_id

    @peer_autonomous_container_database_compartment_id.setter
    def peer_autonomous_container_database_compartment_id(self, peer_autonomous_container_database_compartment_id):
        """
        Sets the peer_autonomous_container_database_compartment_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the compartment where the standby Autonomous Container Database
        will be created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param peer_autonomous_container_database_compartment_id: The peer_autonomous_container_database_compartment_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._peer_autonomous_container_database_compartment_id = peer_autonomous_container_database_compartment_id

    @property
    def peer_autonomous_container_database_backup_config(self):
        """
        Gets the peer_autonomous_container_database_backup_config of this CreateAutonomousContainerDatabaseBase.

        :return: The peer_autonomous_container_database_backup_config of this CreateAutonomousContainerDatabaseBase.
        :rtype: oci.database.models.PeerAutonomousContainerDatabaseBackupConfig
        """
        return self._peer_autonomous_container_database_backup_config

    @peer_autonomous_container_database_backup_config.setter
    def peer_autonomous_container_database_backup_config(self, peer_autonomous_container_database_backup_config):
        """
        Sets the peer_autonomous_container_database_backup_config of this CreateAutonomousContainerDatabaseBase.

        :param peer_autonomous_container_database_backup_config: The peer_autonomous_container_database_backup_config of this CreateAutonomousContainerDatabaseBase.
        :type: oci.database.models.PeerAutonomousContainerDatabaseBackupConfig
        """
        self._peer_autonomous_container_database_backup_config = peer_autonomous_container_database_backup_config

    @property
    def peer_db_unique_name(self):
        """
        Gets the peer_db_unique_name of this CreateAutonomousContainerDatabaseBase.
        **Deprecated.** The `DB_UNIQUE_NAME` of the peer Autonomous Container Database in a Data Guard association is set by Oracle Cloud Infrastructure.  Do not specify a value for this parameter. Specifying a value for this field will cause Terraform operations to fail.


        :return: The peer_db_unique_name of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._peer_db_unique_name

    @peer_db_unique_name.setter
    def peer_db_unique_name(self, peer_db_unique_name):
        """
        Sets the peer_db_unique_name of this CreateAutonomousContainerDatabaseBase.
        **Deprecated.** The `DB_UNIQUE_NAME` of the peer Autonomous Container Database in a Data Guard association is set by Oracle Cloud Infrastructure.  Do not specify a value for this parameter. Specifying a value for this field will cause Terraform operations to fail.


        :param peer_db_unique_name: The peer_db_unique_name of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._peer_db_unique_name = peer_db_unique_name

    @property
    def autonomous_vm_cluster_id(self):
        """
        Gets the autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        The OCID of the Autonomous VM Cluster.


        :return: The autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._autonomous_vm_cluster_id

    @autonomous_vm_cluster_id.setter
    def autonomous_vm_cluster_id(self, autonomous_vm_cluster_id):
        """
        Sets the autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        The OCID of the Autonomous VM Cluster.


        :param autonomous_vm_cluster_id: The autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._autonomous_vm_cluster_id = autonomous_vm_cluster_id

    @property
    def cloud_autonomous_vm_cluster_id(self):
        """
        Gets the cloud_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the cloud Autonomous Exadata VM Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cloud_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._cloud_autonomous_vm_cluster_id

    @cloud_autonomous_vm_cluster_id.setter
    def cloud_autonomous_vm_cluster_id(self, cloud_autonomous_vm_cluster_id):
        """
        Sets the cloud_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the cloud Autonomous Exadata VM Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cloud_autonomous_vm_cluster_id: The cloud_autonomous_vm_cluster_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._cloud_autonomous_vm_cluster_id = cloud_autonomous_vm_cluster_id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the compartment containing the Autonomous Container Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the compartment containing the Autonomous Container Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def patch_model(self):
        """
        **[Required]** Gets the patch_model of this CreateAutonomousContainerDatabaseBase.
        Database Patch model preference.

        Allowed values for this property are: "RELEASE_UPDATES", "RELEASE_UPDATE_REVISIONS"


        :return: The patch_model of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._patch_model

    @patch_model.setter
    def patch_model(self, patch_model):
        """
        Sets the patch_model of this CreateAutonomousContainerDatabaseBase.
        Database Patch model preference.


        :param patch_model: The patch_model of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        allowed_values = ["RELEASE_UPDATES", "RELEASE_UPDATE_REVISIONS"]
        if not value_allowed_none_or_none_sentinel(patch_model, allowed_values):
            raise ValueError(
                f"Invalid value for `patch_model`, must be None or one of {allowed_values}"
            )
        self._patch_model = patch_model

    @property
    def maintenance_window_details(self):
        """
        Gets the maintenance_window_details of this CreateAutonomousContainerDatabaseBase.

        :return: The maintenance_window_details of this CreateAutonomousContainerDatabaseBase.
        :rtype: oci.database.models.MaintenanceWindow
        """
        return self._maintenance_window_details

    @maintenance_window_details.setter
    def maintenance_window_details(self, maintenance_window_details):
        """
        Sets the maintenance_window_details of this CreateAutonomousContainerDatabaseBase.

        :param maintenance_window_details: The maintenance_window_details of this CreateAutonomousContainerDatabaseBase.
        :type: oci.database.models.MaintenanceWindow
        """
        self._maintenance_window_details = maintenance_window_details

    @property
    def standby_maintenance_buffer_in_days(self):
        """
        Gets the standby_maintenance_buffer_in_days of this CreateAutonomousContainerDatabaseBase.
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database.
        This value represents the number of days before scheduled maintenance of the primary database.


        :return: The standby_maintenance_buffer_in_days of this CreateAutonomousContainerDatabaseBase.
        :rtype: int
        """
        return self._standby_maintenance_buffer_in_days

    @standby_maintenance_buffer_in_days.setter
    def standby_maintenance_buffer_in_days(self, standby_maintenance_buffer_in_days):
        """
        Sets the standby_maintenance_buffer_in_days of this CreateAutonomousContainerDatabaseBase.
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database.
        This value represents the number of days before scheduled maintenance of the primary database.


        :param standby_maintenance_buffer_in_days: The standby_maintenance_buffer_in_days of this CreateAutonomousContainerDatabaseBase.
        :type: int
        """
        self._standby_maintenance_buffer_in_days = standby_maintenance_buffer_in_days

    @property
    def version_preference(self):
        """
        Gets the version_preference of this CreateAutonomousContainerDatabaseBase.
        The next maintenance version preference.

        Allowed values for this property are: "NEXT_RELEASE_UPDATE", "LATEST_RELEASE_UPDATE"


        :return: The version_preference of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._version_preference

    @version_preference.setter
    def version_preference(self, version_preference):
        """
        Sets the version_preference of this CreateAutonomousContainerDatabaseBase.
        The next maintenance version preference.


        :param version_preference: The version_preference of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        allowed_values = ["NEXT_RELEASE_UPDATE", "LATEST_RELEASE_UPDATE"]
        if not value_allowed_none_or_none_sentinel(version_preference, allowed_values):
            raise ValueError(
                f"Invalid value for `version_preference`, must be None or one of {allowed_values}"
            )
        self._version_preference = version_preference

    @property
    def is_dst_file_update_enabled(self):
        """
        Gets the is_dst_file_update_enabled of this CreateAutonomousContainerDatabaseBase.
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.


        :return: The is_dst_file_update_enabled of this CreateAutonomousContainerDatabaseBase.
        :rtype: bool
        """
        return self._is_dst_file_update_enabled

    @is_dst_file_update_enabled.setter
    def is_dst_file_update_enabled(self, is_dst_file_update_enabled):
        """
        Sets the is_dst_file_update_enabled of this CreateAutonomousContainerDatabaseBase.
        Indicates if an automatic DST Time Zone file update is enabled for the Autonomous Container Database. If enabled along with Release Update, patching will be done in a Non-Rolling manner.


        :param is_dst_file_update_enabled: The is_dst_file_update_enabled of this CreateAutonomousContainerDatabaseBase.
        :type: bool
        """
        self._is_dst_file_update_enabled = is_dst_file_update_enabled

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateAutonomousContainerDatabaseBase.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateAutonomousContainerDatabaseBase.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateAutonomousContainerDatabaseBase.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateAutonomousContainerDatabaseBase.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateAutonomousContainerDatabaseBase.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateAutonomousContainerDatabaseBase.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateAutonomousContainerDatabaseBase.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateAutonomousContainerDatabaseBase.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def backup_config(self):
        """
        Gets the backup_config of this CreateAutonomousContainerDatabaseBase.

        :return: The backup_config of this CreateAutonomousContainerDatabaseBase.
        :rtype: oci.database.models.AutonomousContainerDatabaseBackupConfig
        """
        return self._backup_config

    @backup_config.setter
    def backup_config(self, backup_config):
        """
        Sets the backup_config of this CreateAutonomousContainerDatabaseBase.

        :param backup_config: The backup_config of this CreateAutonomousContainerDatabaseBase.
        :type: oci.database.models.AutonomousContainerDatabaseBackupConfig
        """
        self._backup_config = backup_config

    @property
    def kms_key_id(self):
        """
        Gets the kms_key_id of this CreateAutonomousContainerDatabaseBase.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :return: The kms_key_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this CreateAutonomousContainerDatabaseBase.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :param kms_key_id: The kms_key_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def kms_key_version_id(self):
        """
        Gets the kms_key_version_id of this CreateAutonomousContainerDatabaseBase.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.


        :return: The kms_key_version_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._kms_key_version_id

    @kms_key_version_id.setter
    def kms_key_version_id(self, kms_key_version_id):
        """
        Sets the kms_key_version_id of this CreateAutonomousContainerDatabaseBase.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.


        :param kms_key_version_id: The kms_key_version_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._kms_key_version_id = kms_key_version_id

    @property
    def vault_id(self):
        """
        Gets the vault_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `secretId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :return: The vault_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `secretId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :param vault_id: The vault_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def key_store_id(self):
        """
        Gets the key_store_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the key store of Oracle Vault.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The key_store_id of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._key_store_id

    @key_store_id.setter
    def key_store_id(self, key_store_id):
        """
        Sets the key_store_id of this CreateAutonomousContainerDatabaseBase.
        The `OCID`__ of the key store of Oracle Vault.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param key_store_id: The key_store_id of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        self._key_store_id = key_store_id

    @property
    def db_split_threshold(self):
        """
        Gets the db_split_threshold of this CreateAutonomousContainerDatabaseBase.
        The CPU value beyond which an Autonomous Database will be opened across multiple nodes. The default value of this attribute is 16 for OCPUs and 64 for ECPUs.


        :return: The db_split_threshold of this CreateAutonomousContainerDatabaseBase.
        :rtype: int
        """
        return self._db_split_threshold

    @db_split_threshold.setter
    def db_split_threshold(self, db_split_threshold):
        """
        Sets the db_split_threshold of this CreateAutonomousContainerDatabaseBase.
        The CPU value beyond which an Autonomous Database will be opened across multiple nodes. The default value of this attribute is 16 for OCPUs and 64 for ECPUs.


        :param db_split_threshold: The db_split_threshold of this CreateAutonomousContainerDatabaseBase.
        :type: int
        """
        self._db_split_threshold = db_split_threshold

    @property
    def vm_failover_reservation(self):
        """
        Gets the vm_failover_reservation of this CreateAutonomousContainerDatabaseBase.
        The percentage of CPUs reserved across nodes to support node failover. Allowed values are 0%, 25%, and 50%, with 50% being the default option.


        :return: The vm_failover_reservation of this CreateAutonomousContainerDatabaseBase.
        :rtype: int
        """
        return self._vm_failover_reservation

    @vm_failover_reservation.setter
    def vm_failover_reservation(self, vm_failover_reservation):
        """
        Sets the vm_failover_reservation of this CreateAutonomousContainerDatabaseBase.
        The percentage of CPUs reserved across nodes to support node failover. Allowed values are 0%, 25%, and 50%, with 50% being the default option.


        :param vm_failover_reservation: The vm_failover_reservation of this CreateAutonomousContainerDatabaseBase.
        :type: int
        """
        self._vm_failover_reservation = vm_failover_reservation

    @property
    def distribution_affinity(self):
        """
        Gets the distribution_affinity of this CreateAutonomousContainerDatabaseBase.
        Determines whether an Autonomous Database must be opened across a minimum or maximum of nodes. By default, Minimum nodes is selected.

        Allowed values for this property are: "MINIMUM_DISTRIBUTION", "MAXIMUM_DISTRIBUTION"


        :return: The distribution_affinity of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._distribution_affinity

    @distribution_affinity.setter
    def distribution_affinity(self, distribution_affinity):
        """
        Sets the distribution_affinity of this CreateAutonomousContainerDatabaseBase.
        Determines whether an Autonomous Database must be opened across a minimum or maximum of nodes. By default, Minimum nodes is selected.


        :param distribution_affinity: The distribution_affinity of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        allowed_values = ["MINIMUM_DISTRIBUTION", "MAXIMUM_DISTRIBUTION"]
        if not value_allowed_none_or_none_sentinel(distribution_affinity, allowed_values):
            raise ValueError(
                f"Invalid value for `distribution_affinity`, must be None or one of {allowed_values}"
            )
        self._distribution_affinity = distribution_affinity

    @property
    def net_services_architecture(self):
        """
        Gets the net_services_architecture of this CreateAutonomousContainerDatabaseBase.
        Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.

        Allowed values for this property are: "DEDICATED", "SHARED"


        :return: The net_services_architecture of this CreateAutonomousContainerDatabaseBase.
        :rtype: str
        """
        return self._net_services_architecture

    @net_services_architecture.setter
    def net_services_architecture(self, net_services_architecture):
        """
        Sets the net_services_architecture of this CreateAutonomousContainerDatabaseBase.
        Enabling SHARED server architecture enables a database server to allow many client processes to share very few server processes, thereby increasing the number of supported users.


        :param net_services_architecture: The net_services_architecture of this CreateAutonomousContainerDatabaseBase.
        :type: str
        """
        allowed_values = ["DEDICATED", "SHARED"]
        if not value_allowed_none_or_none_sentinel(net_services_architecture, allowed_values):
            raise ValueError(
                f"Invalid value for `net_services_architecture`, must be None or one of {allowed_values}"
            )
        self._net_services_architecture = net_services_architecture

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
