# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from .database_credential_details import DatabaseCredentialDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabasePasswordCredentialDetails(DatabaseCredentialDetails):
    """
    User provides a password to be used to connect to the database.
    """

    #: A constant which can be used with the role property of a DatabasePasswordCredentialDetails.
    #: This constant has a value of "NORMAL"
    ROLE_NORMAL = "NORMAL"

    #: A constant which can be used with the role property of a DatabasePasswordCredentialDetails.
    #: This constant has a value of "SYSDBA"
    ROLE_SYSDBA = "SYSDBA"

    #: A constant which can be used with the role property of a DatabasePasswordCredentialDetails.
    #: This constant has a value of "SYSDG"
    ROLE_SYSDG = "SYSDG"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabasePasswordCredentialDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_management.models.DatabasePasswordCredentialDetails.credential_type` attribute
        of this class is ``PASSWORD`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_type:
            The value to assign to the credential_type property of this DatabasePasswordCredentialDetails.
            Allowed values for this property are: "SECRET", "PASSWORD", "NAMED_CREDENTIAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type credential_type: str

        :param password:
            The value to assign to the password property of this DatabasePasswordCredentialDetails.
        :type password: str

        :param username:
            The value to assign to the username property of this DatabasePasswordCredentialDetails.
        :type username: str

        :param role:
            The value to assign to the role property of this DatabasePasswordCredentialDetails.
            Allowed values for this property are: "NORMAL", "SYSDBA", "SYSDG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type role: str

        """
        self.swagger_types = {
            'credential_type': 'str',
            'password': 'str',
            'username': 'str',
            'role': 'str'
        }
        self.attribute_map = {
            'credential_type': 'credentialType',
            'password': 'password',
            'username': 'username',
            'role': 'role'
        }
        self._credential_type = None
        self._password = None
        self._username = None
        self._role = None
        self._credential_type = 'PASSWORD'

    @property
    def password(self):
        """
        **[Required]** Gets the password of this DatabasePasswordCredentialDetails.
        The database user's password encoded using BASE64 scheme.


        :return: The password of this DatabasePasswordCredentialDetails.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this DatabasePasswordCredentialDetails.
        The database user's password encoded using BASE64 scheme.


        :param password: The password of this DatabasePasswordCredentialDetails.
        :type: str
        """
        self._password = password

    @property
    def username(self):
        """
        Gets the username of this DatabasePasswordCredentialDetails.
        The user to connect to the database.


        :return: The username of this DatabasePasswordCredentialDetails.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this DatabasePasswordCredentialDetails.
        The user to connect to the database.


        :param username: The username of this DatabasePasswordCredentialDetails.
        :type: str
        """
        self._username = username

    @property
    def role(self):
        """
        Gets the role of this DatabasePasswordCredentialDetails.
        The role of the database user.

        Allowed values for this property are: "NORMAL", "SYSDBA", "SYSDG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The role of this DatabasePasswordCredentialDetails.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this DatabasePasswordCredentialDetails.
        The role of the database user.


        :param role: The role of this DatabasePasswordCredentialDetails.
        :type: str
        """
        allowed_values = ["NORMAL", "SYSDBA", "SYSDG"]
        if not value_allowed_none_or_none_sentinel(role, allowed_values):
            role = 'UNKNOWN_ENUM_VALUE'
        self._role = role

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
