# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityScanSummary(object):
    """
    Summary information about a VulnerabilityScan.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityScanSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this VulnerabilityScanSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this VulnerabilityScanSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this VulnerabilityScanSummary.
        :type compartment_id: str

        :param vulnerability_scan_type:
            The value to assign to the vulnerability_scan_type property of this VulnerabilityScanSummary.
        :type vulnerability_scan_type: str

        :param vulnerability_scan_status:
            The value to assign to the vulnerability_scan_status property of this VulnerabilityScanSummary.
        :type vulnerability_scan_status: str

        :param vulnerability_scan_message:
            The value to assign to the vulnerability_scan_message property of this VulnerabilityScanSummary.
        :type vulnerability_scan_message: str

        :param time_created:
            The value to assign to the time_created property of this VulnerabilityScanSummary.
        :type time_created: datetime

        :param time_ended:
            The value to assign to the time_ended property of this VulnerabilityScanSummary.
        :type time_ended: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this VulnerabilityScanSummary.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this VulnerabilityScanSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this VulnerabilityScanSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this VulnerabilityScanSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'vulnerability_scan_type': 'str',
            'vulnerability_scan_status': 'str',
            'vulnerability_scan_message': 'str',
            'time_created': 'datetime',
            'time_ended': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'vulnerability_scan_type': 'vulnerabilityScanType',
            'vulnerability_scan_status': 'vulnerabilityScanStatus',
            'vulnerability_scan_message': 'vulnerabilityScanMessage',
            'time_created': 'timeCreated',
            'time_ended': 'timeEnded',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._vulnerability_scan_type = None
        self._vulnerability_scan_status = None
        self._vulnerability_scan_message = None
        self._time_created = None
        self._time_ended = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this VulnerabilityScanSummary.
        The `OCID`__ of the VulnerabilityScan.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this VulnerabilityScanSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VulnerabilityScanSummary.
        The `OCID`__ of the VulnerabilityScan.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this VulnerabilityScanSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this VulnerabilityScanSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this VulnerabilityScanSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this VulnerabilityScanSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this VulnerabilityScanSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this VulnerabilityScanSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this VulnerabilityScanSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this VulnerabilityScanSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this VulnerabilityScanSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vulnerability_scan_type(self):
        """
        **[Required]** Gets the vulnerability_scan_type of this VulnerabilityScanSummary.
        Vulnerability Scan Type.


        :return: The vulnerability_scan_type of this VulnerabilityScanSummary.
        :rtype: str
        """
        return self._vulnerability_scan_type

    @vulnerability_scan_type.setter
    def vulnerability_scan_type(self, vulnerability_scan_type):
        """
        Sets the vulnerability_scan_type of this VulnerabilityScanSummary.
        Vulnerability Scan Type.


        :param vulnerability_scan_type: The vulnerability_scan_type of this VulnerabilityScanSummary.
        :type: str
        """
        self._vulnerability_scan_type = vulnerability_scan_type

    @property
    def vulnerability_scan_status(self):
        """
        **[Required]** Gets the vulnerability_scan_status of this VulnerabilityScanSummary.
        The status of the scan.


        :return: The vulnerability_scan_status of this VulnerabilityScanSummary.
        :rtype: str
        """
        return self._vulnerability_scan_status

    @vulnerability_scan_status.setter
    def vulnerability_scan_status(self, vulnerability_scan_status):
        """
        Sets the vulnerability_scan_status of this VulnerabilityScanSummary.
        The status of the scan.


        :param vulnerability_scan_status: The vulnerability_scan_status of this VulnerabilityScanSummary.
        :type: str
        """
        self._vulnerability_scan_status = vulnerability_scan_status

    @property
    def vulnerability_scan_message(self):
        """
        **[Required]** Gets the vulnerability_scan_message of this VulnerabilityScanSummary.
        The message of the scan status.


        :return: The vulnerability_scan_message of this VulnerabilityScanSummary.
        :rtype: str
        """
        return self._vulnerability_scan_message

    @vulnerability_scan_message.setter
    def vulnerability_scan_message(self, vulnerability_scan_message):
        """
        Sets the vulnerability_scan_message of this VulnerabilityScanSummary.
        The message of the scan status.


        :param vulnerability_scan_message: The vulnerability_scan_message of this VulnerabilityScanSummary.
        :type: str
        """
        self._vulnerability_scan_message = vulnerability_scan_message

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this VulnerabilityScanSummary.
        The date and time the VulnerabilityScan was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this VulnerabilityScanSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this VulnerabilityScanSummary.
        The date and time the VulnerabilityScan was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this VulnerabilityScanSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_ended(self):
        """
        **[Required]** Gets the time_ended of this VulnerabilityScanSummary.
        The date and time the VulnerabilityScan was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_ended of this VulnerabilityScanSummary.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this VulnerabilityScanSummary.
        The date and time the VulnerabilityScan was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_ended: The time_ended of this VulnerabilityScanSummary.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this VulnerabilityScanSummary.
        The current state of the PatchOperation.


        :return: The lifecycle_state of this VulnerabilityScanSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this VulnerabilityScanSummary.
        The current state of the PatchOperation.


        :param lifecycle_state: The lifecycle_state of this VulnerabilityScanSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this VulnerabilityScanSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this VulnerabilityScanSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this VulnerabilityScanSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this VulnerabilityScanSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this VulnerabilityScanSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this VulnerabilityScanSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this VulnerabilityScanSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this VulnerabilityScanSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this VulnerabilityScanSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this VulnerabilityScanSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this VulnerabilityScanSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this VulnerabilityScanSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
