# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501

import oci  # noqa: F401
from oci.util import WAIT_RESOURCE_NOT_FOUND  # noqa: F401


class DbMulticloudGCPProviderClientCompositeOperations(object):
    """
    This class provides a wrapper around :py:class:`~oci.dbmulticloud.DbMulticloudGCPProviderClient` and offers convenience methods
    for operations that would otherwise need to be chained together. For example, instead of performing an action
    on a resource (e.g. launching an instance, creating a load balancer) and then using a waiter to wait for the resource
    to enter a given state, you can call a single method in this class to accomplish the same functionality
    """

    def __init__(self, client, **kwargs):
        """
        Creates a new DbMulticloudGCPProviderClientCompositeOperations object

        :param DbMulticloudGCPProviderClient client:
            The service client which will be wrapped by this object
        """
        self.client = client

    def change_oracle_db_gcp_identity_connector_compartment_and_wait_for_state(self, oracle_db_gcp_identity_connector_id, change_oracle_db_gcp_identity_connector_compartment_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.change_oracle_db_gcp_identity_connector_compartment` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param str oracle_db_gcp_identity_connector_id: (required)
            The `OCID`__ of the Oracle DB GCP Identity Configuration Resource.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param oci.dbmulticloud.models.ChangeOracleDbGcpIdentityConnectorCompartmentDetails change_oracle_db_gcp_identity_connector_compartment_details: (required)
            Moves the Oracle DB GCP Identity Connector resource into a different compartment.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.change_oracle_db_gcp_identity_connector_compartment`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.change_oracle_db_gcp_identity_connector_compartment(oracle_db_gcp_identity_connector_id, change_oracle_db_gcp_identity_connector_compartment_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def change_oracle_db_gcp_key_ring_compartment_and_wait_for_state(self, oracle_db_gcp_key_ring_id, change_oracle_db_gcp_key_ring_compartment_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.change_oracle_db_gcp_key_ring_compartment` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param str oracle_db_gcp_key_ring_id: (required)
            The `OCID`__ of the Oracle DB GCP Key-Ring resource.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param oci.dbmulticloud.models.ChangeOracleDbGcpKeyRingCompartmentDetails change_oracle_db_gcp_key_ring_compartment_details: (required)
            Moves the GCP Key Ring resource into a different compartment.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.change_oracle_db_gcp_key_ring_compartment`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.change_oracle_db_gcp_key_ring_compartment(oracle_db_gcp_key_ring_id, change_oracle_db_gcp_key_ring_compartment_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def create_oracle_db_gcp_identity_connector_and_wait_for_state(self, create_oracle_db_gcp_identity_connector_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.create_oracle_db_gcp_identity_connector` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param oci.dbmulticloud.models.CreateOracleDbGcpIdentityConnectorDetails create_oracle_db_gcp_identity_connector_details: (required)
            Details for to Create Oracle DB GCP  Identity Connector resource.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.create_oracle_db_gcp_identity_connector`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.create_oracle_db_gcp_identity_connector(create_oracle_db_gcp_identity_connector_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def create_oracle_db_gcp_key_ring_and_wait_for_state(self, create_oracle_db_gcp_key_ring_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.create_oracle_db_gcp_key_ring` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param oci.dbmulticloud.models.CreateOracleDbGcpKeyRingDetails create_oracle_db_gcp_key_ring_details: (required)
            Details for to Create GCP Key Ring Details.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.create_oracle_db_gcp_key_ring`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.create_oracle_db_gcp_key_ring(create_oracle_db_gcp_key_ring_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def delete_oracle_db_gcp_identity_connector_and_wait_for_state(self, oracle_db_gcp_identity_connector_id, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.delete_oracle_db_gcp_identity_connector` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param str oracle_db_gcp_identity_connector_id: (required)
            The `OCID`__ of the Oracle DB GCP Identity Configuration Resource.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.delete_oracle_db_gcp_identity_connector`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = None
        try:
            operation_result = self.client.delete_oracle_db_gcp_identity_connector(oracle_db_gcp_identity_connector_id, **operation_kwargs)
        except oci.exceptions.ServiceError as e:
            if e.status == 404:
                return WAIT_RESOURCE_NOT_FOUND
            else:
                raise e

        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def delete_oracle_db_gcp_key_ring_and_wait_for_state(self, oracle_db_gcp_key_ring_id, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.delete_oracle_db_gcp_key_ring` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param str oracle_db_gcp_key_ring_id: (required)
            The `OCID`__ of the Oracle DB GCP Key-Ring resource.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.delete_oracle_db_gcp_key_ring`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = None
        try:
            operation_result = self.client.delete_oracle_db_gcp_key_ring(oracle_db_gcp_key_ring_id, **operation_kwargs)
        except oci.exceptions.ServiceError as e:
            if e.status == 404:
                return WAIT_RESOURCE_NOT_FOUND
            else:
                raise e

        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def refresh_oracle_db_gcp_identity_connector_and_wait_for_state(self, oracle_db_gcp_identity_connector_id, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.refresh_oracle_db_gcp_identity_connector` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param str oracle_db_gcp_identity_connector_id: (required)
            The `OCID`__ of the Oracle DB GCP Identity Configuration Resource.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.refresh_oracle_db_gcp_identity_connector`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.refresh_oracle_db_gcp_identity_connector(oracle_db_gcp_identity_connector_id, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def refresh_oracle_db_gcp_key_ring_and_wait_for_state(self, oracle_db_gcp_key_ring_id, refresh_oracle_db_gcp_key_ring_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.refresh_oracle_db_gcp_key_ring` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param str oracle_db_gcp_key_ring_id: (required)
            The `OCID`__ of the Oracle DB GCP Key-Ring resource.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param oci.dbmulticloud.models.RefreshOracleDbGcpKeyRingDetails refresh_oracle_db_gcp_key_ring_details: (required)
            Details for to refresh Oracle DD GCP Key Ring.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.refresh_oracle_db_gcp_key_ring`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.refresh_oracle_db_gcp_key_ring(oracle_db_gcp_key_ring_id, refresh_oracle_db_gcp_key_ring_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def update_oracle_db_gcp_identity_connector_and_wait_for_state(self, oracle_db_gcp_identity_connector_id, update_oracle_db_gcp_identity_connector_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.update_oracle_db_gcp_identity_connector` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param str oracle_db_gcp_identity_connector_id: (required)
            The `OCID`__ of the Oracle DB GCP Identity Configuration Resource.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param oci.dbmulticloud.models.UpdateOracleDbGcpIdentityConnectorDetails update_oracle_db_gcp_identity_connector_details: (required)
            Details for to update OracleDbGcpIdentityConnector.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.update_oracle_db_gcp_identity_connector`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.update_oracle_db_gcp_identity_connector(oracle_db_gcp_identity_connector_id, update_oracle_db_gcp_identity_connector_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def update_oracle_db_gcp_key_ring_and_wait_for_state(self, oracle_db_gcp_key_ring_id, update_oracle_db_gcp_key_ring_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.update_oracle_db_gcp_key_ring` and waits for the :py:class:`~oci.dbmulticloud.models.WorkRequest`
        to enter the given state(s).

        :param str oracle_db_gcp_key_ring_id: (required)
            The `OCID`__ of the Oracle DB GCP Key-Ring resource.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param oci.dbmulticloud.models.UpdateOracleDbGcpKeyRingDetails update_oracle_db_gcp_key_ring_details: (required)
            Details for to update OracleDbGcpKeyRing.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.dbmulticloud.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.dbmulticloud.DbMulticloudGCPProviderClient.update_oracle_db_gcp_key_ring`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.update_oracle_db_gcp_key_ring(oracle_db_gcp_key_ring_id, update_oracle_db_gcp_key_ring_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)
