# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOracleDbAzureConnectorDetails(object):
    """
    Update Oracle DB Azure Connector resource object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOracleDbAzureConnectorDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this UpdateOracleDbAzureConnectorDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this UpdateOracleDbAzureConnectorDetails.
        :type display_name: str

        :param db_cluster_resource_id:
            The value to assign to the db_cluster_resource_id property of this UpdateOracleDbAzureConnectorDetails.
        :type db_cluster_resource_id: str

        :param azure_identity_mechanism:
            The value to assign to the azure_identity_mechanism property of this UpdateOracleDbAzureConnectorDetails.
        :type azure_identity_mechanism: str

        :param azure_tenant_id:
            The value to assign to the azure_tenant_id property of this UpdateOracleDbAzureConnectorDetails.
        :type azure_tenant_id: str

        :param azure_subscription_id:
            The value to assign to the azure_subscription_id property of this UpdateOracleDbAzureConnectorDetails.
        :type azure_subscription_id: str

        :param azure_resource_group:
            The value to assign to the azure_resource_group property of this UpdateOracleDbAzureConnectorDetails.
        :type azure_resource_group: str

        :param access_token:
            The value to assign to the access_token property of this UpdateOracleDbAzureConnectorDetails.
        :type access_token: str

        :param private_endpoint_ip_address:
            The value to assign to the private_endpoint_ip_address property of this UpdateOracleDbAzureConnectorDetails.
        :type private_endpoint_ip_address: str

        :param private_endpoint_dns_alias:
            The value to assign to the private_endpoint_dns_alias property of this UpdateOracleDbAzureConnectorDetails.
        :type private_endpoint_dns_alias: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateOracleDbAzureConnectorDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateOracleDbAzureConnectorDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'db_cluster_resource_id': 'str',
            'azure_identity_mechanism': 'str',
            'azure_tenant_id': 'str',
            'azure_subscription_id': 'str',
            'azure_resource_group': 'str',
            'access_token': 'str',
            'private_endpoint_ip_address': 'str',
            'private_endpoint_dns_alias': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'db_cluster_resource_id': 'dbClusterResourceId',
            'azure_identity_mechanism': 'azureIdentityMechanism',
            'azure_tenant_id': 'azureTenantId',
            'azure_subscription_id': 'azureSubscriptionId',
            'azure_resource_group': 'azureResourceGroup',
            'access_token': 'accessToken',
            'private_endpoint_ip_address': 'privateEndpointIpAddress',
            'private_endpoint_dns_alias': 'privateEndpointDnsAlias',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._db_cluster_resource_id = None
        self._azure_identity_mechanism = None
        self._azure_tenant_id = None
        self._azure_subscription_id = None
        self._azure_resource_group = None
        self._access_token = None
        self._private_endpoint_ip_address = None
        self._private_endpoint_dns_alias = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this UpdateOracleDbAzureConnectorDetails.
        The `OCID`__ of the compartment that contains Oracle DB Azure Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this UpdateOracleDbAzureConnectorDetails.
        The `OCID`__ of the compartment that contains Oracle DB Azure Connector resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateOracleDbAzureConnectorDetails.
        Oracle DB Azure Connector resource name.


        :return: The display_name of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateOracleDbAzureConnectorDetails.
        Oracle DB Azure Connector resource name.


        :param display_name: The display_name of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def db_cluster_resource_id(self):
        """
        Gets the db_cluster_resource_id of this UpdateOracleDbAzureConnectorDetails.
        The `OCID`__ of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The db_cluster_resource_id of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._db_cluster_resource_id

    @db_cluster_resource_id.setter
    def db_cluster_resource_id(self, db_cluster_resource_id):
        """
        Sets the db_cluster_resource_id of this UpdateOracleDbAzureConnectorDetails.
        The `OCID`__ of the Oracle DB Cloud VM Cluster resource where this Azure Arc Agent Identity to configure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param db_cluster_resource_id: The db_cluster_resource_id of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._db_cluster_resource_id = db_cluster_resource_id

    @property
    def azure_identity_mechanism(self):
        """
        Gets the azure_identity_mechanism of this UpdateOracleDbAzureConnectorDetails.
        Azure Identity mechanism.


        :return: The azure_identity_mechanism of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._azure_identity_mechanism

    @azure_identity_mechanism.setter
    def azure_identity_mechanism(self, azure_identity_mechanism):
        """
        Sets the azure_identity_mechanism of this UpdateOracleDbAzureConnectorDetails.
        Azure Identity mechanism.


        :param azure_identity_mechanism: The azure_identity_mechanism of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._azure_identity_mechanism = azure_identity_mechanism

    @property
    def azure_tenant_id(self):
        """
        Gets the azure_tenant_id of this UpdateOracleDbAzureConnectorDetails.
        Azure Tenant ID.


        :return: The azure_tenant_id of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._azure_tenant_id

    @azure_tenant_id.setter
    def azure_tenant_id(self, azure_tenant_id):
        """
        Sets the azure_tenant_id of this UpdateOracleDbAzureConnectorDetails.
        Azure Tenant ID.


        :param azure_tenant_id: The azure_tenant_id of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._azure_tenant_id = azure_tenant_id

    @property
    def azure_subscription_id(self):
        """
        Gets the azure_subscription_id of this UpdateOracleDbAzureConnectorDetails.
        Azure Subscription ID.


        :return: The azure_subscription_id of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._azure_subscription_id

    @azure_subscription_id.setter
    def azure_subscription_id(self, azure_subscription_id):
        """
        Sets the azure_subscription_id of this UpdateOracleDbAzureConnectorDetails.
        Azure Subscription ID.


        :param azure_subscription_id: The azure_subscription_id of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._azure_subscription_id = azure_subscription_id

    @property
    def azure_resource_group(self):
        """
        Gets the azure_resource_group of this UpdateOracleDbAzureConnectorDetails.
        Azure Resource group name.


        :return: The azure_resource_group of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._azure_resource_group

    @azure_resource_group.setter
    def azure_resource_group(self, azure_resource_group):
        """
        Sets the azure_resource_group of this UpdateOracleDbAzureConnectorDetails.
        Azure Resource group name.


        :param azure_resource_group: The azure_resource_group of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._azure_resource_group = azure_resource_group

    @property
    def access_token(self):
        """
        Gets the access_token of this UpdateOracleDbAzureConnectorDetails.
        Azure bearer access token.


        :return: The access_token of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._access_token

    @access_token.setter
    def access_token(self, access_token):
        """
        Sets the access_token of this UpdateOracleDbAzureConnectorDetails.
        Azure bearer access token.


        :param access_token: The access_token of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._access_token = access_token

    @property
    def private_endpoint_ip_address(self):
        """
        Gets the private_endpoint_ip_address of this UpdateOracleDbAzureConnectorDetails.
        Private endpoint IP.


        :return: The private_endpoint_ip_address of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._private_endpoint_ip_address

    @private_endpoint_ip_address.setter
    def private_endpoint_ip_address(self, private_endpoint_ip_address):
        """
        Sets the private_endpoint_ip_address of this UpdateOracleDbAzureConnectorDetails.
        Private endpoint IP.


        :param private_endpoint_ip_address: The private_endpoint_ip_address of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._private_endpoint_ip_address = private_endpoint_ip_address

    @property
    def private_endpoint_dns_alias(self):
        """
        Gets the private_endpoint_dns_alias of this UpdateOracleDbAzureConnectorDetails.
        Private endpoint's DNS alias.


        :return: The private_endpoint_dns_alias of this UpdateOracleDbAzureConnectorDetails.
        :rtype: str
        """
        return self._private_endpoint_dns_alias

    @private_endpoint_dns_alias.setter
    def private_endpoint_dns_alias(self, private_endpoint_dns_alias):
        """
        Sets the private_endpoint_dns_alias of this UpdateOracleDbAzureConnectorDetails.
        Private endpoint's DNS alias.


        :param private_endpoint_dns_alias: The private_endpoint_dns_alias of this UpdateOracleDbAzureConnectorDetails.
        :type: str
        """
        self._private_endpoint_dns_alias = private_endpoint_dns_alias

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateOracleDbAzureConnectorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateOracleDbAzureConnectorDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateOracleDbAzureConnectorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateOracleDbAzureConnectorDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateOracleDbAzureConnectorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateOracleDbAzureConnectorDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateOracleDbAzureConnectorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateOracleDbAzureConnectorDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
