# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccDemandSignalValue(object):
    """
    The Value of Demand Signal for particular month.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OccDemandSignalValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_expected:
            The value to assign to the time_expected property of this OccDemandSignalValue.
        :type time_expected: datetime

        :param value:
            The value to assign to the value property of this OccDemandSignalValue.
        :type value: float

        :param comments:
            The value to assign to the comments property of this OccDemandSignalValue.
        :type comments: str

        """
        self.swagger_types = {
            'time_expected': 'datetime',
            'value': 'float',
            'comments': 'str'
        }
        self.attribute_map = {
            'time_expected': 'timeExpected',
            'value': 'value',
            'comments': 'comments'
        }
        self._time_expected = None
        self._value = None
        self._comments = None

    @property
    def time_expected(self):
        """
        **[Required]** Gets the time_expected of this OccDemandSignalValue.
        The date of the Demand Signal Value.


        :return: The time_expected of this OccDemandSignalValue.
        :rtype: datetime
        """
        return self._time_expected

    @time_expected.setter
    def time_expected(self, time_expected):
        """
        Sets the time_expected of this OccDemandSignalValue.
        The date of the Demand Signal Value.


        :param time_expected: The time_expected of this OccDemandSignalValue.
        :type: datetime
        """
        self._time_expected = time_expected

    @property
    def value(self):
        """
        **[Required]** Gets the value of this OccDemandSignalValue.
        The Demand Signal Value.


        :return: The value of this OccDemandSignalValue.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this OccDemandSignalValue.
        The Demand Signal Value.


        :param value: The value of this OccDemandSignalValue.
        :type: float
        """
        self._value = value

    @property
    def comments(self):
        """
        Gets the comments of this OccDemandSignalValue.
        Space provided for users to make comments regarding the value.


        :return: The comments of this OccDemandSignalValue.
        :rtype: str
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """
        Sets the comments of this OccDemandSignalValue.
        Space provided for users to make comments regarding the value.


        :param comments: The comments of this OccDemandSignalValue.
        :type: str
        """
        self._comments = comments

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
