# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .update_dr_protection_group_member_details import UpdateDrProtectionGroupMemberDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDrProtectionGroupMemberFileSystemDetails(UpdateDrProtectionGroupMemberDetails):
    """
    Update properties for a file system member.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDrProtectionGroupMemberFileSystemDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.disaster_recovery.models.UpdateDrProtectionGroupMemberFileSystemDetails.member_type` attribute
        of this class is ``FILE_SYSTEM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_id:
            The value to assign to the member_id property of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type member_id: str

        :param member_type:
            The value to assign to the member_type property of this UpdateDrProtectionGroupMemberFileSystemDetails.
            Allowed values for this property are: "COMPUTE_INSTANCE", "COMPUTE_INSTANCE_MOVABLE", "COMPUTE_INSTANCE_NON_MOVABLE", "VOLUME_GROUP", "DATABASE", "AUTONOMOUS_DATABASE", "AUTONOMOUS_CONTAINER_DATABASE", "LOAD_BALANCER", "NETWORK_LOAD_BALANCER", "FILE_SYSTEM", "OKE_CLUSTER", "OBJECT_STORAGE_BUCKET", "MYSQL_DB_SYSTEM"
        :type member_type: str

        :param destination_availability_domain:
            The value to assign to the destination_availability_domain property of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type destination_availability_domain: str

        :param export_mappings:
            The value to assign to the export_mappings property of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type export_mappings: list[oci.disaster_recovery.models.FileSystemExportMappingDetails]

        :param destination_encryption_key:
            The value to assign to the destination_encryption_key property of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type destination_encryption_key: oci.disaster_recovery.models.UpdateVaultAndEncryptionKeyDetails

        :param destination_snapshot_policy_id:
            The value to assign to the destination_snapshot_policy_id property of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type destination_snapshot_policy_id: str

        :param destination_compartment_id:
            The value to assign to the destination_compartment_id property of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type destination_compartment_id: str

        """
        self.swagger_types = {
            'member_id': 'str',
            'member_type': 'str',
            'destination_availability_domain': 'str',
            'export_mappings': 'list[FileSystemExportMappingDetails]',
            'destination_encryption_key': 'UpdateVaultAndEncryptionKeyDetails',
            'destination_snapshot_policy_id': 'str',
            'destination_compartment_id': 'str'
        }
        self.attribute_map = {
            'member_id': 'memberId',
            'member_type': 'memberType',
            'destination_availability_domain': 'destinationAvailabilityDomain',
            'export_mappings': 'exportMappings',
            'destination_encryption_key': 'destinationEncryptionKey',
            'destination_snapshot_policy_id': 'destinationSnapshotPolicyId',
            'destination_compartment_id': 'destinationCompartmentId'
        }
        self._member_id = None
        self._member_type = None
        self._destination_availability_domain = None
        self._export_mappings = None
        self._destination_encryption_key = None
        self._destination_snapshot_policy_id = None
        self._destination_compartment_id = None
        self._member_type = 'FILE_SYSTEM'

    @property
    def destination_availability_domain(self):
        """
        Gets the destination_availability_domain of this UpdateDrProtectionGroupMemberFileSystemDetails.
        The availability domain of the destination mount target.

        Example: `BBTh:region-AD`


        :return: The destination_availability_domain of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :rtype: str
        """
        return self._destination_availability_domain

    @destination_availability_domain.setter
    def destination_availability_domain(self, destination_availability_domain):
        """
        Sets the destination_availability_domain of this UpdateDrProtectionGroupMemberFileSystemDetails.
        The availability domain of the destination mount target.

        Example: `BBTh:region-AD`


        :param destination_availability_domain: The destination_availability_domain of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type: str
        """
        self._destination_availability_domain = destination_availability_domain

    @property
    def export_mappings(self):
        """
        Gets the export_mappings of this UpdateDrProtectionGroupMemberFileSystemDetails.
        A list of mappings between file system exports in the primary region and mount targets in the standby region.


        :return: The export_mappings of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :rtype: list[oci.disaster_recovery.models.FileSystemExportMappingDetails]
        """
        return self._export_mappings

    @export_mappings.setter
    def export_mappings(self, export_mappings):
        """
        Sets the export_mappings of this UpdateDrProtectionGroupMemberFileSystemDetails.
        A list of mappings between file system exports in the primary region and mount targets in the standby region.


        :param export_mappings: The export_mappings of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type: list[oci.disaster_recovery.models.FileSystemExportMappingDetails]
        """
        self._export_mappings = export_mappings

    @property
    def destination_encryption_key(self):
        """
        Gets the destination_encryption_key of this UpdateDrProtectionGroupMemberFileSystemDetails.

        :return: The destination_encryption_key of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :rtype: oci.disaster_recovery.models.UpdateVaultAndEncryptionKeyDetails
        """
        return self._destination_encryption_key

    @destination_encryption_key.setter
    def destination_encryption_key(self, destination_encryption_key):
        """
        Sets the destination_encryption_key of this UpdateDrProtectionGroupMemberFileSystemDetails.

        :param destination_encryption_key: The destination_encryption_key of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type: oci.disaster_recovery.models.UpdateVaultAndEncryptionKeyDetails
        """
        self._destination_encryption_key = destination_encryption_key

    @property
    def destination_snapshot_policy_id(self):
        """
        Gets the destination_snapshot_policy_id of this UpdateDrProtectionGroupMemberFileSystemDetails.
        The OCID of the snapshot policy to use in the destination region. This policy will be attached to the file system after it moves to the destination region.

        Example: `ocid1.filesystemsnapshotpolicy.oc1..uniqueID`


        :return: The destination_snapshot_policy_id of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :rtype: str
        """
        return self._destination_snapshot_policy_id

    @destination_snapshot_policy_id.setter
    def destination_snapshot_policy_id(self, destination_snapshot_policy_id):
        """
        Sets the destination_snapshot_policy_id of this UpdateDrProtectionGroupMemberFileSystemDetails.
        The OCID of the snapshot policy to use in the destination region. This policy will be attached to the file system after it moves to the destination region.

        Example: `ocid1.filesystemsnapshotpolicy.oc1..uniqueID`


        :param destination_snapshot_policy_id: The destination_snapshot_policy_id of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type: str
        """
        self._destination_snapshot_policy_id = destination_snapshot_policy_id

    @property
    def destination_compartment_id(self):
        """
        Gets the destination_compartment_id of this UpdateDrProtectionGroupMemberFileSystemDetails.
        The OCID of a compartment in the destination region in which the file system should be launched.

        Example: `ocid1.compartment.oc1..uniqueID`


        :return: The destination_compartment_id of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :rtype: str
        """
        return self._destination_compartment_id

    @destination_compartment_id.setter
    def destination_compartment_id(self, destination_compartment_id):
        """
        Sets the destination_compartment_id of this UpdateDrProtectionGroupMemberFileSystemDetails.
        The OCID of a compartment in the destination region in which the file system should be launched.

        Example: `ocid1.compartment.oc1..uniqueID`


        :param destination_compartment_id: The destination_compartment_id of this UpdateDrProtectionGroupMemberFileSystemDetails.
        :type: str
        """
        self._destination_compartment_id = destination_compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
