# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDistributedAutonomousDatabaseDetails(object):
    """
    Details required for creation of the Globally distributed autonomous database.
    """

    #: A constant which can be used with the sharding_method property of a CreateDistributedAutonomousDatabaseDetails.
    #: This constant has a value of "USER"
    SHARDING_METHOD_USER = "USER"

    #: A constant which can be used with the sharding_method property of a CreateDistributedAutonomousDatabaseDetails.
    #: This constant has a value of "SYSTEM"
    SHARDING_METHOD_SYSTEM = "SYSTEM"

    #: A constant which can be used with the db_workload property of a CreateDistributedAutonomousDatabaseDetails.
    #: This constant has a value of "OLTP"
    DB_WORKLOAD_OLTP = "OLTP"

    #: A constant which can be used with the db_workload property of a CreateDistributedAutonomousDatabaseDetails.
    #: This constant has a value of "DW"
    DB_WORKLOAD_DW = "DW"

    #: A constant which can be used with the replication_method property of a CreateDistributedAutonomousDatabaseDetails.
    #: This constant has a value of "RAFT"
    REPLICATION_METHOD_RAFT = "RAFT"

    #: A constant which can be used with the replication_method property of a CreateDistributedAutonomousDatabaseDetails.
    #: This constant has a value of "DG"
    REPLICATION_METHOD_DG = "DG"

    #: A constant which can be used with the db_deployment_type property of a CreateDistributedAutonomousDatabaseDetails.
    #: This constant has a value of "ADB_D"
    DB_DEPLOYMENT_TYPE_ADB_D = "ADB_D"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDistributedAutonomousDatabaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDistributedAutonomousDatabaseDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateDistributedAutonomousDatabaseDetails.
        :type display_name: str

        :param database_version:
            The value to assign to the database_version property of this CreateDistributedAutonomousDatabaseDetails.
        :type database_version: str

        :param prefix:
            The value to assign to the prefix property of this CreateDistributedAutonomousDatabaseDetails.
        :type prefix: str

        :param private_endpoint_ids:
            The value to assign to the private_endpoint_ids property of this CreateDistributedAutonomousDatabaseDetails.
        :type private_endpoint_ids: list[str]

        :param sharding_method:
            The value to assign to the sharding_method property of this CreateDistributedAutonomousDatabaseDetails.
            Allowed values for this property are: "USER", "SYSTEM"
        :type sharding_method: str

        :param db_workload:
            The value to assign to the db_workload property of this CreateDistributedAutonomousDatabaseDetails.
            Allowed values for this property are: "OLTP", "DW"
        :type db_workload: str

        :param character_set:
            The value to assign to the character_set property of this CreateDistributedAutonomousDatabaseDetails.
        :type character_set: str

        :param ncharacter_set:
            The value to assign to the ncharacter_set property of this CreateDistributedAutonomousDatabaseDetails.
        :type ncharacter_set: str

        :param chunks:
            The value to assign to the chunks property of this CreateDistributedAutonomousDatabaseDetails.
        :type chunks: int

        :param listener_port:
            The value to assign to the listener_port property of this CreateDistributedAutonomousDatabaseDetails.
        :type listener_port: int

        :param listener_port_tls:
            The value to assign to the listener_port_tls property of this CreateDistributedAutonomousDatabaseDetails.
        :type listener_port_tls: int

        :param ons_port_local:
            The value to assign to the ons_port_local property of this CreateDistributedAutonomousDatabaseDetails.
        :type ons_port_local: int

        :param ons_port_remote:
            The value to assign to the ons_port_remote property of this CreateDistributedAutonomousDatabaseDetails.
        :type ons_port_remote: int

        :param replication_method:
            The value to assign to the replication_method property of this CreateDistributedAutonomousDatabaseDetails.
            Allowed values for this property are: "RAFT", "DG"
        :type replication_method: str

        :param replication_factor:
            The value to assign to the replication_factor property of this CreateDistributedAutonomousDatabaseDetails.
        :type replication_factor: int

        :param replication_unit:
            The value to assign to the replication_unit property of this CreateDistributedAutonomousDatabaseDetails.
        :type replication_unit: int

        :param db_deployment_type:
            The value to assign to the db_deployment_type property of this CreateDistributedAutonomousDatabaseDetails.
            Allowed values for this property are: "ADB_D"
        :type db_deployment_type: str

        :param shard_details:
            The value to assign to the shard_details property of this CreateDistributedAutonomousDatabaseDetails.
        :type shard_details: list[oci.distributed_database.models.CreateDistributedAutonomousDatabaseShardDetails]

        :param catalog_details:
            The value to assign to the catalog_details property of this CreateDistributedAutonomousDatabaseDetails.
        :type catalog_details: list[oci.distributed_database.models.CreateDistributedAutonomousDatabaseCatalogDetails]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDistributedAutonomousDatabaseDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDistributedAutonomousDatabaseDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'database_version': 'str',
            'prefix': 'str',
            'private_endpoint_ids': 'list[str]',
            'sharding_method': 'str',
            'db_workload': 'str',
            'character_set': 'str',
            'ncharacter_set': 'str',
            'chunks': 'int',
            'listener_port': 'int',
            'listener_port_tls': 'int',
            'ons_port_local': 'int',
            'ons_port_remote': 'int',
            'replication_method': 'str',
            'replication_factor': 'int',
            'replication_unit': 'int',
            'db_deployment_type': 'str',
            'shard_details': 'list[CreateDistributedAutonomousDatabaseShardDetails]',
            'catalog_details': 'list[CreateDistributedAutonomousDatabaseCatalogDetails]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'database_version': 'databaseVersion',
            'prefix': 'prefix',
            'private_endpoint_ids': 'privateEndpointIds',
            'sharding_method': 'shardingMethod',
            'db_workload': 'dbWorkload',
            'character_set': 'characterSet',
            'ncharacter_set': 'ncharacterSet',
            'chunks': 'chunks',
            'listener_port': 'listenerPort',
            'listener_port_tls': 'listenerPortTls',
            'ons_port_local': 'onsPortLocal',
            'ons_port_remote': 'onsPortRemote',
            'replication_method': 'replicationMethod',
            'replication_factor': 'replicationFactor',
            'replication_unit': 'replicationUnit',
            'db_deployment_type': 'dbDeploymentType',
            'shard_details': 'shardDetails',
            'catalog_details': 'catalogDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._database_version = None
        self._prefix = None
        self._private_endpoint_ids = None
        self._sharding_method = None
        self._db_workload = None
        self._character_set = None
        self._ncharacter_set = None
        self._chunks = None
        self._listener_port = None
        self._listener_port_tls = None
        self._ons_port_local = None
        self._ons_port_remote = None
        self._replication_method = None
        self._replication_factor = None
        self._replication_unit = None
        self._db_deployment_type = None
        self._shard_details = None
        self._catalog_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDistributedAutonomousDatabaseDetails.
        The `OCID`__ of the Globally distributed autonomous database compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDistributedAutonomousDatabaseDetails.
        The `OCID`__ of the Globally distributed autonomous database compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateDistributedAutonomousDatabaseDetails.
        The display name of the Globally distributed autonomous database.


        :return: The display_name of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDistributedAutonomousDatabaseDetails.
        The display name of the Globally distributed autonomous database.


        :param display_name: The display_name of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def database_version(self):
        """
        **[Required]** Gets the database_version of this CreateDistributedAutonomousDatabaseDetails.
        Oracle Database version for the shards and catalog used in Globally distributed autonomous database.


        :return: The database_version of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._database_version

    @database_version.setter
    def database_version(self, database_version):
        """
        Sets the database_version of this CreateDistributedAutonomousDatabaseDetails.
        Oracle Database version for the shards and catalog used in Globally distributed autonomous database.


        :param database_version: The database_version of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        self._database_version = database_version

    @property
    def prefix(self):
        """
        **[Required]** Gets the prefix of this CreateDistributedAutonomousDatabaseDetails.
        Unique name prefix for the Globally distributed autonomous databases. Only alpha-numeric values are allowed. First character
        has to be a letter followed by any combination of letter and number.


        :return: The prefix of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """
        Sets the prefix of this CreateDistributedAutonomousDatabaseDetails.
        Unique name prefix for the Globally distributed autonomous databases. Only alpha-numeric values are allowed. First character
        has to be a letter followed by any combination of letter and number.


        :param prefix: The prefix of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        self._prefix = prefix

    @property
    def private_endpoint_ids(self):
        """
        **[Required]** Gets the private_endpoint_ids of this CreateDistributedAutonomousDatabaseDetails.
        The collection of `OCID`__ of the private endpoint associated with Globally distributed autonomous database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The private_endpoint_ids of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: list[str]
        """
        return self._private_endpoint_ids

    @private_endpoint_ids.setter
    def private_endpoint_ids(self, private_endpoint_ids):
        """
        Sets the private_endpoint_ids of this CreateDistributedAutonomousDatabaseDetails.
        The collection of `OCID`__ of the private endpoint associated with Globally distributed autonomous database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param private_endpoint_ids: The private_endpoint_ids of this CreateDistributedAutonomousDatabaseDetails.
        :type: list[str]
        """
        self._private_endpoint_ids = private_endpoint_ids

    @property
    def sharding_method(self):
        """
        **[Required]** Gets the sharding_method of this CreateDistributedAutonomousDatabaseDetails.
        Sharding Methods for the Globally distributed autonomous database.

        Allowed values for this property are: "USER", "SYSTEM"


        :return: The sharding_method of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._sharding_method

    @sharding_method.setter
    def sharding_method(self, sharding_method):
        """
        Sets the sharding_method of this CreateDistributedAutonomousDatabaseDetails.
        Sharding Methods for the Globally distributed autonomous database.


        :param sharding_method: The sharding_method of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["USER", "SYSTEM"]
        if not value_allowed_none_or_none_sentinel(sharding_method, allowed_values):
            raise ValueError(
                f"Invalid value for `sharding_method`, must be None or one of {allowed_values}"
            )
        self._sharding_method = sharding_method

    @property
    def db_workload(self):
        """
        **[Required]** Gets the db_workload of this CreateDistributedAutonomousDatabaseDetails.
        Possible workload types.

        Allowed values for this property are: "OLTP", "DW"


        :return: The db_workload of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._db_workload

    @db_workload.setter
    def db_workload(self, db_workload):
        """
        Sets the db_workload of this CreateDistributedAutonomousDatabaseDetails.
        Possible workload types.


        :param db_workload: The db_workload of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["OLTP", "DW"]
        if not value_allowed_none_or_none_sentinel(db_workload, allowed_values):
            raise ValueError(
                f"Invalid value for `db_workload`, must be None or one of {allowed_values}"
            )
        self._db_workload = db_workload

    @property
    def character_set(self):
        """
        **[Required]** Gets the character_set of this CreateDistributedAutonomousDatabaseDetails.
        The character set for the database.


        :return: The character_set of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._character_set

    @character_set.setter
    def character_set(self, character_set):
        """
        Sets the character_set of this CreateDistributedAutonomousDatabaseDetails.
        The character set for the database.


        :param character_set: The character_set of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        self._character_set = character_set

    @property
    def ncharacter_set(self):
        """
        **[Required]** Gets the ncharacter_set of this CreateDistributedAutonomousDatabaseDetails.
        The national character set for the database.


        :return: The ncharacter_set of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._ncharacter_set

    @ncharacter_set.setter
    def ncharacter_set(self, ncharacter_set):
        """
        Sets the ncharacter_set of this CreateDistributedAutonomousDatabaseDetails.
        The national character set for the database.


        :param ncharacter_set: The ncharacter_set of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        self._ncharacter_set = ncharacter_set

    @property
    def chunks(self):
        """
        Gets the chunks of this CreateDistributedAutonomousDatabaseDetails.
        The default number of unique chunks in a shardspace. The value of chunks must be
        greater than 2 times the size of the largest shardgroup in any shardspace.


        :return: The chunks of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._chunks

    @chunks.setter
    def chunks(self, chunks):
        """
        Sets the chunks of this CreateDistributedAutonomousDatabaseDetails.
        The default number of unique chunks in a shardspace. The value of chunks must be
        greater than 2 times the size of the largest shardgroup in any shardspace.


        :param chunks: The chunks of this CreateDistributedAutonomousDatabaseDetails.
        :type: int
        """
        self._chunks = chunks

    @property
    def listener_port(self):
        """
        **[Required]** Gets the listener_port of this CreateDistributedAutonomousDatabaseDetails.
        The listener port number for the Globally distributed autonomous database.


        :return: The listener_port of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._listener_port

    @listener_port.setter
    def listener_port(self, listener_port):
        """
        Sets the listener_port of this CreateDistributedAutonomousDatabaseDetails.
        The listener port number for the Globally distributed autonomous database.


        :param listener_port: The listener_port of this CreateDistributedAutonomousDatabaseDetails.
        :type: int
        """
        self._listener_port = listener_port

    @property
    def listener_port_tls(self):
        """
        Gets the listener_port_tls of this CreateDistributedAutonomousDatabaseDetails.
        The TLS listener port number for Globally distributed autonomous database.


        :return: The listener_port_tls of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._listener_port_tls

    @listener_port_tls.setter
    def listener_port_tls(self, listener_port_tls):
        """
        Sets the listener_port_tls of this CreateDistributedAutonomousDatabaseDetails.
        The TLS listener port number for Globally distributed autonomous database.


        :param listener_port_tls: The listener_port_tls of this CreateDistributedAutonomousDatabaseDetails.
        :type: int
        """
        self._listener_port_tls = listener_port_tls

    @property
    def ons_port_local(self):
        """
        **[Required]** Gets the ons_port_local of this CreateDistributedAutonomousDatabaseDetails.
        Ons local port number.


        :return: The ons_port_local of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._ons_port_local

    @ons_port_local.setter
    def ons_port_local(self, ons_port_local):
        """
        Sets the ons_port_local of this CreateDistributedAutonomousDatabaseDetails.
        Ons local port number.


        :param ons_port_local: The ons_port_local of this CreateDistributedAutonomousDatabaseDetails.
        :type: int
        """
        self._ons_port_local = ons_port_local

    @property
    def ons_port_remote(self):
        """
        **[Required]** Gets the ons_port_remote of this CreateDistributedAutonomousDatabaseDetails.
        Ons remote port number.


        :return: The ons_port_remote of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._ons_port_remote

    @ons_port_remote.setter
    def ons_port_remote(self, ons_port_remote):
        """
        Sets the ons_port_remote of this CreateDistributedAutonomousDatabaseDetails.
        Ons remote port number.


        :param ons_port_remote: The ons_port_remote of this CreateDistributedAutonomousDatabaseDetails.
        :type: int
        """
        self._ons_port_remote = ons_port_remote

    @property
    def replication_method(self):
        """
        Gets the replication_method of this CreateDistributedAutonomousDatabaseDetails.
        The Replication method for Globally distributed autonomous database. Use RAFT for Raft replication, and DG for
        DataGuard. If replicationMethod is not provided, it defaults to DG.

        Allowed values for this property are: "RAFT", "DG"


        :return: The replication_method of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._replication_method

    @replication_method.setter
    def replication_method(self, replication_method):
        """
        Sets the replication_method of this CreateDistributedAutonomousDatabaseDetails.
        The Replication method for Globally distributed autonomous database. Use RAFT for Raft replication, and DG for
        DataGuard. If replicationMethod is not provided, it defaults to DG.


        :param replication_method: The replication_method of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["RAFT", "DG"]
        if not value_allowed_none_or_none_sentinel(replication_method, allowed_values):
            raise ValueError(
                f"Invalid value for `replication_method`, must be None or one of {allowed_values}"
            )
        self._replication_method = replication_method

    @property
    def replication_factor(self):
        """
        Gets the replication_factor of this CreateDistributedAutonomousDatabaseDetails.
        The Replication factor for RAFT replication based Globally distributed autonomous database. Currently supported values are 3, 5 and 7.


        :return: The replication_factor of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._replication_factor

    @replication_factor.setter
    def replication_factor(self, replication_factor):
        """
        Sets the replication_factor of this CreateDistributedAutonomousDatabaseDetails.
        The Replication factor for RAFT replication based Globally distributed autonomous database. Currently supported values are 3, 5 and 7.


        :param replication_factor: The replication_factor of this CreateDistributedAutonomousDatabaseDetails.
        :type: int
        """
        self._replication_factor = replication_factor

    @property
    def replication_unit(self):
        """
        Gets the replication_unit of this CreateDistributedAutonomousDatabaseDetails.
        For RAFT replication based Globally distributed autonomous database, the value should be atleast twice the number of shards.


        :return: The replication_unit of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._replication_unit

    @replication_unit.setter
    def replication_unit(self, replication_unit):
        """
        Sets the replication_unit of this CreateDistributedAutonomousDatabaseDetails.
        For RAFT replication based Globally distributed autonomous database, the value should be atleast twice the number of shards.


        :param replication_unit: The replication_unit of this CreateDistributedAutonomousDatabaseDetails.
        :type: int
        """
        self._replication_unit = replication_unit

    @property
    def db_deployment_type(self):
        """
        **[Required]** Gets the db_deployment_type of this CreateDistributedAutonomousDatabaseDetails.
        The distributed autonomous database deployment type.

        Allowed values for this property are: "ADB_D"


        :return: The db_deployment_type of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._db_deployment_type

    @db_deployment_type.setter
    def db_deployment_type(self, db_deployment_type):
        """
        Sets the db_deployment_type of this CreateDistributedAutonomousDatabaseDetails.
        The distributed autonomous database deployment type.


        :param db_deployment_type: The db_deployment_type of this CreateDistributedAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["ADB_D"]
        if not value_allowed_none_or_none_sentinel(db_deployment_type, allowed_values):
            raise ValueError(
                f"Invalid value for `db_deployment_type`, must be None or one of {allowed_values}"
            )
        self._db_deployment_type = db_deployment_type

    @property
    def shard_details(self):
        """
        **[Required]** Gets the shard_details of this CreateDistributedAutonomousDatabaseDetails.
        Collection of shards for the Globally distributed autonomous database.


        :return: The shard_details of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: list[oci.distributed_database.models.CreateDistributedAutonomousDatabaseShardDetails]
        """
        return self._shard_details

    @shard_details.setter
    def shard_details(self, shard_details):
        """
        Sets the shard_details of this CreateDistributedAutonomousDatabaseDetails.
        Collection of shards for the Globally distributed autonomous database.


        :param shard_details: The shard_details of this CreateDistributedAutonomousDatabaseDetails.
        :type: list[oci.distributed_database.models.CreateDistributedAutonomousDatabaseShardDetails]
        """
        self._shard_details = shard_details

    @property
    def catalog_details(self):
        """
        **[Required]** Gets the catalog_details of this CreateDistributedAutonomousDatabaseDetails.
        Collection of catalog for the Globally distributed autonomous database.


        :return: The catalog_details of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: list[oci.distributed_database.models.CreateDistributedAutonomousDatabaseCatalogDetails]
        """
        return self._catalog_details

    @catalog_details.setter
    def catalog_details(self, catalog_details):
        """
        Sets the catalog_details of this CreateDistributedAutonomousDatabaseDetails.
        Collection of catalog for the Globally distributed autonomous database.


        :param catalog_details: The catalog_details of this CreateDistributedAutonomousDatabaseDetails.
        :type: list[oci.distributed_database.models.CreateDistributedAutonomousDatabaseCatalogDetails]
        """
        self._catalog_details = catalog_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDistributedAutonomousDatabaseDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDistributedAutonomousDatabaseDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateDistributedAutonomousDatabaseDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDistributedAutonomousDatabaseDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateDistributedAutonomousDatabaseDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDistributedAutonomousDatabaseDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateDistributedAutonomousDatabaseDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
