# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDistributedDatabaseCatalogDetails(object):
    """
    Details of the Globally distributed database catalog.
    """

    #: A constant which can be used with the source property of a CreateDistributedDatabaseCatalogDetails.
    #: This constant has a value of "EXADB_XS"
    SOURCE_EXADB_XS = "EXADB_XS"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDistributedDatabaseCatalogDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.distributed_database.models.CreateDistributedDatabaseCatalogWithExadbXsDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source:
            The value to assign to the source property of this CreateDistributedDatabaseCatalogDetails.
            Allowed values for this property are: "EXADB_XS"
        :type source: str

        """
        self.swagger_types = {
            'source': 'str'
        }
        self.attribute_map = {
            'source': 'source'
        }
        self._source = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['source']

        if type == 'EXADB_XS':
            return 'CreateDistributedDatabaseCatalogWithExadbXsDetails'
        else:
            return 'CreateDistributedDatabaseCatalogDetails'

    @property
    def source(self):
        """
        **[Required]** Gets the source of this CreateDistributedDatabaseCatalogDetails.
        The source of Globally distributed database type: Use EXADB_XS for the Globally distributed database with Exascale based distributed database.

        Allowed values for this property are: "EXADB_XS"


        :return: The source of this CreateDistributedDatabaseCatalogDetails.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this CreateDistributedDatabaseCatalogDetails.
        The source of Globally distributed database type: Use EXADB_XS for the Globally distributed database with Exascale based distributed database.


        :param source: The source of this CreateDistributedDatabaseCatalogDetails.
        :type: str
        """
        allowed_values = ["EXADB_XS"]
        if not value_allowed_none_or_none_sentinel(source, allowed_values):
            raise ValueError(
                f"Invalid value for `source`, must be None or one of {allowed_values}"
            )
        self._source = source

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
