# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20171215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ToggleQuotaRulesDetails(object):
    """
    Details for enabling or disabling quota enforcement in the file system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ToggleQuotaRulesDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param are_quota_rules_enabled:
            The value to assign to the are_quota_rules_enabled property of this ToggleQuotaRulesDetails.
        :type are_quota_rules_enabled: bool

        """
        self.swagger_types = {
            'are_quota_rules_enabled': 'bool'
        }
        self.attribute_map = {
            'are_quota_rules_enabled': 'areQuotaRulesEnabled'
        }
        self._are_quota_rules_enabled = None

    @property
    def are_quota_rules_enabled(self):
        """
        **[Required]** Gets the are_quota_rules_enabled of this ToggleQuotaRulesDetails.
        Specifies the enforcement of quota rules on the file system.


        :return: The are_quota_rules_enabled of this ToggleQuotaRulesDetails.
        :rtype: bool
        """
        return self._are_quota_rules_enabled

    @are_quota_rules_enabled.setter
    def are_quota_rules_enabled(self, are_quota_rules_enabled):
        """
        Sets the are_quota_rules_enabled of this ToggleQuotaRulesDetails.
        Specifies the enforcement of quota rules on the file system.


        :param are_quota_rules_enabled: The are_quota_rules_enabled of this ToggleQuotaRulesDetails.
        :type: bool
        """
        self._are_quota_rules_enabled = are_quota_rules_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
