# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FleetDetails(object):
    """
    Fleet Type
    """

    #: A constant which can be used with the fleet_type property of a FleetDetails.
    #: This constant has a value of "GENERIC"
    FLEET_TYPE_GENERIC = "GENERIC"

    #: A constant which can be used with the fleet_type property of a FleetDetails.
    #: This constant has a value of "PRODUCT"
    FLEET_TYPE_PRODUCT = "PRODUCT"

    #: A constant which can be used with the fleet_type property of a FleetDetails.
    #: This constant has a value of "ENVIRONMENT"
    FLEET_TYPE_ENVIRONMENT = "ENVIRONMENT"

    #: A constant which can be used with the fleet_type property of a FleetDetails.
    #: This constant has a value of "GROUP"
    FLEET_TYPE_GROUP = "GROUP"

    def __init__(self, **kwargs):
        """
        Initializes a new FleetDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.GroupFleetDetails`
        * :class:`~oci.fleet_apps_management.models.ProductFleetDetails`
        * :class:`~oci.fleet_apps_management.models.GenericFleetDetails`
        * :class:`~oci.fleet_apps_management.models.EnvironmentFleetDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param fleet_type:
            The value to assign to the fleet_type property of this FleetDetails.
            Allowed values for this property are: "GENERIC", "PRODUCT", "ENVIRONMENT", "GROUP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type fleet_type: str

        """
        self.swagger_types = {
            'fleet_type': 'str'
        }
        self.attribute_map = {
            'fleet_type': 'fleetType'
        }
        self._fleet_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['fleetType']

        if type == 'GROUP':
            return 'GroupFleetDetails'

        if type == 'PRODUCT':
            return 'ProductFleetDetails'

        if type == 'GENERIC':
            return 'GenericFleetDetails'

        if type == 'ENVIRONMENT':
            return 'EnvironmentFleetDetails'
        else:
            return 'FleetDetails'

    @property
    def fleet_type(self):
        """
        Gets the fleet_type of this FleetDetails.
        Type of the Fleet.
        PRODUCT - A fleet of product-specific resources for a product type.
        ENVIRONMENT - A fleet of environment-specific resources for a product stack.
        GROUP - A fleet of a fleet of either environment or product fleets.
        GENERIC - A fleet of resources selected dynamically or manually for reporting purposes

        Allowed values for this property are: "GENERIC", "PRODUCT", "ENVIRONMENT", "GROUP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The fleet_type of this FleetDetails.
        :rtype: str
        """
        return self._fleet_type

    @fleet_type.setter
    def fleet_type(self, fleet_type):
        """
        Sets the fleet_type of this FleetDetails.
        Type of the Fleet.
        PRODUCT - A fleet of product-specific resources for a product type.
        ENVIRONMENT - A fleet of environment-specific resources for a product stack.
        GROUP - A fleet of a fleet of either environment or product fleets.
        GENERIC - A fleet of resources selected dynamically or manually for reporting purposes


        :param fleet_type: The fleet_type of this FleetDetails.
        :type: str
        """
        allowed_values = ["GENERIC", "PRODUCT", "ENVIRONMENT", "GROUP"]
        if not value_allowed_none_or_none_sentinel(fleet_type, allowed_values):
            fleet_type = 'UNKNOWN_ENUM_VALUE'
        self._fleet_type = fleet_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
