# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .guest_os_fleet_discovery_filter import GuestOsFleetDiscoveryFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuestOsExadataReleaseVersionFilter(GuestOsFleetDiscoveryFilter):
    """
    Exadata Release versions to include when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.
    Only release versions related to the specified sourceMajorVersion are allowed.
    """

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_5_11_1"
    EXADATA_RELEASES_EXA_OL_5_11_1 = "EXA_OL_5_11_1"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_5_11_2"
    EXADATA_RELEASES_EXA_OL_5_11_2 = "EXA_OL_5_11_2"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_5_12_1"
    EXADATA_RELEASES_EXA_OL_5_12_1 = "EXA_OL_5_12_1"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_6_12_2"
    EXADATA_RELEASES_EXA_OL_6_12_2 = "EXA_OL_6_12_2"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_6_18_1"
    EXADATA_RELEASES_EXA_OL_6_18_1 = "EXA_OL_6_18_1"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_7_19_1"
    EXADATA_RELEASES_EXA_OL_7_19_1 = "EXA_OL_7_19_1"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_7_19_2"
    EXADATA_RELEASES_EXA_OL_7_19_2 = "EXA_OL_7_19_2"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_7_19_3"
    EXADATA_RELEASES_EXA_OL_7_19_3 = "EXA_OL_7_19_3"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_7_20_1"
    EXADATA_RELEASES_EXA_OL_7_20_1 = "EXA_OL_7_20_1"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_7_21_2"
    EXADATA_RELEASES_EXA_OL_7_21_2 = "EXA_OL_7_21_2"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_7_22_1"
    EXADATA_RELEASES_EXA_OL_7_22_1 = "EXA_OL_7_22_1"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_8_23_1"
    EXADATA_RELEASES_EXA_OL_8_23_1 = "EXA_OL_8_23_1"

    #: A constant which can be used with the exadata_releases property of a GuestOsExadataReleaseVersionFilter.
    #: This constant has a value of "EXA_OL_8_24_1"
    EXADATA_RELEASES_EXA_OL_8_24_1 = "EXA_OL_8_24_1"

    def __init__(self, **kwargs):
        """
        Initializes a new GuestOsExadataReleaseVersionFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.GuestOsExadataReleaseVersionFilter.type` attribute
        of this class is ``EXADATA_RELEASE_VERSION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this GuestOsExadataReleaseVersionFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "VERSION", "EXADATA_RELEASE_VERSION", "FREEFORM_TAG", "DEFINED_TAG", "RESOURCE_ID", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param mode:
            The value to assign to the mode property of this GuestOsExadataReleaseVersionFilter.
            Allowed values for this property are: "INCLUDE", "EXCLUDE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type mode: str

        :param exadata_releases:
            The value to assign to the exadata_releases property of this GuestOsExadataReleaseVersionFilter.
            Allowed values for items in this list are: "EXA_OL_5_11_1", "EXA_OL_5_11_2", "EXA_OL_5_12_1", "EXA_OL_6_12_2", "EXA_OL_6_18_1", "EXA_OL_7_19_1", "EXA_OL_7_19_2", "EXA_OL_7_19_3", "EXA_OL_7_20_1", "EXA_OL_7_21_2", "EXA_OL_7_22_1", "EXA_OL_8_23_1", "EXA_OL_8_24_1", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type exadata_releases: list[str]

        """
        self.swagger_types = {
            'type': 'str',
            'mode': 'str',
            'exadata_releases': 'list[str]'
        }
        self.attribute_map = {
            'type': 'type',
            'mode': 'mode',
            'exadata_releases': 'exadataReleases'
        }
        self._type = None
        self._mode = None
        self._exadata_releases = None
        self._type = 'EXADATA_RELEASE_VERSION'

    @property
    def exadata_releases(self):
        """
        **[Required]** Gets the exadata_releases of this GuestOsExadataReleaseVersionFilter.
        List of Exadata Release versions to include when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.

        Allowed values for items in this list are: "EXA_OL_5_11_1", "EXA_OL_5_11_2", "EXA_OL_5_12_1", "EXA_OL_6_12_2", "EXA_OL_6_18_1", "EXA_OL_7_19_1", "EXA_OL_7_19_2", "EXA_OL_7_19_3", "EXA_OL_7_20_1", "EXA_OL_7_21_2", "EXA_OL_7_22_1", "EXA_OL_8_23_1", "EXA_OL_8_24_1", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The exadata_releases of this GuestOsExadataReleaseVersionFilter.
        :rtype: list[str]
        """
        return self._exadata_releases

    @exadata_releases.setter
    def exadata_releases(self, exadata_releases):
        """
        Sets the exadata_releases of this GuestOsExadataReleaseVersionFilter.
        List of Exadata Release versions to include when discovering Exadata VM Cluster targets for a 'GUEST_OS' collection.


        :param exadata_releases: The exadata_releases of this GuestOsExadataReleaseVersionFilter.
        :type: list[str]
        """
        allowed_values = ["EXA_OL_5_11_1", "EXA_OL_5_11_2", "EXA_OL_5_12_1", "EXA_OL_6_12_2", "EXA_OL_6_18_1", "EXA_OL_7_19_1", "EXA_OL_7_19_2", "EXA_OL_7_19_3", "EXA_OL_7_20_1", "EXA_OL_7_21_2", "EXA_OL_7_22_1", "EXA_OL_8_23_1", "EXA_OL_8_24_1"]
        if exadata_releases:
            exadata_releases[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in exadata_releases]
        self._exadata_releases = exadata_releases

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
