# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HttpEndpointAuthConfig(object):
    """
    Authentication configuration used for HTTP Endpoint tools. Defines the type of authentication
    and the source of credentials.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HttpEndpointAuthConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param http_endpoint_auth_sources:
            The value to assign to the http_endpoint_auth_sources property of this HttpEndpointAuthConfig.
        :type http_endpoint_auth_sources: list[oci.generative_ai_agent.models.HttpEndpointAuthSource]

        """
        self.swagger_types = {
            'http_endpoint_auth_sources': 'list[HttpEndpointAuthSource]'
        }
        self.attribute_map = {
            'http_endpoint_auth_sources': 'httpEndpointAuthSources'
        }
        self._http_endpoint_auth_sources = None

    @property
    def http_endpoint_auth_sources(self):
        """
        **[Required]** Gets the http_endpoint_auth_sources of this HttpEndpointAuthConfig.
        A list of credential sources from which authentication credentials can be resolved.
        Only AGENT is supported for HTTP Endpoint Tool.


        :return: The http_endpoint_auth_sources of this HttpEndpointAuthConfig.
        :rtype: list[oci.generative_ai_agent.models.HttpEndpointAuthSource]
        """
        return self._http_endpoint_auth_sources

    @http_endpoint_auth_sources.setter
    def http_endpoint_auth_sources(self, http_endpoint_auth_sources):
        """
        Sets the http_endpoint_auth_sources of this HttpEndpointAuthConfig.
        A list of credential sources from which authentication credentials can be resolved.
        Only AGENT is supported for HTTP Endpoint Tool.


        :param http_endpoint_auth_sources: The http_endpoint_auth_sources of this HttpEndpointAuthConfig.
        :type: list[oci.generative_ai_agent.models.HttpEndpointAuthSource]
        """
        self._http_endpoint_auth_sources = http_endpoint_auth_sources

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
