# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from __future__ import absolute_import

from .annotation import Annotation
from .apply_guardrails_details import ApplyGuardrailsDetails
from .apply_guardrails_result import ApplyGuardrailsResult
from .approximate_location import ApproximateLocation
from .assistant_message import AssistantMessage
from .audio_content import AudioContent
from .audio_url import AudioUrl
from .base_chat_request import BaseChatRequest
from .base_chat_response import BaseChatResponse
from .category_score import CategoryScore
from .chat_choice import ChatChoice
from .chat_content import ChatContent
from .chat_details import ChatDetails
from .chat_result import ChatResult
from .choice import Choice
from .citation import Citation
from .cohere_chat_bot_message import CohereChatBotMessage
from .cohere_chat_request import CohereChatRequest
from .cohere_chat_response import CohereChatResponse
from .cohere_llm_inference_request import CohereLlmInferenceRequest
from .cohere_llm_inference_response import CohereLlmInferenceResponse
from .cohere_message import CohereMessage
from .cohere_parameter_definition import CohereParameterDefinition
from .cohere_response_format import CohereResponseFormat
from .cohere_response_json_format import CohereResponseJsonFormat
from .cohere_response_text_format import CohereResponseTextFormat
from .cohere_system_message import CohereSystemMessage
from .cohere_tool import CohereTool
from .cohere_tool_call import CohereToolCall
from .cohere_tool_message import CohereToolMessage
from .cohere_tool_result import CohereToolResult
from .cohere_user_message import CohereUserMessage
from .completion_tokens_details import CompletionTokensDetails
from .content_moderation_configuration import ContentModerationConfiguration
from .content_moderation_result import ContentModerationResult
from .dedicated_serving_mode import DedicatedServingMode
from .developer_message import DeveloperMessage
from .document import Document
from .document_rank import DocumentRank
from .embed_text_details import EmbedTextDetails
from .embed_text_result import EmbedTextResult
from .function_call import FunctionCall
from .function_definition import FunctionDefinition
from .generate_text_details import GenerateTextDetails
from .generate_text_result import GenerateTextResult
from .generated_text import GeneratedText
from .generic_chat_request import GenericChatRequest
from .generic_chat_response import GenericChatResponse
from .grounding_chunk import GroundingChunk
from .grounding_metadata import GroundingMetadata
from .grounding_support import GroundingSupport
from .grounding_support_segment import GroundingSupportSegment
from .grounding_web_chunk import GroundingWebChunk
from .guardrail_configs import GuardrailConfigs
from .guardrails_input import GuardrailsInput
from .guardrails_results import GuardrailsResults
from .guardrails_text_input import GuardrailsTextInput
from .image_content import ImageContent
from .image_url import ImageUrl
from .json_object_response_format import JsonObjectResponseFormat
from .json_schema_response_format import JsonSchemaResponseFormat
from .llama_llm_inference_request import LlamaLlmInferenceRequest
from .llama_llm_inference_response import LlamaLlmInferenceResponse
from .llm_inference_request import LlmInferenceRequest
from .llm_inference_response import LlmInferenceResponse
from .logprobs import Logprobs
from .message import Message
from .on_demand_serving_mode import OnDemandServingMode
from .personally_identifiable_information_configuration import PersonallyIdentifiableInformationConfiguration
from .personally_identifiable_information_result import PersonallyIdentifiableInformationResult
from .prediction import Prediction
from .prompt_injection_configuration import PromptInjectionConfiguration
from .prompt_injection_protection_result import PromptInjectionProtectionResult
from .prompt_tokens_details import PromptTokensDetails
from .rerank_text_details import RerankTextDetails
from .rerank_text_result import RerankTextResult
from .response_format import ResponseFormat
from .response_json_schema import ResponseJsonSchema
from .search_entry_point import SearchEntryPoint
from .search_query import SearchQuery
from .serving_mode import ServingMode
from .static_content import StaticContent
from .stream_options import StreamOptions
from .summarize_text_details import SummarizeTextDetails
from .summarize_text_result import SummarizeTextResult
from .system_message import SystemMessage
from .text_content import TextContent
from .text_response_format import TextResponseFormat
from .token_likelihood import TokenLikelihood
from .tool_call import ToolCall
from .tool_choice import ToolChoice
from .tool_choice_auto import ToolChoiceAuto
from .tool_choice_function import ToolChoiceFunction
from .tool_choice_none import ToolChoiceNone
from .tool_choice_required import ToolChoiceRequired
from .tool_definition import ToolDefinition
from .tool_message import ToolMessage
from .url_citation import UrlCitation
from .usage import Usage
from .user_message import UserMessage
from .video_content import VideoContent
from .video_url import VideoUrl
from .web_search_options import WebSearchOptions

# Maps type names to classes for generative_ai_inference services.
generative_ai_inference_type_mapping = {
    "Annotation": Annotation,
    "ApplyGuardrailsDetails": ApplyGuardrailsDetails,
    "ApplyGuardrailsResult": ApplyGuardrailsResult,
    "ApproximateLocation": ApproximateLocation,
    "AssistantMessage": AssistantMessage,
    "AudioContent": AudioContent,
    "AudioUrl": AudioUrl,
    "BaseChatRequest": BaseChatRequest,
    "BaseChatResponse": BaseChatResponse,
    "CategoryScore": CategoryScore,
    "ChatChoice": ChatChoice,
    "ChatContent": ChatContent,
    "ChatDetails": ChatDetails,
    "ChatResult": ChatResult,
    "Choice": Choice,
    "Citation": Citation,
    "CohereChatBotMessage": CohereChatBotMessage,
    "CohereChatRequest": CohereChatRequest,
    "CohereChatResponse": CohereChatResponse,
    "CohereLlmInferenceRequest": CohereLlmInferenceRequest,
    "CohereLlmInferenceResponse": CohereLlmInferenceResponse,
    "CohereMessage": CohereMessage,
    "CohereParameterDefinition": CohereParameterDefinition,
    "CohereResponseFormat": CohereResponseFormat,
    "CohereResponseJsonFormat": CohereResponseJsonFormat,
    "CohereResponseTextFormat": CohereResponseTextFormat,
    "CohereSystemMessage": CohereSystemMessage,
    "CohereTool": CohereTool,
    "CohereToolCall": CohereToolCall,
    "CohereToolMessage": CohereToolMessage,
    "CohereToolResult": CohereToolResult,
    "CohereUserMessage": CohereUserMessage,
    "CompletionTokensDetails": CompletionTokensDetails,
    "ContentModerationConfiguration": ContentModerationConfiguration,
    "ContentModerationResult": ContentModerationResult,
    "DedicatedServingMode": DedicatedServingMode,
    "DeveloperMessage": DeveloperMessage,
    "Document": Document,
    "DocumentRank": DocumentRank,
    "EmbedTextDetails": EmbedTextDetails,
    "EmbedTextResult": EmbedTextResult,
    "FunctionCall": FunctionCall,
    "FunctionDefinition": FunctionDefinition,
    "GenerateTextDetails": GenerateTextDetails,
    "GenerateTextResult": GenerateTextResult,
    "GeneratedText": GeneratedText,
    "GenericChatRequest": GenericChatRequest,
    "GenericChatResponse": GenericChatResponse,
    "GroundingChunk": GroundingChunk,
    "GroundingMetadata": GroundingMetadata,
    "GroundingSupport": GroundingSupport,
    "GroundingSupportSegment": GroundingSupportSegment,
    "GroundingWebChunk": GroundingWebChunk,
    "GuardrailConfigs": GuardrailConfigs,
    "GuardrailsInput": GuardrailsInput,
    "GuardrailsResults": GuardrailsResults,
    "GuardrailsTextInput": GuardrailsTextInput,
    "ImageContent": ImageContent,
    "ImageUrl": ImageUrl,
    "JsonObjectResponseFormat": JsonObjectResponseFormat,
    "JsonSchemaResponseFormat": JsonSchemaResponseFormat,
    "LlamaLlmInferenceRequest": LlamaLlmInferenceRequest,
    "LlamaLlmInferenceResponse": LlamaLlmInferenceResponse,
    "LlmInferenceRequest": LlmInferenceRequest,
    "LlmInferenceResponse": LlmInferenceResponse,
    "Logprobs": Logprobs,
    "Message": Message,
    "OnDemandServingMode": OnDemandServingMode,
    "PersonallyIdentifiableInformationConfiguration": PersonallyIdentifiableInformationConfiguration,
    "PersonallyIdentifiableInformationResult": PersonallyIdentifiableInformationResult,
    "Prediction": Prediction,
    "PromptInjectionConfiguration": PromptInjectionConfiguration,
    "PromptInjectionProtectionResult": PromptInjectionProtectionResult,
    "PromptTokensDetails": PromptTokensDetails,
    "RerankTextDetails": RerankTextDetails,
    "RerankTextResult": RerankTextResult,
    "ResponseFormat": ResponseFormat,
    "ResponseJsonSchema": ResponseJsonSchema,
    "SearchEntryPoint": SearchEntryPoint,
    "SearchQuery": SearchQuery,
    "ServingMode": ServingMode,
    "StaticContent": StaticContent,
    "StreamOptions": StreamOptions,
    "SummarizeTextDetails": SummarizeTextDetails,
    "SummarizeTextResult": SummarizeTextResult,
    "SystemMessage": SystemMessage,
    "TextContent": TextContent,
    "TextResponseFormat": TextResponseFormat,
    "TokenLikelihood": TokenLikelihood,
    "ToolCall": ToolCall,
    "ToolChoice": ToolChoice,
    "ToolChoiceAuto": ToolChoiceAuto,
    "ToolChoiceFunction": ToolChoiceFunction,
    "ToolChoiceNone": ToolChoiceNone,
    "ToolChoiceRequired": ToolChoiceRequired,
    "ToolDefinition": ToolDefinition,
    "ToolMessage": ToolMessage,
    "UrlCitation": UrlCitation,
    "Usage": Usage,
    "UserMessage": UserMessage,
    "VideoContent": VideoContent,
    "VideoUrl": VideoUrl,
    "WebSearchOptions": WebSearchOptions
}
