# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GroundingChunk(object):
    """
    object containing the source.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GroundingChunk object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param web:
            The value to assign to the web property of this GroundingChunk.
        :type web: oci.generative_ai_inference.models.GroundingWebChunk

        """
        self.swagger_types = {
            'web': 'GroundingWebChunk'
        }
        self.attribute_map = {
            'web': 'web'
        }
        self._web = None

    @property
    def web(self):
        """
        Gets the web of this GroundingChunk.

        :return: The web of this GroundingChunk.
        :rtype: oci.generative_ai_inference.models.GroundingWebChunk
        """
        return self._web

    @web.setter
    def web(self, web):
        """
        Sets the web of this GroundingChunk.

        :param web: The web of this GroundingChunk.
        :type: oci.generative_ai_inference.models.GroundingWebChunk
        """
        self._web = web

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
